#!/usr/bin/perl
#  Copyright 2001-2018 Leslie Richardson
#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; version 2 of 
#  the License, only.


my %lex = ('Error' => 'Error',
	   'Main' => 'Main',
	   'Date' => 'Date',
	   'Topic' => 'Topic',
	   'Description' => 'Description',
	   'Delete' => 'Delete',
	   'Record' => 'Record',
	   'Deleted' => 'Deleted',
	   'Announcements' => 'Announcements',
	   'Top' => 'Top',
	   'Yes' => 'Yes',
	   'Type' => 'Type',
	   'No Record(s) Found' => 'No Record(s) Found',
	   'Author' => 'Author',

	   );

my $self = 'announcedelete.pl';

use DBI;
use CGI;
use Time::JulianDay;


eval require "../../etc/admin.conf";
if ( $@ ) {
    print qq{$lex{Error} $@<br>\n};
    die qq{$lex{Error}  $@<br>\n};
}

my $q = new CGI;
my %arr = $q->Vars;
print $q->header( -charset, $charset );


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Set Page Title
my $title = "$lex{Delete} $lex{Announcements}";


# HTML Page Header
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};
print qq{$chartype\n</head><body style="padding: 1em 2em;">\n};

print qq{[ <a href="$homepage">$lex{Main}</a> ]\n};
print qq{<h1>$title</h1>\n};


if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    deleteRecord();
}



#----------------
sub showStartPage {
#----------------

    my $sth = $dbh->prepare("select * from announce order by adate ");
    $sth->execute;
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

    # Start the Form
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};

    my $first = 1;

    while ( my $ref = $sth->fetchrow_hashref ) { # load records

	my %rec;
	%rec = %$ref;

	if ( $first ) {
	    # Start Table
	    print qq{<table cellpadding="3" cellspacing="0" border="1">\n};
	    print qq{<tr><th></th><th>$lex{Date}</th><th>$lex{Topic}</th><th>$lex{Author}</th>};
	    print qq{<th>$lex{Description}</th><th>$lex{Top}</th><th>$lex{Type}</th></tr>\n};
	    print qq{<tr><td colspan="8" class="la">};
	    print qq{<input type="submit" value="Delete Selected Records"></td></tr>\n};
	    $first = 0;
	}

	print qq{<tr><td><input type="checkbox" name="$rec{id}" value="1"></td>\n};
	print qq{<td class="la">$rec{adate}</td>};
	print qq{<td class="la">$rec{atopic}</td>\n};
	print qq{<td class="la">$rec{author}</td>\n};
	print qq{<td class="la">$rec{adesc}</td>\n};

	if ( $rec{topstay} ) { $rec{topstay} = $lex{Yes}; }
	print qq{<td class="la">$rec{topstay}</td>\n};
	print qq{<td class="la">$rec{atype}</td></tr>\n};


    
    }

    if ( $first ) {
	print qq{<h3>$lex{'No Record(s) Found'}</h3>\n};
    } else {
	print qq{<tr><td colspan="8" class="la"><input type="submit" value="Delete Selected Records"></td></tr>\n};
	print qq{</table></form>\n};
    }

	

    print qq{</body></html>\n};
    exit;

}


#---------------
sub deleteRecord {
#---------------

    # foreach my $key ( sort keys %arr) { print qq{K:$key V:$arr{$key}<br>\n}; }
    
    my $sth = $dbh->prepare("delete from announce where id = ?");

    foreach my $key ( sort keys %arr) {
    	$sth->execute( $key );
    }

    if ( $DBI::errstr ) {
	print qq{<h3>$lex{Error}: $DBI::errstr</h3>\n};
	
    } else {
	print qq{<h3>$lex{Record} $lex{Deleted}</h3>\n};
    }

    print qq{<p>[ <a href="$self">$title</a> ]</p>\n};
    print qq{</body></html>\n};

    exit;

}
