#!/usr/bin/perl
#  Copyright 2001-2022 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

#NOTE: To Do: Fix yesterday, today, all at bottom (after attdeled.pl fixed).


my %lex = ('Delete' => 'Delete',
	   'Student' => 'Student',
	   'Date' => 'Date',
	   'Reason' => 'Reason',
	   'Period' => 'Period',
	   'Attendance' => 'Attendance',
	   'Delete Record' => 'Delete Record',
	   'Record Deleted' => 'Record Deleted',
	   'Contact' => 'Contact',
	   'Error' => 'Error',
	   'Main' => 'Main',
	   'Are you sure' => 'Are you sure',
	   'Today' => 'Today',
	   'Yesterday' => 'Yesterday',
	   'Another' => 'Another',
	   'Edit' => 'Edit',
	   'Delete' => 'Delete',
	   'Another' => 'Another',

	   );

my $self = 'attdel.pl';

use CGI;
use DBI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset => $charset ); 
my %arr = $q->Vars;


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);



my $title = "$lex{Delete} $lex{Attendance}";
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">
$chartype\n</head><body style="margin:1em;">\n};

print qq{[ <a href="$homepage">$lex{Main}</a> | \n};
print qq{<a href="$attpage">$lex{Attendance}</a> ]\n};
print qq{<h1>$title</h1>\n};


if ( $arr{page} ) {
    delete $arr{page};
    deleteRecord();
}


# Get Record
my $sth = $dbh->prepare("select * from attend where attid = ?"); 
$sth->execute( $arr{id} );
if ( $DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
my $ref = $sth->fetchrow_hashref;
my %r = %$ref;

# Get Name
$sth = $dbh->prepare("select lastname, firstname from studentall where studnum = ?");
$sth->execute( $r{studentid} );
if ( $DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
my ($lastname, $firstname) = $sth->fetchrow;

# Get Homeroom or Course
my $hrmcrs;
if ( $r{subjsec} =~ m/HR/ ) { # homeroom
    $hrmcrs = $r{subjsec};
    $hrmcrs =~ s/HR://;
} else { # course
    my $sth1 = $dbh->prepare("select description from subject where subjsec = ?");
    $sth1->execute( $r{subjsec} );
    if ( $DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my $desc = $sth1->fetchrow;
    $hrmcrs = qq{$desc ($r{subjsec}) };
}

print qq{<form action="$self" method="post">\n};
print qq{<input type="hidden" name="attid" value="$arr{id}">\n};
print qq{<input type="hidden" name="page" value="1">\n};
print qq{<input type="hidden" name="studname" value="$firstname $lastname">\n};

print qq{<table cellpadding="3" cellspacing="0" border="0">\n};
print qq{<tr><td class="bra">$lex{Student}</td><td>$firstname $lastname ($r{studentid})</td></tr>\n};
print qq{<tr><td class="bra">Homeroom/Course</td><td>$hrmcrs</td></tr>\n};

print qq{<tr><td class="bra">$lex{Date}</td><td>$r{absdate}</td></tr>\n};
print qq{<tr><td class="bra">$lex{Period}</td><td>$r{period}</td></tr>\n};
print qq{<tr><td class="bra">$lex{Reason}</td><td>$r{reason}</td></tr>\n};

print qq{<tr><td></td><td class="la">$lex{'Delete Record'}: <b>$lex{'Are you sure'}?</b></td></tr>\n};
print qq{<tr><td></td><td class="la"><input type="submit" value="$lex{'Delete Record'}"></td></tr>\n};
print qq{</table>\n};
print qq{</form></body></html>\n};



#---------------
sub deleteRecord {
#---------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key VAL:$arr{$key}<br>\n}; }
        
    my $sth = $dbh->prepare("delete from attend where attid = ?");
    $sth->execute( $arr{attid} );

    if ($DBI::errstr) {
	print qq{<h3>$lex{Error}: $DBI::errstr</h3>\n};
    } else {
	print qq{<b>$lex{'Record Deleted'} for $arr{studname}</b>\n};
    }

    print qq{<p>[ <a href="$attpage">$lex{Attendance}</a> ]</p>};
    print qq{<div><form action="attdeled.pl" method="post">};
    print qq{<select name="date"><option value="today">$lex{Today}</option>\n};
    print qq{<option value="yesterday">$lex{Yesterday}</option>\n};
    print qq{<option>All</option></select>\n};
    print qq{<input type="submit" value="$lex{Edit}/$lex{Delete} $lex{Another}"};
    print qq{></div></body></html>\n};

    exit;

}
