#!/usr/bin/perl
#  Copyright 2001-2018 Leslie Richardson

#  This file is part of Open Admin for Schools.

# Move the attendance records of certain students from one course to another.


my %lex = ('Error' => 'Error',
	   'Main' => 'Main',
	   'Attendance' => 'Attendance',
	   'More' => 'More',
	   'Move' => 'Move',
	   'Course' => 'Course',

	   );

my $self = 'attmovecourse.pl';


use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Set Date
my @tim = localtime(time);
my $year = @tim[5] + 1900;
my $month = @tim[4] + 1;
my $day = @tim[3];
my $currdate = "$year-$month-$day";
my $currdate1 = "$month[$month] $day, $year";

my $title = "$lex{Move} $lex{Course} $lex{Attendance}";
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};

print qq{<link rel="stylesheet" type="text/css" media="all" };
print qq{href="/js/calendar-blue.css" title="blue">\n};
print qq{<script type="text/javascript" src="/js/calendar.js"></script>\n};
print qq{<script type="text/javascript" src="/js/lang/calendar-en.js"></script>\n};
print qq{<script type="text/javascript" src="/js/calendar-setup.js"></script>\n};

print qq{$chartype\n</head><body style="margin:1em 3em;">\n};

print qq{[ <a href="$homepage">$lex{Main}</a> |\n};
print qq{ <a href="$attpage">$lex{Attendance}</a> ] $currdate1\n};
print qq{<h1>$title</h1>\n};


if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    confirmMove();

} elsif ( $arr{page} == 2 ) {
    delete $arr{page};
    moveAttendance();
}

#----------------
sub showStartPage {
#----------------
    

    # Start Form.
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};

    print qq{<p style="width:30em;border:1px solid gray:">This script
    is used to move student attendance records from one course to
    another course. It does not do homeroom changes, only course
    moves. It should be combined with updates to the teacher
    attendance entries as well, if there are issues with NE values in
    attendance report 4.</p>\n};

    print qq{<p style="font-weight:bold;font-size:120%;width:30em;">Note: This
    script does NOT move the student course enrollment; it only
    changes their attendance records for a course.</p>\n};

    # Start Table
    print qq{<table cellpadding="3" border="0" cellspacing="0">\n\n};

    # Previous Course
    print qq{<tr><td>Previous Course Code</td>};
    print qq{<td><input type="text" name="prevcourse" style="width:4em;"></td></tr>\n};
    
    # New Course
    print qq{<tr><td>New Course Code</td>};
    print qq{<td><input type="text" name="newcourse" style="width:4em;"></td></tr>\n};

    # Student Numbers
    print qq{<tr><td>Student Numbers</td>};
    print qq{<td><input type="text" name="students" style="width:12em;"></td></tr>\n};

    # Do Submit Button
    print qq{<tr><td><input type="submit" value="Continue"></td><td></td></tr>\n};

    print qq{</table></form>\n\n};
    print qq{</body></html>\n};

    exit;

}



#--------------
sub confirmMove {
#--------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n"; }

    my $userid = $arr{userid};
    delete $arr{userid};

    # load prevcourse, newcourse, and the students.
    my $sth = $dbh->prepare("select description, grade from subject where subjsec = ?");

    # previous course
    $sth->execute( $arr{prevcourse} );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    my ($prevdesc, $prevgrade) = $sth->fetchrow;
    if ( not $prevdesc ) {
	print qq{<h3>Course not found for: $arr{prevcourse}</h3>\n};
	print qq{</body></html>\n};
	exit;
    }

    # new course
    $sth->execute( $arr{newcourse} );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    my ($newdesc, $newgrade) = $sth->fetchrow;
    if ( not $newdesc ) {
	print qq{<h3>Course not found for: $arr{newcourse}</h3>\n};
	print qq{</body></html>\n};
	exit;
    }


    # Select students
    my @students = split(/\s+/, $arr{students});
			 
    my $sth = $dbh->prepare("select lastname, firstname, grade, homeroom from student where studnum = ?");
    my $sth1 = $dbh->prepare("select count(*) from eval where studnum = ? and subjcode = ?");

    my %studname;
    foreach my $studnum ( @students ) {
	
	$sth->execute( $studnum );
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	my ($lastname, $firstname, $grade, $homeroom) = $sth->fetchrow;

	if ( not $lastname ) {
	    print qq{<h3>Student not found for student number $studnum. Skipping</h3>\n};
	    next;
	}

	$sth1->execute( $studnum, $arr{newcourse} );
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	my $count = $sth1->fetchrow;

	if ( not $count ) {
	    print qq{<h3>Student $firstname $lastname not enrolled in new course $newdesc. Skipping</h3>\n};
	    next;
	}

	$studname{$studnum} = qq{<b>$lastname</b>, $firstname};
    }
    

    # Start of Form
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="2">\n};

    print qq{<input type="hidden" name="prevcourse" value="$arr{prevcourse}">\n};
    print qq{<input type="hidden" name="newcourse" value="$arr{newcourse}">\n};

    # Now pass correct student numbers (that have a name)
    foreach my $key ( keys %studname ) {
	print qq{<input type="hidden" name="$key" value="1">\n};
    }

    # Display for confirmation.
    print qq{<table cellpadding="3" cellspacing="0" border="1">\n};
    print qq{<tr><th class="bra">Previous Course</th>};
    print qq{<td>$prevdesc ($arr{prevcourse})</td><td>Grade $prevgrade</td></tr>\n};
    
    print qq{<tr><th class="bra">New Course</th>\n};
    print qq{<td>$newdesc ($arr{newcourse})</td><td>Grade $newgrade</td></tr>\n};

    foreach my $studnum ( keys %studname ) {
	print qq{<tr><th class="bra">Student</td><td colspan="2" class="la">$studname{$studnum}</td></tr>\n};
    }

    print qq{</table>\n};
    print qq{<p><input type="submit" value="Move Student Attendance"></p>\n};

    print qq{</form>\n};
    
    print qq{</body></html>\n};

    exit;

}


#-----------------
sub moveAttendance {
#-----------------

    #foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n};}

    my $newcourse = $arr{newcourse};
    my $prevcourse = $arr{prevcourse};
    delete $arr{newcourse};
    delete $arr{prevcourse};
    # values remaining in %arr will be student numbers

    my $sth1 = $dbh->prepare("select lastname, firstname from student where studnum = ?");

    my $sth = $dbh->prepare("update attend set subjsec = ? where studentid = ? and subjsec = ?");


    foreach my $studnum ( keys %arr ) {

	# Get name
	$sth1->execute( $studnum );
	if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
	my ($ln,$fn) = $sth1->fetchrow;

	$sth->execute( $newcourse, $studnum, $prevcourse );
	if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }

	print qq{<div style="font-size:120%;">$fn $ln Attendance records moved</div>\n};

    }


    print qq{<p>[ <a href="$homepage">$lex{Main}</a> |\n};
    print qq{ <a href="$attpage">$lex{Attendance}</a> |\n};
    print qq{ <a href="$self">$lex{More}</a> ]</p>\n};

    print qq{</body></html>\n};

    exit;

}
