#!/usr/bin/perl
#  Copyright 2001-2022 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Reset Attendance Reasons' => 'Reset Attendance Reasons',
	   'Main' => 'Main',
	   'Reset Date' => 'Reset Date',
	   'Name' => 'Name',
	   'Reason' => 'Reason',
	   'Period' => 'Period',
	   'Date' => 'Date',
	   'Continue' => 'Continue',
	   'Record(s) Updated' => 'Record(s) updated',
	   'Attendance' => 'Attendance',
	   'WD = Withdrawn' => 'WD = Withdrawn',
	   'Error' => 'Error',
	   'Not Found' => 'Not Found',
	   

	   );

my $self = 'attrsnreset.pl';

use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

# Get Date
my @tim = localtime(time);
my $year = @tim[5] + 1900;
my $month = @tim[4] + 1;
my $day = @tim[3];
my $currdate = "$year-$month-$day";
my $currdate1 = "@month[$month] $day, $year";

my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


my $date;
if ( not $arr{date} ) {
    $date = $currdate;
} else {
    $date = $arr{date};
}



# Main Page Header.
my $title = $lex{'Reset Attendance Reasons'};
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};

if ( not $arr{page} ) {
    print qq{<link rel="stylesheet" type="text/css" media="all" };
    print qq{href="/js/calendar-blue.css" title="blue">\n};
    print qq{<script type="text/javascript" src="/js/calendar.js"></script>\n};
    print qq{<script type="text/javascript" src="/js/lang/calendar-en.js"></script>\n};
    print qq{<script type="text/javascript" src="/js/calendar-setup.js"></script>\n};
}

print qq{$chartype\n</head><body>\n};
print qq{[ <a href="$homepage">$lex{Main}</a> |\n};
print qq{ <a href="$attpage">$lex{Attendance}</a> ]\n};

# Start of Page
print qq{<h1>$title</h1>\n};

if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    showReasons();

} elsif ( $arr{page} == 2 ) {
    delete $arr{page};
    updateReason();
}



#----------------
sub showStartPage {
#----------------


    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};
    
    print qq{<table cellpadding="0" cellspacing="3" border="0">};

    print qq{<tr><td class="bra">$lex{Attendance} $lex{Date}</td>\n};
    print qq{<td class="la"><input type="text" id="date" name="date" size="12">\n};
    print qq{<button type="reset" id="start_trigger">...</button></td></tr>\n};
    print qq{<tr><td></td><td class="la"><input type="submit" value="$lex{Continue}"></td></tr>\n};
    print qq{</table>\n};
    
    print qq{</form>\n};
    
    print qq{<script type="text/javascript">
 Calendar.setup({
  inputField  : "date",
  ifFormat    : "%Y-%m-%d",
  button      : "start_trigger",
  singleClick : false,
  step : 1
  });
</script>\n};

    print qq{</body></html>\n};

    exit;
}



#--------------
sub showReasons {
#--------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    
    print qq{<h3>$lex{'Reset Date'} $date</h3>\n};
    
    # Start of form setup.
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="2">\n};
    print qq{<input type="submit" value="$lex{Continue}">\n};
    
    print qq{<table cellpadding="3" cellspacing="0" border="1">\n};

    print qq{<tr><th>$lex{Name}</th><th>$lex{Reason}</th>\n};
    print qq{<th>$lex{Period}</th><th>$lex{Date}</th></tr>\n};


    my $sth = $dbh->prepare("select a.* from attend as a, studentall as s
      where s.studnum = a.studentid and a.absdate = ? order by s.lastname, s.firstname, a.period");

    $sth->execute( $arr{date} );
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
    print qq{<caption><font color="red">$lex{'WD = Withdrawn'}</font></caption>\n};

    # get name from student table or wd table
    my $sth1 = $dbh->prepare("select lastname,firstname from student where studnum = ?");
    my $sth2 = $dbh->prepare("select lastname,firstname from studentwd where studnum = ?");

    my ($currstud, $prevstud);
    
    while ( my ($attid, $studnum, $absdate, $reason, $period, $subjsec,$late) = $sth->fetchrow ) {

	my $wd;

	# Get the Name from Student
	$sth1->execute($studnum);
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
	my ($lastname, $firstname) = $sth1->fetchrow;
	
	if ( not $lastname ) { # check in withdrawn student table.
	    $sth2->execute( $studnum );
	    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
	    ($lastname, $firstname) = $sth2->fetchrow;
	    if (not $lastname) { $lastname = $lex{'Not Found'}; }
	    $wd = qq{<span style="color:red">WD</span>};
	}

	my $name = "$wd <b>$lastname</b>, $firstname";
    

	$prevstud = $currstud; 
	$currstud = $studnum;
	if ($currstud != $prevstud){ # reset color
	    if ( $color eq 'blue' ){ $color = 'gray'; } else { $color = 'blue';} 
	}
	print qq{<tr class="$color"><td>$name ($studnum)</td>\n};
	print qq{<td><select name="$attid"><option>$reason</option>\n};

	foreach my $reason ( @attend ) {
	    print qq{<option>$reason</option>\n};
	}
	print qq{</select></td><td>$period</td><td>$date</td></tr>\n\n};

    }

    print qq{</table>\n};
    print qq{<input type="submit" value="$lex{Continue}">\n};
    print qq{</form></body></html>\n};

    exit;

} # end of showReasons



#---------------
sub updateReason {
#---------------

#    foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }


    # Update Record
    my $sth = $dbh->prepare("update attend set reason = ? where attid = ?");

    # Load Record
    my $sth1 = $dbh->prepare("select * from  attend where attid = ?");

    
    foreach my $attid ( keys %arr ) { 

	# Load the record
	$sth1->execute( $attid );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	my $ref = $sth1->fetchrow_hashref;
	my %r = %$ref;

	if ( $r{reason} eq $arr{$attid} ) { #skip if no change
	    next;
	}

#	print "Changed: $arr{$attid}  Original:$r{reason}<br>\n";
	$sth->execute( $arr{$attid}, $attid );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
    }

    
    if (not $DBI::errstr ) {
	print qq{<h3>$lex{'Record(s) Updated'}</h3>\n};
	
    } else {
	print qq{<h3>$lex{'Error'}: $DBI::errstr</h3>\n};
    }

    print qq{<p>[ <a href="$attpage">$lex{Attendance}</a> ]</p>\n};
    print qq{</body></html>\n};

    exit;

}
