#!/usr/bin/perl
#  Copyright 2001-2022 Leslie Richardson

#  This file is part of Open Admin for Schools.

my %lex = ('Check Days Missing' => 'Check Days Missing',
	   'Main' => 'Main',
	   'Attendance' => 'Attendance',
	   'Name' => 'Name',
	   'Days' => 'Days',
	   'HRm' => 'HRm',
	   'Grade' => 'Grade',
	   'Start Date' => 'Start Date',
	   'End Date' => 'End Date',
	   'Periods Per Day' => 'Periods per Day',
	   'Error' => 'Error',
	   'Not Found' => 'Not Found',
	   'Continue' => 'Continue',
	   'Maximum Days Missing' => 'Maximum Days Missing',
	   'Reason' => 'Reason',
	   
	   );

use DBI;
use CGI;
use Number::Format qw(:all);

my $self = 'attscanlite.pl';


# This script looks for student attendance records with a reason field 
# containing "Absent Unexcused". If you change the reason types, this 
# script won't work. Change the value of the variable below.

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $absreason = $absentUnexcused; # comes from admin.conf




my ( $sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $iddst) = localtime(time);
$year = $year + 1900;
$mon++;
if ( length( $mon ) == 1 ) { $mon = '0'. $mon; }
if ( length( $mday ) == 1 ) { $mday = '0'. $mday; }

my $currdate = "$year-$mon-$mday";

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;



my $title = $lex{'Check Days Missing'};
    

print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};

if ( not $arr{page} ) { # load javascript library
    print qq{<link rel="stylesheet" type="text/css" media="all" };
    print qq{href="/js/calendar-blue.css" title="blue">\n};
    print qq{<script type="text/javascript" src="/js/calendar.js"></script>\n};
    print qq{<script type="text/javascript" src="/js/lang/calendar-en.js"></script>\n};
    print qq{<script type="text/javascript" src="/js/calendar-setup.js"></script>\n};

}
    
print qq{$chartype\n</head>\n};
print qq{<body>[ <a href="$homepage">$lex{Main}</a> |\n};
print qq{<a href="$attpage">$lex{Attendance}</a> ]\n};

print qq{<h1>$title</h1>\n};



if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    showReport();

}


#-------------
sub showReport {
#-------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    my ($sy,$sm,$sd) = split '-', $arr{startdate};
    my $startdate = $month[$sm]. " $sd, $sy";
    my ($ey,$em,$ed) = split '-', $arr{enddate};
    my $enddate = $month[$em]. " $ed, $ey";

    my $dsn = "DBI:$dbtype:dbname=$dbase";
    my $dbh = DBI->connect($dsn,$user,$password);


    my $select;
    if ( $arr{startdate} ) {
	$select = "and to_days(attend.absdate) >= to_days('$arr{startdate}')".
	" and to_days(attend.absdate) <= to_days('$arr{enddate}')";
    }

    my $sth = $dbh->prepare("select student.studnum, count(*) as missed, 
			    student.firstname, student.lastname, student.homeroom, 
			    student.grade from attend, student 
			    where attend.studentid = student.studnum and 
			    attend.reason = '$absreason' $select group by attend.studentid
			    order by missed desc, student.lastname, student.firstname");

    $sth->execute;
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }


    print qq{<table border="0" cellpadding="3" cellspacing="0" style="margin:1em 0em;">\n};
    print qq{<tr><td class="bra">$lex{'Start Date'}</td><td class="la">$startdate</td></tr>\n};
    print qq{<tr><td class="bra">$lex{'End Date'}</td><td class="la">$enddate</td></tr>\n};
    print qq{<tr><td class="bra">$lex{Days}</td><td class="la">$arr{maxdays}</td></tr>\n};
    print qq{</table>\n};
    
    print qq{<table border="0" cellpadding="3" cellspacing="0">\n};
    print qq{<tr><th>$lex{Name}</th><th>$lex{Days}</th><th>$lex{HRm}</th>\n};
    print qq{<th>$lex{Grade}</th></tr>\n};

    
    while ( my ( $studnum, $count, $firstname, $lastname, $homeroom, $grade ) = $sth->fetchrow ) {

	my $ppd = $g_ppd{ $grade };
	if ( not $ppd ) {
	    my $sth1 = $dbh->prepare("select studid from student where studnum = ?");
	    $sth1->execute( $studnum );
	    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	    my $id = $sth1->fetchrow;
	
	    print qq{<p><b>$lex{'Periods Per Day'} / $lex{Grade} $lex{'Not Found'}: };
	    print qq{ <a href="studed.pl?recnum=$id">$firstname $lastname</a> };
	    print qq{ $lex{Grade} $grade</b></p>\n};
	    print qq{</body></html>\n};
	    exit;
	}
	
	my $absent = format_number( $count / $ppd, 2,2);
	if ( $absent >= $arr{maxdays} ) {
	    print qq{<tr><td><b>$lastname</b>, $firstname</td><td class="cn">$absent</td>};
	    print qq{<td class="cn">$homeroom</td><td class="cn">$grade</td></tr>\n};
	}
    }

    print qq{</table></body></html>\n};

    exit;

}




#-----------------
sub showStartPage {
#-----------------

    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};

    print qq{<table cellpadding="3" cellspacing="0" border="0">\n};

    print qq{<tr><td class="bra">$lex{'Start Date'}</td>\n<td><input type="text" };
    print qq{name="startdate" id="sdate" size="10">};
    print qq{<button type="reset" id="start_trigger">...</button>};
    print qq{</td></tr>\n};

    print qq{<tr><td class="bra">$lex{'End Date'}</td>\n<td><input type="text" };
    print qq{name="enddate" id="edate" size="10" value="$currdate">};
    print qq{<button type="reset" id="end_trigger">...</button></td></tr>\n};

    print qq{<tr><td class="bra">$lex{'Maximum Days Missing'}</td>\n};
    print qq{<td class="la"><input type="text" name="maxdays" size="4"></td></tr>\n};

    print qq{<tr><td class="bra">$lex{Attendance} $lex{Reason}</td>\n};
    print qq{<td class="la">$absreason</td></tr>\n};



    
    print qq{<tr><td></td><td class="la">};
    print qq{<input type="submit" value="$lex{Continue}"></td></tr>\n};

    print qq{</table>\n};
    print qq{</form>\n};

    
    print qq{<script type="text/javascript">
     Calendar.setup({
        inputField     :  "sdate", // id of the input field
        ifFormat       :  "%Y-%m-%d", // format of the input field
        button         :  "start_trigger", // trigger for the calendar (button ID)
        singleClick    :  false,        // double-click mode
        step           :  1             // show all years in drop-down boxes 
    });

    Calendar.setup({
        inputField     :  "edate", // id of the input field
        ifFormat       :  "%Y-%m-%d", // format of the input field
        button         :  "end_trigger", // trigger for the calendar (button ID)
        singleClick    :  false,        // double-click mode
        step           :  1             // show all years in drop-down boxes
    });
   </script>\n};

    print qq{</body></html>\n};

    exit;

}

