#!/usr/bin/perl

#  Copyright 2001-2009 Leslie Richardson

#  This file is part of Open Admin for Schools.

# View Student Attendance by Subject and Student
# Passed subjsec (ie. 8048-1) and local student number (studnum)

use DBI;
use CGI;

%lex = ( 'Attendance Scan' => 'Attendance Scan',
	 'Attendance' => 'Attendance',
	 'Missing Subject or Student Number' => 'Missing Subject or Student Number',
	 'Total Points' => 'Total Points',
	 'Error' => 'Error',
	 'Student' => 'Student',
	 'Subject' => 'Subject',
	 'Date' => 'Date',
	 'Reason' => 'Reason',
	 'Period' => 'Period',
	 'Points' => 'Points',

	 );


eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}


my $q = CGI->new;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

my $studnum = $arr{studnum};
my $subjsec = $arr{subjsec};

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Map reason to points in points hash. (ie. $points{reason} = points )
for ( 0..$#attend ) {
    $points{$attend[$_]} = $points[$_];
}


# print header.
print "$doctype\n<html><head><title>$lex{'Attendance Scan'}</title>
 <link rel=\"stylesheet\" href=\"$css\" type=\"text/css\">
 $chartype\n</head><body>[ <a href=\"$attpage\">$lex{'Attendance'}</a> ]
<center><h1>$lex{'Attendance Scan'}</h1>\n";
 
if (not $subjsec or not $studnum){
    print $lex{'Missing Subject or Student Number'},"\n";
    print "</body></html>\n";
    die;
}

# Select Attendance Records
$sth= $dbh->prepare("select absdate, reason, period from attend
  where subjsec = ? and studentid = ? order by reason, absdate, period");
$sth->execute( $subjsec, $studnum );
if ($DBI::errstr) {print $DBI::errstr; die $DBI::errstr;}

# Get Subject Desc
my $sth1 = $dbh->prepare("select description from subject 
  where subjsec = ?"); 
$sth1->execute( $subjsec );
if ( $DBI::errstr) { print $DBI::errstr; die $DBI::errstr;}
my $desc = $sth1->fetchrow;

# Get Student Name
$sth1 = $dbh->prepare("select lastname, firstname from studentall
  where studnum = ?"); 
$sth1->execute( $studnum );
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr;}
my ( $lastname, $firstname ) = $sth1->fetchrow;


print "<table cellpadding=\"3\" border=\"1\" cellspacing=\"0\">\n";

print "<caption><b>". $lex{Student}. "</b> $firstname $lastname<br>";
print "<b>". $lex{Subject}. "</b> $desc ($subjsec)</caption>\n";

print "<tr><th>". $lex{Date}. "</th><th>". $lex{Reason}. "</th><th>";
print $lex{Period}. "</th><th>". $lex{Points}. "</th></tr>\n";

# loop through all attendance records
my $totalpoints;
while ( my ( $absdate, $reason, $period ) = $sth->fetchrow ) {
    $oldreason = $currreason;
    $currreason = $reason;
    if ( $currreason ne $oldreason ) {
	if ($color eq '#88F'){ $color = '#DDD';} else { $color = '#88F'};
    }

    print "<tr style=\"background-color:$color;\"><td>$absdate</td>";
    print "<td>$reason</td><td>$period</td><td>$points{$reason}</td></tr>\n";
    $totalpoints += $points{$reason};
}

print "<tr><td colspan=\"4\"><b>",$lex{'Total Points'}," $totalpoints</td></tr>\n";
print "</table></center></body></html>\n";

