#! /usr/bin/perl
#  Copyright 2001-2022 Leslie Richardson

#  This file is part of Open Admin for Schools.

# Student Daily Attendance Report
# Get students absent on current date (or entered date)

my %lex = ('Student' => 'Student',
	   'Daily Attendance Report' => 'Daily Attendance Report',
	   'Attendance' => 'Attendance',
	   'Date format Error' => 'Date format Error',
	   'Today' => 'Today',
	   'Weeks' => 'Weeks',
	   'Discipline' => 'Discipline',
	   'Error' => 'Error',
	   'Selected' => 'Selected',
	   'Continue' => 'Continue',
	   'Date' => 'Date',
	   'Week' => 'Week',
	   'Main' => 'Main',
	   
	   );


use DBI;
use CGI;
use Time::JulianDay;

my $self = 'rptattstuday.pl';

# Read config variables
eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my @tim = localtime(time);
my $year = @tim[5] + 1900;
my $month = @tim[4] + 1;
my $day = @tim[3];
if (length($day) == 1){ $day = '0'.$day;}
if (length($month) == 1){ $month = '0'.$month;}
my $currdate = "$year-$month-$day";
my $currdate1 = "@month[$month] $day, $year";

my $q = new CGI;
my %arr = $q->Vars;
print $q->header( -charset, $charset );

my $title = qq{$lex{Student} $lex{'Daily Attendance Report'}};
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};

if ( not $arr{page} ) {
    print qq{<link rel="stylesheet" type="text/css" media="all" };
    print qq{href="/js/calendar-blue.css" title="blue">\n};
    print qq{<script type="text/javascript" src="/js/calendar.js"></script>\n};
    print qq{<script type="text/javascript" src="/js/lang/calendar-en.js"></script>\n};
    print qq{<script type="text/javascript" src="/js/calendar-setup.js"></script>\n};
}

print qq{$chartype\n</head><body>\n};
print qq{[ <a href="$homepage">$lex{Main}</a> |\n};
print qq{ <a href="$attpage">$lex{Attendance}</a> ]\n};
print qq{<h1>$title</h1>\n};

my $date = $arr{date};
if ( not $date ){ $date = $currdate;}
if ( length($date) < 6){ 
    print qq{<h1>$lex{'Date format Error'}: (yy-mm-dd)</h1></body></html>\n};
    exit;
}


if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    showReport();
}


#----------------
sub showStartPage {
#----------------

    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};
    
    print qq{<table cellpadding="0" cellspacing="3" border="0" style="margin:1em;">};

    print qq{<tr><td class="bra">$lex{Attendance} $lex{Date}</td>\n};
    print qq{<td class="la"><input type="text" id="date" name="date" size="8">\n};
    print qq{<button type="reset" id="start_trigger">...</button></td></tr>\n};
    print qq{<tr><td></td><td class="la"><input type="submit" value="$lex{Continue}"></td></tr>\n};
    print qq{</table>\n};
    
    print qq{</form>\n};
    
    print qq{<script type="text/javascript">
 Calendar.setup({
  inputField  : "date",
  ifFormat    : "%Y-%m-%d",
  button      : "start_trigger",
  singleClick : false,
  step : 1
  });
</script>\n};

    print qq{</body></html>\n};

    exit;
    
} # end of showStartPage





#-------------
sub showReport {
#-------------

    my $datejd = julian_day( split('-', $date));
			     
    # Get Previous Weeks 
    my $prevjd1wk = $datejd - 7;
    my $prev1wk = join('-', inverse_julian_day($prevjd1wk));
    my $prevjd2wk = $datejd - 14;
    my $prev2wk = join('-', inverse_julian_day($prevjd2wk));

    my $dsn = "DBI:$dbtype:dbname=$dbase";
    my $dbh = DBI->connect($dsn,$user,$password);


    # Find the kids that are away today;
    $sth=$dbh->prepare("select distinct attend.studentid from attend
		       left outer join student on attend.studentid = student.studnum 
		       where absdate = ? order by student.lastname,student.firstname");

    $sth->execute( $date );
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
    $studary = $sth->fetchall_arrayref;

    print qq{<table cellpadding="3" cellspacing="0" border="1">\n};
    print qq{<caption style="font-weight:bold;font-size:120%;">};
    print qq{$lex{Date} $lex{Selected}: $date</caption>\n};
    print qq{<tr><th>$lex{Student}</th><th>$lex{Today}<br>($date)</th>\n};
    print qq{<th>Previous $lex{'Week'} Periods</th>\n};
    print qq{<th>Previous 2 $lex{'Weeks'} Periods</th>\n};
    print qq{<th>$lex{Discipline}</th></tr>\n};


    my $sth1 = $dbh->prepare("select lastname,firstname from studentall where studnum = ?");    

    my $sth2 = $dbh->prepare("select distinct reason, count(reason) from attend 
      where absdate = ? and studentid = ? group by reason");

    my $sth3 = $dbh->prepare("select distinct reason, count(reason) from attend 
      where to_days(absdate) <= to_days('$date') and 
      to_days(absdate) >= to_days('$prev1wk') and
      studentid = ? group by reason");

    my $sth4 = $dbh->prepare("select distinct reason, count(reason) from attend 
      where to_days(absdate) <= to_days('$date') and 
      to_days(absdate) >= to_days('$prev2wk') and
      studentid = ? group by reason");
    
    my $sth5 = $dbh->prepare("select e.date,e.infraction from disc_event e, disc_ident i
			     where i.studnum = ? and i.eventid = e.id and 
			     infraction $sql{like} '%unexcused%' order by date desc");

    my $sth6 = $dbh->prepare("select count(*) from studentwd where studnum = ?");    
    
    foreach my $rowary ( @$studary ) {

	my $studnum = $$rowary[0];

	# Get Student Name
	$sth1->execute( $studnum );
	if ($DBI::errstr){ print $DBI::errstr; die;}
	my ($lastname,$firstname) = $sth1->fetchrow;

	# Check for withdrawn
	my $wd;
	$sth6->execute( $studnum );
	if ($DBI::errstr){ print $DBI::errstr; die;}
	my $wdcheck = $sth6->fetchrow;
	if ( $wdcheck ) { $wd = qq{<span style="color:red;font-weight:bold;">WD</span>}; }


	# Get Today's Data
	$sth2->execute( $date, $studnum );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	$reasonary = $sth2->fetchall_arrayref;
	my $currentabs = "";
	foreach my $reasonrow ( @$reasonary ) {
	    $currentabs .= "<tr><td>$$reasonrow[0]</td><td>$$reasonrow[1]</td></tr>";
	}

	# Get 1 week prev Data
	$sth3->execute( $studnum );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	$fivereasonary = $sth3->fetchall_arrayref;
	my $oneWeekAbs;
	foreach $reasonrow ( @$fivereasonary ){
	    $oneWeekAbs .= "<tr><td>$$reasonrow[0]</td><td>$$reasonrow[1]</td></tr>";
	}


	# Get 2 weeks prev Data
	$sth4->execute( $studnum );
	if ($DBI::errstr){ print $DBI::errstr; die;}
	$tenreasonary = $sth4->fetchall_arrayref;
	my $twoWeekAbs;
	foreach my $reasonrow ( @$tenreasonary ) {
	    $twoWeekAbs .= "<tr><td>$$reasonrow[0]</td><td>$$reasonrow[1]</td></tr>";
	}

	
	# Get Discipline Data
	$sth5->execute( $studnum );
	if ($DBI::errstr){ print $DBI::errstr; die;}
	$discary = $sth5->fetchall_arrayref;
	my $discTable;
	foreach $infract (@$discary){
	    $discTable .= "<tr><td>$$infract[0]</td><td>$$infract[1]</td></tr>";
	}

	# print stuff
	print qq{<tr><td>$wd <b>$lastname</b>, $firstname ($studnum)</td><td><table>\n};
	print qq{$currentabs</table></td><td><table>$oneWeekAbs</table></td>\n};
	print qq{<td><table>$twoWeekAbs</table></td><td><table>$discTable</table></td></tr>\n};
    }

    print qq{</table></body></html>\n};

    exit;

} # end of showReport
