#!/usr/bin/perl
#  Copyright 2001-2017 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.


my %lex = ('View Student Lates' => 'View Student Unexcused Lates',
	   'Main' => 'Main',
	   'Attendance' => 'Attendance',
	   'Name' => 'Name',
	   'Homeroom' => 'Hm&nbsp;Rm',
	   'Grade' => 'Grade',
	   'Count' => 'Count',
	   'Sum' => 'Sum',
	   'Error' => 'Error',
	   'Select by Date' => 'Select by Date',
	   'Start Date' => 'Start Date',
	   'End Date' => 'End Date',

	   );


use DBI;
use CGI;

# Read config variables
eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

my $startdate = $schoolstart;
my $enddate = $schoolend;

if ( $arr{startdate} ) { 
    if (length($arr{startdate}) == 6) { # fix it up..
	my $yr = '20'. substr($arr{startdate},0,2);
	my $mo = substr($arr{startdate},2,2);
	my $da = substr($arr{startdate},4,2);
	$arr{startdate} = "$yr-$mo-$da";
    }
    $startdate = $arr{startdate}; }
if ($arr{enddate}) { $enddate = $arr{enddate}; }

my $dateselect = "and to_days(absdate) >= to_days('$startdate') ".
 "and to_days(absdate) <= to_days('$enddate')"; 

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Get Current date
my @tim = localtime(time);
my $year = $tim[5] + 1900;
my $month = $tim[4] + 1;
my $day = $tim[3];

if (length($month) == 1){ $month = "0".$month;}
if (length($day) == 1){ $day = "0".$day;}
my $currdate = "$year-$month-$day";


$sth = $dbh->prepare("select distinct studentid, count(attid), sum(late) 
  as sumlate from attend 
  where reason = '$lateUnexcused' $dateselect 
  group by studentid order by sumlate desc");
# $lateUnexcused is defined in the admin.conf configuration file.

$sth->execute;
if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }

my $title = $lex{'View Student Lates'};

print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};
print qq{$chartype\n</head>\n};
print qq{<body>[ <a href="$homepage">$lex{Main}</a> | };
print qq{<a href="$attpage">$lex{Attendance}</a> ]\n};

print qq{<h1>$title</h1>\n};


# Print Date Selector Form Entry
#print qq{<div style="position:absolute;top:0.5em; right:0.5em; 
# background-color:#CCC; padding:0.3em;">\n};

print qq{<form action="$self" method="post" style="display:block;margin:2em 0em;">\n};
print qq{<input type="submit" value="$lex{'Select by Date'}">\n};
print qq{$lex{'Start Date'} <input type="text" name="startdate" size="8">\n};
print qq{$lex{'End Date'} <input type="text" name="enddate" size="8" value="$currdate">\n};
print qq{</form>\n};


print qq{<table cellpadding="3" border="1" cellspacing="0">\n};
print qq{<caption style="font-weight:bold;font-size:120%;">$lex{'Start Date'} $startdate  };
print qq{$lex{'End Date'} $enddate</caption>\n};

print qq{<tr><th>$lex{Name}</th><th>$lex{Grade}</th>};
print qq{<th>$lex{Homeroom}</th><th>$lex{Count}</th><th>$lex{Sum}</th></tr>\n};


my $sth1 = $dbh->prepare("select lastname, firstname, grade, homeroom 
 from student where studnum = ?");

my $sth2 = $dbh->prepare("select lastname, firstname, grade, homeroom 
 from studentwd where studnum = ?");


while (my ($studnum, $latecount, $latesum) = $sth->fetchrow) {

    # Get student information.
    $sth1->execute($studnum);
    my ($lastname, $firstname, $grade, $homeroom) = $sth1->fetchrow;

    # Look in Withdrawn Students
    if (not $lastname) {
	$sth2->execute($studnum);
	my ($lastname, $firstname, $grade, $homeroom) = $sth2->fetchrow;
	print qq{<tr><td style="color:red;">};
	print qq{<b>$lastname</b>, $firstname ($studnum)</td>\n};
	
    } else {
	print qq{<tr><td><b>$lastname</b>, $firstname ($studnum)</td>\n};
    }

    print qq{<td>$grade</td><td>$homeroom</td><td>$latecount</td>};
    print qq{<td>$latesum</td></tr>\n};

}

print qq{</table></body></html>\n};

