#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

my %lex = ('Main' => 'Main',
	   'Set' => 'Set',
	   'Color' => 'Color',
	   'Error' => 'Error',
	   'Cannot open file' => 'Cannot open file',
	   'Old' => 'Old',
	   'New' => 'New',
	   'File' => 'File',
	   'Updated' => 'Updated',
	   'Click' => 'Click',
	   'or' => 'or',
	   'Continue' => 'Continue',
	   'Eoy' => 'Eoy',

	   );

my $self = 'setcolor.pl';

use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Print Page Header
print qq{$doctype\n<html><head><title>$lex{Set} $lex{Color}</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};

if ( not $arr{page} ) {
    print qq{<script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/1.6.2/jquery.min.js">};
    print qq{</script>\n};
    print qq{<script type="text/javascript" src="/farbtastic/farbtastic.js"></script>\n};
    print qq{<link rel="stylesheet" href="/farbtastic/farbtastic.css" type="text/css">\n};

    print qq{<script type="text/javascript" charset="utf-8">\n};
    print q{ $(document).ready(function() { 
	$('#picker').farbtastic('#color');
	}); };
    print qq{</script>\n};
}


print qq{$chartype\n</head><body style="margin:2em;">\n};

print qq{[ <a href="$homepage">$lex{Main}</a> | \n};
print qq{<a href="$eoypage">$lex{Eoy}</a> ]\n};

print qq{<h1>$lex{Set} $lex{Color}</h1>\n};


if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    confirmColor();

} elsif ( $arr{page} == 2 ) {
    delete $arr{page};
    setColor();
}



#---------------
sub confirmColor {
#---------------

    # foreach my $key ( sort keys %arr) { print qq{K:$key V:$arr{$key}<br>\n}; }

    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="2">\n};
    print qq{<input type="hidden" name="color" value="$arr{color}">\n};

    print qq{<table cellpadding="3" cellspacing="0" border="1">\n};
    print qq{<tr><td style="background-color:$arr{color};">&nbsp;&nbsp;&nbsp;</td></tr>};

    print qq{<tr><td><input type="submit" value="$lex{Set} $lex{Color}"></td></tr>\n};

    print qq{</table></form></body></head>\n};

    exit;
}



#----------------
sub showStartPage {
#----------------

    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};

    print qq{<div class="form-item">Color: \n};
    print qq{<input type="text" id="color" name="color" value="#123456"></div>\n};
    print qq{<div id="picker" style="display:inline;"></div>\n};

    print qq{<input type="submit" value="$lex{Continue}"></form>\n};
    print qq{</body></html>\n};

    exit;

}



#-----------
sub setColor { # write color updates to admin.css
#-----------

    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};

    #foreach my $key ( sort keys %arr) { print qq{K:$key V:$arr{$key}<br>\n}; }

    my $newcolor = $arr{color};

    # Read in admin.css file
    unless (open ( FH,"<../../admin/admin.css")) {
	print $lex{'Cannot open file'}. ": $!\n";
	die $lex{'Cannot open file'}. ": $!\n";
    }
    my $text;
    { local $/; $text = <FH>; close FH;}

    $text =~ m/<<Color:(.*)>>/;
    my $oldcolor = $1;
    print qq{$lex{Old} $lex{Color}: $oldcolor<br>$lex{New} $lex{Color}: $newcolor<br>\n};

    $text =~ s/$oldcolor/$newcolor/g;

    # open for writing.
    unless (open ( FH,">../../admin/admin.css")) {
	print $lex{'Cannot open file'}. ": $!\n";
	die $lex{'Cannot open file'}. ": $!\n";
    }

    print FH $text;
    close FH;


    print qq{<h1><b>admin.css</b>: $lex{File} $lex{Updated}</h1>\n};

    print qq{</form></body></html>\n};
    exit;

}
