#!/usr/bin/perl
#  Copyright 2001-2021 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Student Infractions' => 'Student Infractions',
	   'Main' => 'Main',
	   'Discipline' => 'Discipline',
	   'Error' => 'Error',
	   'Totals' => 'Totals',
	   'Infractions' => 'Infractions',

	   );

my $self = 'rptDisc1.pl';

use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;

# Set Date
my @tim = localtime(time);
my $cyear = @tim[5] + 1900;
my $cmonth = @tim[4] + 1;
my $cday = @tim[3];
my $currdate = "$cyear-$cmonth-$cday";
my $curryrmo = "$cyear-$cmonth";


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


my $title = "$lex{'Student Infractions'}";
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};
print qq{$chartype\n</head><body>\n};

print qq{[ <a href="$homepage">$lex{Main}</a> | \n};
print qq{<a href="$discpage">$lex{Discipline}</a> ]\n};

print qq{<h1>$title</h1>\n};


#if ( not $arr{page} ) {
#    showStartPage();

#} elsif ( $arr{page} == 1 ) {
#    delete $arr{page};
    showReport();
#}


    
#---------------
sub showReport {
#---------------

    my ($y,$m,$d) = split('-', $currdate);
    my $displaydate = "$month[$m] $d, $y";
    print qq{<h3>$displaydate</h3>\n};
    
    # Get Infractions
    my %infractions;
    my $sth = $dbh->prepare("select distinct infraction from disc_event");
    $sth->execute;
    if ($DBI::errstr) {print qq{Error: $DBI::errstr}; die;}
    while (my $inf = $sth->fetchrow ) {
	$infractions{$inf} = 1;
    }

    # Set curr yr,mo 
    my @tim = localtime(time);
    my $cyear = @tim[5] + 1900;
    my $cmonth = @tim[4] + 1;
    my $cday = @tim[3];
    

    # Setup Year-Months.
    my @months;
    my %months;

    my ($sy, $sm, $sd) = split('-', $schoolstart); # schoolstart is global var from config.
    my $yrmo = "$sy-$sm";
    push @months, $yrmo;
    $months{$yrmo} = "$s_month[$sm]-$sy";

    for my $i (1..10) {
	my $mo = $sm + $i;
	my $yr = $sy;
	if ( $mo > 12 ) {
	    $mo = $mo - 12;
	    $yr++;
	}

	if ( length $mo == 1 ) { $mo = '0'. $mo; }
	my $yrmo = "$yr-$mo";
	push @months, $yrmo;
	$months{$yrmo} = "$s_month[$mo]-$yr";

#	print "YR:$yr MO:$mo<br>\n";
	
	if ( $yr == $cyear and $mo == $cmonth ) { # done
	    last;
	}
	
    }


    my %data;  # data{yrmo}{infraction} = 1;
    my $sth = $dbh->prepare("select count(*) from disc_event where month(date) = ? 
       and year(date) = ? and infraction = ?");

    
    foreach my $inf ( %infractions ) {
	foreach my $yrmo ( @months ) {
	    my ($y,$m ) = split('-', $yrmo);
	    $sth->execute($m,$y, $inf);
	    if ($DBI::errstr) {print qq{Error: $DBI::errstr}; die;}
	    my $count = $sth->fetchrow;
	    $data{$inf}{$yrmo} = $count;
	}
    }
    
    
    print qq{<table cellpadding="3" border="1" cellspacing="0">\n};
    # Header
    print qq{<tr><th>$lex{Infraction}</th>};
    foreach my $yrmo (@months ) {
	print qq{<th>$months{$yrmo}</th>};
    }
    print qq{<th>$lex{Totals}</th></tr>\n};

    # Data
    foreach my $inf ( sort keys %infractions ) {
	print qq{<tr><td class="bla">$inf</td>\n};
	my $total;
	foreach my $yrmo ( @months ) {
	    print qq{<td class="bcn">$data{$inf}{$yrmo}</td>};
	    $total += $data{$inf}{$yrmo};
	}
	print qq{<td style="background-color:#DDD;" class="bcn">$total</td></tr>\n};
    }

    print qq{</table>\n};
    print qq{</p></body></html>\n};

    exit;

}


#----------------
sub showStartPage {
#----------------

    print qq{<form action="$self" method="post" style="display:inline;padding:0.3em;">\n};
    print qq{<input type="hidden" value="1" name="page">\n};

    print qq{<input type="submit" value="$lex{Search}">\n};
    print qq{<input type="text" name="student" size="30">\n};
    print qq{$lex{Student} ($lex{'Last,First/Last/Initials/Studnum'})  $lex{'Blank=All'}<br>\n};

    print qq{<input type="checkbox" name="summary" value="1"> $lex{Summary}?\n};

    print qq{</form>\n};

    print qq{</body></html>\n};
    exit;

}
