#!/usr/bin/perl
#  Copyright 2004-2011 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Error' => 'Error'
    );


use DBI;
use CGI;

# Check for duplicates

my $q = new CGI;
print $q->header();

# Read config variables
require "../etc/admin.conf" || die "Cannot read admin.conf!";


my $dsn = "DBI:$dbtype:$dbase";
my $dbh = DBI->connect($dsn,$user,$password);

my $sth = $dbh->prepare("select studnum, lastname, firstname from student 
 order by studnum");
$sth->execute;
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

print qq{$doctype\n<title>Duplicate Check!</title>\n};
print qq{<link rel="stylesheet" href="/admin.css" type="text/css">\n};
print qq{</head><body>\n};
print qq{<h1>Duplicate Student Number Checking</h1>\n};

my $currstud;
my $currname;
my $first = 1;

while ( my ($studnum, $lastname, $firstname ) = $sth->fetchrow ){

    $oldstud = $currstud;
    $currstud = $studnum;

    $oldname = $currname;
    $currname = "$lastname $firstname";

    if ( $currstud == $oldstud ) { # Ack! We have a duplicate!
	$first = 0;
	print qq{<p>Duplicate for student number: $currstud<br>
         $currname and $oldname are duplicated!</p>\n};
    }
}

if ( $first ) {
    print qq{<p>No duplicates found.</p>\n};
}

print qq{</body></html>\n};
