#!/usr/bin/perl
#  Copyright 2001-2022 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Withdraw' => 'Withdraw',
	   'Student' => 'Student',
	   'No Student(s) Found' => 'No Student(s) Found',
	   'Withdrawn' => 'Withdrawn',
	   'Contact' => 'Contact',
	   'Main' => 'Main',
	   'Error' => 'Error',
	   'Last,First/Last/Initials/Studnum' => 'Last,First/Last/Initials/Studnum',
	   'Search' => 'Search',
	   'Name' => 'Name',
	   'Birthdate' => 'Birthdate',
	   'Grade' => 'Grade',
	   'Homeroom' => 'Homeroom',
	   'Province' => 'Province',
	   'Country' => 'Country',
	   'Description' => 'Description',
	   'Reason' => 'Reason',
	   'Code' => 'Code',
	   'Transfer' => 'Transfer',
	   'Date' => 'Date',
	   'Yes' => 'Yes',
	   'Delete' => 'Delete',
	   'Insert' => 'Insert',
	   'Cannot open' => 'Cannot open',
	   'Student Number' => 'Student Number',

	   );

use DBI;
use CGI;
use Time::JulianDay;


my $self = 'movestudent.pl';

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

# Load audit write function
eval require "../../lib/libaudit.pl";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}


my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);



# Page Header.
my $title = qq{Move $lex{Student} to Withdrawn};
print qq{$doctype\n<html><head><title>$title</title>
<link rel="stylesheet" href="$css" type="text/css">\n};
print qq{$chartype\n</head>\n};
print qq{<body>\n};


print qq{<div>[ <a href="$homepage">$lex{Main}</a> ]</div>\n};
print qq{<h1>$title</h1>\n};


if ( not $arr{page} ) {
    showStartPage();

}  elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    moveStudent();
}




#----------------
sub showStartPage {
#----------------

    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};

    print qq{<table cellpadding="3" cellspacing="0" border="0" };
    print qq{style="padding:0.5em;border:1px solid gray;">\n};
    
    print qq{<tr><td class="ra">$lex{Student} Number</td>\n};
    print qq{<td class="la"><input type="text" name="studnum" style="width:30ch;"></td></tr>\n};

    print qq{<tr><td><input type="submit" value="Move Student to Withdrawn"></td></tr>\n};
    print qq{</table>\n};
    
    print qq{</form>\n};
    print qq{</body></html>\n};

    exit;

} # end of showStartPage


#------------------
sub moveStudent {
#------------------

    # foreach my $key (keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    # Passed fields: studnum
    
        
    # Check that the student IS a current student.
    # Shouldn't be necessary, since we only search current students at the start.
    my $sth = $dbh->prepare("select * from student where studnum = ?"); # not studentwd/studentall
    $sth->execute( $arr{studnum} );
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
    my $ref = $sth->fetchrow_hashref; # use this for transfer records.

    $sth->execute( $arr{studnum} );
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
    my @student = $sth->fetchrow;
    if ( not $student[0] ) { # not a current student.
	print qq{<h3>$lex{Error}: You cannot withdraw a student who is already withdrawn!</h3>\n};
	print qq{</body></html>\n};
	exit;
    }

   
    # Insert Student Record into WD student table
    foreach my $studfld ( @student ){ 
	$studfld = $dbh->quote( $studfld );
    }
    $student[0] = $sql{default};  # reset the studid/id to NULL.
    my $studentstr = join(', ', @student);

    $sth = $dbh->prepare("insert into studentwd values ( $studentstr )");
    $sth->execute;

    if ( $DBI::errstr) {
	print qq{<h3>$lex{Insert} $lex{Student} $lex{Error}:};
	print qq{$lex{Contact} $adminname };
	print qq{[ <a href="mailto:$adminemail">$adminemail</a><br>\n};
	print qq{$lex{Error}:$DBI::errstr</h3>\n};
	die qq{$lex{Error}:$self: $DBI::errstr\n};
    }
    print qq{<h3>$lex{Student} -> $lex{Withdrawn} $lex{Student}</h3>\n};


    # Delete Original Student Record from student table
    $sth = $dbh->prepare("delete from student where studnum = ?"); 
    $sth->execute( $arr{studnum} );

    if ( $DBI::errstr) {
	print qq{<h3>$lex{Delete} $lex{Student} $lex{Error}:};
	print qq{$lex{Contact} $adminname };
	print qq{[ <a href="mailto:$adminemail">$adminemail</a><br>\n};
	print qq{$lex{Error}:$DBI::errstr</h3>\n};
	die qq{$lex{Delete} $lex{Student} $lex{Error}:$self: $DBI::errstr\n};
    }


    print qq{<p>[ <a href="$homepage">$lex{Main}</a> ]</p>\n};
    print qq{</body></html>\n};

} # end of moveStudent
