#!/usr/bin/perl
#  Copyright 2001-2021 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Name' => 'Name',
	   'Date' => 'Date',
	   'Description' => 'Description',
	   'Are you sure' => 'Are you sure',
	   'Main' => 'Main',
	   'Transfers' => 'Transfers',
	   'Contact' => 'Contact',
	   'Record Deleted' => 'Record Deleted',
	   'Error' => 'Error',
	   'Delete the Record' => 'Delete the Record',
	   'Student Not Found' => 'Student Not Found',
	   'Type' => 'Type',
	   'Yes' => 'Yes',
	   'Delete' => 'Delete',
	   'Edit' => 'Edit',
	   'View' => 'View',
	   'Another' => 'Another',

	   );

my $self = 'transdel.pl';

use CGI;
use DBI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


my $title = "$lex{Delete} $lex{Transfers}";
print qq{$doctype\n<html><head><title>$title</title>
<link rel="stylesheet" href="$css" type="text/css"> 
$chartype\n</head><body>\n};
print qq{[ <a href="$homepage">$lex{Main}</a> ]\n};

if ( $arr{deleteflag} ) {
    deleteRecord();
}

$sth = $dbh->prepare("select studnum, type, lastname, firstname, middlename, 
 date, description from transfer where id = ?"); 
$sth->execute( $arr{id} );
if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
my ( $studnum, $type, $lastname, $firstname, $middlename, $date, $description ) = 
    $sth->fetchrow;

if ( not $studnum ) {
    print qq{<h1>$lex{'Student Not Found'}</h1>\n};
    print qq{</body></html>\n};
    exit;
}


print qq{<h1>$title</h1>\n};
print qq{<table cellpadding="3" cellspacing="0" border="0">\n};

print qq{<tr><td class="bra">$lex{Type}</td><td>$type</td></tr>\n};

print qq{<tr><td class="bra">$lex{Name}</td>\n};
print qq{<td>$firstname $middlename $lastname ($studnum)</td></tr>\n};

print qq{<tr><td class="bra">$lex{Date}</td>\n};
print qq{<td>$date</td></tr>\n};

print qq{<tr><td class="bra">$lex{Description}</td><td>$description</td></tr>\n};
print qq{</table>\n};

print qq{<h3>$lex{Delete}: $lex{'Are you sure'}?</h3>\n};

print qq{<form action="$self" method="post">\n};
print qq{<input type="hidden" name="id" value="$arr{id}">\n};
print qq{<input type="hidden" name="deleteflag" value="1">\n};
print qq{<input type="submit" value="$lex{Yes}, $lex{'Delete the Record'}">\n};

print qq{</form></body></html>\n};



#---------------
sub deleteRecord {
#---------------

    delete $arr{deleteflag};

    my $sth = $dbh->prepare("delete from transfer where id = ?");
    $sth->execute( $arr{id} );
    
    if ( $DBI::errstr ) {
	print qq{<h3>$lex{Error}: $DBI::errstr<br>\n};
	print qq{$lex{Contact}: $adminname</h3>\n};
    } else {
	print qq{<h1>$lex{'Record Deleted'}</h1>\n};
    }

    print qq{<table cellpadding="0"><tr><td valign="top">\n};

    print qq{<form action="transview.pl" method="post">\n};
    print qq{[ <input type="submit" value="$lex{Edit}/$lex{View} $lex{Another}">\n};
    print qq{<select name="sort"><option value="date">$lex{Date}</option>};
    print qq{<option value="name">$lex{Name}</option></select></form>\n};

    print qq{</td><td valign="top">| <a href="$homepage">$lex{Main}</a> ]</td>\n};
    print qq{</tr></table></body></html>\n};

    exit;

}
