#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = (
	   'Edit Waiting List' => 'Edit Waiting List',
	   'Main' => 'Main',
	   'Eoy' => 'Eoy',
	   'Name' => 'Name',
	   'Date' => 'Date',
	   'Wait Number' => 'Wait Number',
	   'Description' => 'Description',
	   'Update Entry' => 'Update Entry',
	   'View Waiting List' => 'View Waiting List',
	   'There was an error storing your data' => 'There was an error storing your data',
	   'Your update is now stored' => 'Your update is now stored',
	   'Contact' => 'Contact',
	   'Error' => 'Error',

	);

my $self = 'waited.pl';

use CGI;
use DBI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Load record
$sth = $dbh->prepare("select * from prereg_waitlist where id = ?"); 
$sth->execute( $arr{id} );
if ( $DBI::errstr ) {print $DBI::errstr; die $DBI::errstr;}
my ( $id, $studnum, $enroldate, $waitnumber, $desc) = $sth->fetchrow;

$sth = $dbh->prepare("select lastname, firstname from prereg where studnum = ?"); 
$sth->execute( $studnum );
if ($DBI::errstr) {print $DBI::errstr; die $DBI::errstr;}
my ($lastname, $firstname) = $sth->fetchrow;


# Print Page Head.
my $title = $lex{'Edit Waiting List'};

print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{</title>\n<link rel="stylesheet" href="$css" type="text/css">\n};
print qq{$chartype\n</head><body>};
print qq{[ <a href="$homepage">$lex{Main}</a> |\n};
print qq{<a href="$eoypage">$lex{Eoy}</a> ]\n};
print qq{<h1>$schoolname - $title</h1>\n};

if ( $arr{writeflag} ) {
    delete $arr{writeflag};
    updateRecord();
}


# Start form
print qq{<form action="waited.pl" method="post">\n};
print qq{<table cellpadding="3" border="1" cellspacing="0">\n};
print qq{<input type="hidden" name="id" value="$id">\n};
print qq{<input type="hidden" name="writeflag" value="1">\n};

print qq{<tr><th class="cn">$lex{'Name'}</th>
<th style="font-size:140%;padding:0.4em;">$firstname $lastname ($studnum)</th></tr>\n};

print qq{<tr><td class="ra">$lex{'Date'}</td>\n};
print qq{<td><input type="text" name="enroldate" value="$enroldate" size="12"></td></tr>\n};

print qq{<tr><td class="ra">$lex{'Wait Number'}</td>\n};
print qq{<td><input type="text" name="waitnumber" value="$waitnumber" size="6"></td></tr>\n};

print qq{<tr><td class="ra">$lex{'Description'}</td>\n};
print qq{<td><textarea name="description" rows="3" cols="30">$desc</textarea></td></tr>\n};

print qq{</table><p><input type="submit" value="$lex{'Update Entry'}"></p>\n};

print qq{</form></body></html>\n};



#---------------
sub updateRecord {
#---------------

    #foreach my $key (keys %arr) { print qq{K:$key V:$arr{$key}<br>\n}; }
    my $sth = $dbh->prepare("update prereg_waitlist set
      enroldate = ?, description = ?, waitnumber = ? where id= ?");
    $sth->execute( $arr{enroldate}, $arr{description}, $arr{waitnumber}, $arr{id} );

    if ( not $DBI::errstr ) {
	print qq{<h3>$lex{'Your update is now stored'}</h3>\n};
    } else {
	print qq{<h3>$lex{'There was an error storing your data'}<br>\n};
	print qq{$DBI::errstr</h3>\n};
    }

    print qq{<p>[ <a href="waitview.pl">$lex{'View Waiting List'}</a> | };
    print qq{<a href="$homepage">$lex{Main}</a> ]</p></body></html>\n};

    exit;

}
