#!/usr/bin/perl
#  Copyright 2001-2009 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

# waitorder.pl - reorder the waiting list...

%lex = ('Main' => 'Main',
	'Eoy' => 'Eoy',
	'Waiting List' => 'Waiting List',
	'Reorder Waiting List' => 'Reorder Waiting List',
	'Waiting Number' => 'Waiting Number',
	'Student' => 'Student',
	'Back to Top' => 'Back to Top',
	'View Waiting List' => 'View Waiting List',
	'No Changes Required' => 'No Changes Required',
	'Error' => 'Error',

	);

my $self = 'waitorder.pl'; 

use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);



# page heading
print "$doctype\n<html><head><title>".$lex{'Reorder Waiting List'};
print "</title><link rel=\"stylesheet\" href=\"$css\" type=\"text/css\">
$chartype\n</head><body><a name=\"top\"></a>\n";
print "[ <a href=\"$homepage\">".$lex{'Main'}."</a> | 
<a href=\"$eoypage\">".$lex{'Eoy'}."</a> ]\n";

if ( $arr{writeflag} ) {
    updateRecords();
}

$sth = $dbh->prepare("select id, studnum, waitnumber from prereg_waitlist
order by waitnumber desc");
$sth->execute;
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr;}


print "<center><h1>",$lex{'Reorder Waiting List'},"</h1>\n";
print "<form action =\"$self\" method=\"post\">\n";
print "<input type=\"hidden\" name=\"writeflag\" value=\"1\">\n";
print "<table border=\"1\" cellpadding=\"3\" cellspacing=\"0\">\n";
print "<tr><td colspan=\"2\" align=\"center\">
 <input type=\"submit\" value=\"",$lex{'Reorder Waiting List'},"\">
 </td></tr>\n";
print '<tr><th>'.$lex{Student}.'</th><th>'.$lex{'Waiting List'}."</th></tr>\n";

my $sth1 = $dbh->prepare("select lastname, firstname
  from prereg where studnum = ?");

while ( my ( $id, $studnum, $waitnumber ) = $sth->fetchrow ) {

    $sth1->execute($studnum);
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my ($lastname, $firstname) = $sth1->fetchrow;

    print "<tr><td><b>$lastname</b>, $firstname ($studnum)</td><td>\n";
    print "<input name=\"$id\" value=\"$waitnumber\" size=\"10\"></td></tr>\n";

} 

print "<tr><td colspan=\"2\" align=\"center\">\n";
print "<input type=\"submit\" value=\"". $lex{'Reorder Waiting List'}. "\">";
print "</td></tr></table></form>\n";
print "[ <a href=\"#top\">",$lex{'Back to Top'},"</a> ]</body></html>\n";



#----------------
sub updateRecords {
#----------------

    delete $arr{writeflag};

    my $sth = $dbh->prepare("select waitnumber, studnum from prereg_waitlist
      where id = ?");

    my $sth1 = $dbh->prepare("select lastname, firstname
      from prereg where studnum = ?");

    my $sth2 = $dbh->prepare("update prereg_waitlist set waitnumber = ?
      where id = ?");

    print "<center><h1>",$lex{'Reorder Waiting List'},"</h1>\n";
    print "<table border=\"1\" cellpadding=\"3\" cellspacing=\"0\">\n";
    print "<tr><th>Student</th><th>",$lex{'Waiting Number'},"</th></tr>\n";
    my $first = 1;

    foreach my $key ( keys %arr){

	#print "K:$key V:$arr{$key}<br>\n";

	# Get Wait number and student number.
	$sth->execute($key);
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	my ($waitnumber, $studnum) = $sth->fetchrow;
	#print "WN: $waitnumber  SN: $studnum<br>\n";

	# Get Name... again.
	$sth1->execute($studnum);
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	my ($lastname, $firstname) = $sth1->fetchrow;

	if ($waitnumber ne $arr{$key}){ # then update
	    $first = 0;
	    $sth2->execute($arr{$key},$key);
	    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr;}
	    print "<tr><td>$lastname, $firstname</td><td>$arr{$key}</td></tr>\n";
	}
    }

    if ( $first ) {
	print "<tr><td colspan=\"2\"><b>". $lex{'No Changes Required'}."</td></tr>\n";
    }
    print "</table>\n";

    print "<p>[ <a href=\"waitview.pl\">". $lex{'View Waiting List'}. "</a> | ";
    print "<a href=\"$homepage\">". $lex{Main}. "</a> ]</p></body></html>\n";

    exit;

}
