#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

# based on staffview.pl This is still the klunky old stuff not based on meta or templates, yet.


use DBI;
use CGI;

my %lex = ('View' => 'View',
	   'Waiting List' => 'Waiting List',
	   'Main' => 'Main',
	   'Eoy' => 'Eoy',
	   'Name' => 'Name',
	   'Date' => 'Date',
	   'Wait Number' => 'Wait Number',
	   'Description' => 'Description',
	   'Delete' => 'Delete',
	   'Reorder' => 'Reorder',
	   'Enrol' => 'Enrol',
	   'Count' => 'Count',
	   'No Student(s) Found' => 'No Student(s) Found',
	   'Error' => 'Error',
	   'Pre-Registration' => 'Pre-Registration',
	   );

# Read config variables
eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@<br>\n";
}

my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Page Header
my $title = "$lex{View} $lex{'Waiting List'}";

print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};
print qq{$chartype\n</head><body>\n};

print qq{[ <a href="$homepage">$lex{Main}</a> |\n};
print qq{<a href="$eoypage">$lex{Eoy}</a> | };

print qq{<a href="waitorder.pl">$lex{Reorder} $lex{'Waiting List'}</a> |\n};
print qq{<a href="waitxfer.pl">$lex{Enrol} $lex{'Waiting List'}</a> ]\n};

print qq{<h1>$title</h1>\n};

# Get Waiting List
my $sth = $dbh->prepare("select * from prereg_waitlist order by waitnumber");
$sth->execute;
if ($DBI::errstr){ print $DBI::errstr; die "$DBI::errstr";}

print qq{<table cellpadding="3" border="1" cellspacing="0">\n};
print qq{<tr><th>$lex{Name}</th><th>$lex{Date}</th>};
print qq{<th>$lex{'Wait Number'}</th><th>$lex{Description}</th><th>$lex{Delete}</th></tr>\n};

my $sth1 = $dbh->prepare("select studid, lastname, firstname from prereg where studnum = ?");

my %waitlist;
my $count;
while ( my ($id, $studnum, $enroldate, $waitnumber, $desc) = $sth->fetchrow ) {
    
    $waitlist{$studnum} = 1; # hash to keep track of waiting list kids

    $sth1->execute($studnum);
    my ($studid, $lastname, $firstname) = $sth1->fetchrow;

    print qq{<tr style="line-height: 120%;">\n};
    print qq{<td><a href="../studed.pl?tb=prereg&id=$studid"><b>$lastname</b></a>, \n};
    print qq{$firstname ($studnum)</td>};
    print qq{<td><a href="waited.pl?id=$id">$enroldate</a></td>};
    print qq{<td class="cn"><a href="waited.pl?id=$id">$waitnumber</a></td>};
    print qq{<td><a href="waited.pl?id=$id">$desc</a></td>\n};
    print qq{<td><a href="waitdel.pl?id=$id">$lex{Delete}</a></td></tr>\n};
    $count++;
}

if (not $count) { 
    print qq{<tr><td colspan="5"><b>$lex{'No Student(s) Found'}</b></td></tr>\n}; 
} else {
    print qq{<tr><td colspan="5"><b>$lex{Count}: $count</b></td></tr>\n};
}
print qq{</table>\n};

# now print out rest of kids that are preregistered....
print qq{<p>&nbsp;</p><table cellpadding="3" border="1" cellspacing="0">\n};
print qq{<tr><th colspan="2">$lex{'Pre-Registration'}</th></tr>\n};


$sth = $dbh->prepare("select lastname, firstname, studnum from prereg
 order by lastname, firstname");
$sth->execute;
if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}

$count = 0;
while (my ($lastname, $firstname, $studnum) = $sth->fetchrow) {
    if ($waitlist{$studnum}) { next; }
    print qq{<tr><td><b>$lastname</b>, $firstname</td><td>$studnum</td></tr>\n};
    $count++;
}
print qq{</table>\n};
if (not $count) { 
    print qq{<b>$lex{'No Student(s) Found'}</b><br>\n}; 
} else {
    print qq{<b>$lex{Count}: $count</b>\n};
}

print qq{</body></html>\n};
