#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ( 'Student' => 'Student',
	    'Select' => 'Select',
	    'Wait#' => 'Wait#',
	    'Date' => 'Date',
	    'Description' => 'Description',
	    'Main' => 'Main',
	    'Duplicate Student Number' => 'Duplicate Student Number',
	    'Skipping' => 'Skipping',
	    'Contact' => 'Contact',
	    'Error' => 'Error',
	    'Waiting List' => 'Waiting List',
	    'Delete' => 'Delete',
	    'Enrol' => 'Enrol',
	    'Pre-Registration' => 'Pre-Registration',

	   );

my $self = 'waitxfer.pl';

# Reset to desired value; value for Sask
my $entrytype = '18'; # New Enrollment, no previous schooling.

use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


my $title = "$lex{Enrol} $lex{'Waiting List'}";

print qq{$doctype\n<html><head><title>$title</title>
<link rel="stylesheet" href="$css" type="text/css">
$chartype\n</head>\n};
print qq{<body>[ <a href="$homepage">$lex{Main}</a> ]\n};

if ($arr{updateflag}) {
    delete $arr{updateflag};
    doTransfers();
}


my $sth = $dbh->prepare("select * from prereg_waitlist order by waitnumber");
$sth->execute;
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

print qq{<h1>$title</h1>\n};

print qq{<form action="$self" method="post">\n};
print qq{<input type="hidden" name="updateflag" value="1">\n};

print qq{<table  border="1" cellpadding="3" cellspacing="0">\n};
print qq{<tr><th>$lex{Student}</th><th>$lex{'Wait#'}</th><th>$lex{Date}</th><th>};
print qq{$lex{Description}</th><th>$lex{Select}</th></tr>\n};

my $sth1 = $dbh->prepare("select lastname, firstname from prereg where studnum = ?");

while ( my ( $id, $studnum, $enroldate, $waitnumber, $description) = $sth->fetchrow ) {

    $sth1->execute($studnum);
    my ($lastname, $firstname) = $sth1->fetchrow;

    print qq{<tr><td><b>$lastname</b> $firstname ($studnum)</td>\n};
    print qq{<td class="cn">$waitnumber</td><td>$enroldate</td>\n};
    print qq{<td>$description</td><td class="cn">};
    print qq{<input type="checkbox" name="$studnum" value="1"></td></tr>\n};

} # End of loop

print qq{<tr><td colspan="5" class="cn">};
print qq{<input type="submit" value="$title">\n};
print qq{</td></tr></table>\n};
print qq{</form></body></html>\n};



#--------------
sub doTransfers {
#--------------

    # Get current date
    my @tim = localtime(time);
    my $year = @tim[5] + 1900;
    my $month = @tim[4] + 1;
    my $day = @tim[3];
    my $currdate = "$year-$month-$day";


    foreach my $key ( keys %arr) {

	my $sth = $dbh->prepare("select * from prereg where studnum = ?");
	$sth->execute( $key );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
	@student = $sth->fetchrow;

	# now get hash of student record
	$sth->execute( $key );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
	my $ref = $sth->fetchrow_hashref;
	my %sr = %$ref;
	
	# Check for existing student number.
	$sth = $dbh->prepare("select count(*) from student where studnum = ?");
	$sth->execute( $key );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
	my $count = $sth->fetchrow;
	if ( $count  > 0 ){ # We have a duplicate record coming out of prereg.
	    print qq{<h1>$lex{'Duplicate Student Number'}};
	    print qq{ - $student[2] $student[1]</h1>\n};
	    print qq{<h1>$lex{Skipping}</h1>\n};
	    next;
	}

	# Prepare student array for record entry
	$student[0] = $sql{default};  # reset the studid/id
	foreach my $studfld ( @student ) { 
	    if ( $studfld ne $sql{default} ) { $studfld = $dbh->quote( $studfld ); }
	}
	my $studentstr = join(', ', @student);

	$sth = $dbh->prepare("insert into student values ( $studentstr )");
	$sth->execute;
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}

	
	# Insert Transfer Record; entrytype code defined at top of script
	$sth2 = $dbh->prepare("insert into transfer 
         ( studnum, date, type, description, entrytype, lastname, firstname, birthdate )
         values (?,?,?,?,?,?,?,?)");
	
	$sth2->execute( $key, $currdate, 'enrol', $lex{'Pre-Registration'},
			$entrytype, $sr{lastname}, $sr{firstname}, $sr{birthdate});
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }


	# Delete records from existng prereg and prereg_waitlist
	$sth = $dbh->prepare("delete from prereg where studnum = ?"); 
	$sth->execute( $key );

	$sth = $dbh->prepare("delete from prereg_waitlist where studnum = ?"); 
	$sth->execute( $key );


	if ( $DBI::errstr) {
	    print qq{<h3>$lex{Error} $lex{Delete} $lex{'Waiting List'}<br>\n};
	    print qq{$DBI::errstr</h3>\n};

	    print qq{</body></html>\n};
	    exit;
	}


    } # end of Loop 

    if (not $DBI::errstr ) {
	print qq{<h3>$lex{'Waiting List'} => $lex{Student}</h3>\n};

    } else {
	print qq{<h3>$lex{Error}:$DBI::errstr</h3>\n};

    }

    print qq{<p>[ <a href="$homepage">$lex{Main}</a> ]</p>};
    print qq{</body></html>\n};

    exit;
}
