#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

# Export Contact Name, rather than Student Name

my %lex = ('Main' => 'Main',
	   'Export' => 'Export',
	   'Export Student Table' => 'Export Student Table',
	   'Records' => 'Records',
	   'Combine failed on input' => 'Combine failed on input',
	   'Download CSV Labels File' => 'Download CSV Labels File',
	   'CSV (Comma Separated Value) can be directly imported into Open Office' =>
	     'CSV (Comma Separated Value) can be directly imported into Open Office',
	   'Note' => 'Note',
	   'Cannot open Export file' => 'Cannot open Export file',
	   'Cume Labels' => 'Cume Labels',
	   'Error' => 'Error',
	   
	   );


use DBI;
use CGI;
use Text::CSV_XS;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

my $q = CGI->new;
print $q->header( -charset, $charset );

my $csv = Text::CSV_XS->new( {binary => 1} );

# Open output file
my $fileName = "cumlabel$$.csv";
open (EX,">$fileName") || die $lex{'Cannot open Export file'}. " $fileName";

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);

my $sth = $dbh->prepare("select * from student 
  order by grade, homeroom, lastname,firstname");

$sth->execute;
$rows = $sth->rows;

my $title = $lex{'Export Student Table'};

print qq{$doctype\n<html><head><title>$title</title>
<link rel="stylesheet" type="text/css" href="$css">
$chartype\n</head><body>\n};

print qq{[ <a href="$homepage">$lex{Main}</a> | \n};
print qq{<a href="$exppage">$lex{Export}</a> ]\n};

print qq{<h1>$title - $lex{'Cume Labels'}</h1>\n};

print qq{<p>$lex{Records}: $rows</p>\n};

for ($i=1; $i <= $rows; ++$i) {
    @arr = $sth->fetchrow;

    foreach $element (@arr) {  # strip CR/LF
	$element =~ s/\n/ /g;
	$element =~ s/\r/ /g;
    }  

    @labels[0] = "$arr[2] $arr[1]";  # Student Name
    @labels[1] = $arr[7];            # Sex
    @labels[2] = $arr[8];            # Birthdate
    @labels[3] = $arr[10];           # Health ID
    @labels[4] = $arr[27];           # Relation 1
    @labels[5] = $arr[29];           # Name 1
    @labels[6] = $arr[38];           # Relation 2
    @labels[7] = $arr[40];           # Name 2
    @labels[8] = $arr[12];           # Ethnic 
    @labels[9] = $arr[57];           # Prov Number

    if ($csv->combine(@labels)) {
	my $record = $csv->string;
	print EX $record, "\r\n";
    } else {
	my $err = $csv->error_input;
	print qq{$lex{'Combine failed on input'}:$err\n};
    }
}

close EX;
system("mv $fileName $downloaddir");

print qq{<p><a href="$webdownloaddir/$fileName">\n};
print qq{$lex{'Download CSV Labels File'}</a></p>\n};

print qq{<p><strong>$lex{Note}:</strong>}; 
print qq{CSV (Comma Separated Value) can be directly imported into a spreadsheet</p>\n};

print qq{</body></html>\n};
