#!/usr/bin/perl
#  Copyright 2001-2021 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

# Export Contact Name, rather than Student Name

my %lex = ('Main' => 'Main',
	   'Export' => 'Export',
	   'Student' => 'Student',
	   'Staff' => 'Staff',
	   'Photography' => 'Photography',
	   'Combine failed on input' => 'Combine failed on input',
	   'CSV Photo File' => 'CSV Photo File',
	   'Download' => 'Download',
	   'Note' => 'Note',
	   'Cannot open' => 'Cannot open',
	   'Error' => 'Error',
	   
	   );


use DBI;
use CGI;
use Text::CSV_XS;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

my $q = CGI->new;
print $q->header( -charset, $charset );

my $csv = Text::CSV_XS->new( {binary => 1} );

# Open output file
my $fileName = "photo$$.csv";
open (EX,">$fileName") || die $lex{'Cannot open'}. " Export file $fileName\n";

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Print Page Header
my $title = "$lex{Export} $lex{Student}/$lex{Staff} - $lex{Photography}";
print qq{$doctype\n<html><head><title>$title</title>
<link rel="stylesheet" type="text/css" href="$css">
$chartype\n</head><body>\n};

print qq{[ <a href="$homepage">$lex{Main}</a> | \n};
print qq{<a href="$exppage">$lex{Export}</a> ]\n};

print qq{<h1>$title</h1>\n};


# Do Staff First
$sth = $dbh->prepare("select * from staff
 order by lastname,firstname");
$sth->execute;
if ($DBI::errstr){ print $DBI::errstr; die;}
while ( my @staff = $sth->fetchrow ) {

    foreach $element (@staff) {  # strip CR/LF
	$element =~ s/\n/ /g;
	$element =~ s/\r/ /g;
    }

    @labels[1] = "$staff[1] $staff[3] $staff[2]";  # Staff Name: sal lastname firstname
    @labels[0] = "";            # unused Studnum 
    @labels[2] = "";            # unused Grade 
    @labels[3] = "";            # unused Homeroom

    if ($csv->combine(@labels)) {
	my $record = $csv->string;
	print EX $record, "\r\n";
    } else {
	my $err = $csv->error_input;
	print $lex{'Combine failed on input'}. ": ",$err,":\n\n";
    }
}


# Now do the students
my $sth = $dbh->prepare("select lastname, firstname, studnum, grade, homeroom, 
			CAST(grade as SIGNED) as castgrade from student 
			order by castgrade, homeroom, lastname,firstname");
$sth->execute;
if ($DBI::errstr){ print $DBI::errstr; die;}
while ( my $ref = $sth->fetchrow_hashref ) {
    my %r = %$ref;

    foreach $element (@arr) {  # strip CR/LF
	$element =~ s/\n/ /g;
	$element =~ s/\r/ /g;
    }  

    my @labels;
    @labels[1] = qq{$r{firstname} $r{lastname}};  # Student Name
    @labels[0] = $r{studnum};            # Studnum 
    @labels[2] = $r{grade};            # Grade 
    @labels[3] = $r{homeroom};            # Homeroom

    if ($csv->combine(@labels)) {
	my $record = $csv->string;
	print EX $record, "\r\n";
    } else {
	my $err = $csv->error_input;
	print $lex{'Combine failed on input'}. ": ",$err,":\n\n";
    }
}

close EX;
system("mv $fileName $downloaddir");

print qq{<div style="margin:1em;font-size:120%;font-weight:bold;">};
print qq{<a href="$webdownloaddir/$fileName">\n};
print qq{<span tyle="font-size:120%;">$lex{Download} $lex{'CSV Photo File'}</span></a></div>\n};

print qq{<div style="border:1px solid gray;width:50ch;padding:0.6em;margin:1em;"><i>$lex{Note}</i>: \n};
print qq{You should "right click" on this link and save the file.\n};
print qq{This should be attached to an email and sent to the folks taking the school pictures. \n};
print qq{The staff names are at the top of the list, followed by students sorted by grade. The \n};
print qq{student information is student number, name, grade, and homeroom.\n};
print qq{</div>\n};

print qq{</body></html>\n};
