#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('View Assessed Fees' => 'View Assessed Fees',
	   'Fees' => 'Fees',
	   'Main' => 'Main',
	   'No Records Found' => 'No Records Found',
	   'Top' => 'Top',
	   'Error' => 'Error',

	   );

my $self = 'assessview.pl';

use DBI;
use CGI;
use Cwd;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);



# Print Page Header
my $title = $lex{'View Assessed Fees'};

print qq{$doctype\n<html><head><title>$title</title>
<link rel="stylesheet" href="$css" type="text/css">
</head><body>\n};
print qq{<a name="top"></a>\n};

print qq{[ <a href="$homepage">$lex{Main}</a> |\n};
print qq{<a href="$feespage">$lex{Fees}</a> ]\n};

print qq{<h1>$title</h1>\n};


my $sth = $dbh->prepare("show columns from fees_jrl");
$sth->execute;
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
while ( my @cols = $sth->fetchrow ) {
    push @fields, $cols[0];
}


$sth = $dbh->prepare("select * from fees_jrl order by id desc");
$sth->execute;
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
$rows = $sth->rows;

if ($rows < 1 ) {
    print qq{<p>$lex{'No Records Found'}</p>\n};
    print qq{</body></html>\n};
    exit;
}


print qq{<table border="1" cellpadding="2" cellspacing="0">\n};

print qq{<tr>};
foreach my $fld (@fields ) {
    print qq{<th>$fld</th>\n};
}
print qq{</tr>\n};


my $sth1 = $dbh->prepare("select lastname, firstname from studentall where studnum = ?");

# my $count = 1;

while ( my @arr = $sth->fetchrow ) {

    my $id = shift @arr;
    my $studnum = shift @arr;

    # Get Name
    $sth1->execute( $studnum );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my ($lastname, $firstname) = $sth1->fetchrow;

    print qq{<tr><td>$id</td><td>$firstname $lastname ($studnum)</td>\n};

    # now do the rest.
    foreach my $val ( @arr ) {
	print qq{<td>$val</td>};
    }
    print qq{</tr>\n};

#    $count++;
#    if ( $count > 5 ) { last; }

}

print qq{</table>\n};
print qq{<p>[ <a href="$feespage">$lex{Fees}</a> | <a href="#top">$lex{Top}</a> ]</p>\n};
print qq{</body></html>\n};
