#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = (
	   'View Invoices' => 'View Invoices',
	   'Fees' => 'Fees',
	   'Main' => 'Main',
	   'No Records Found' => 'No Records Found',
	   'Invoice' => 'Invoice',
	   'Top' => 'Top',
	   'Date' => 'Date',
	   'Name' => 'Name',
	   'Description' => 'Description',
	   'Subtotal' => 'Subtotal',
	   'Tax' => 'Tax',
	   'Total' => 'Total',
	   'Owing' => 'Owing',
	   'Paid' => 'Paid',
	   'Error' => 'Error',

	   );

my $self = 'invoiceview.pl';

use DBI;
use CGI;
use Cwd;
use Number::Format qw(round);

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Print Page Header
my $title = $lex{'View Invoices'};

print qq{$doctype\n<html><head><title>$title</title>
 <link rel="stylesheet" href="$css" type="text/css">
 </head><body><a name="top"></a>[ <a href="$homepage">$lex{Main}</a> |\n};
print qq{<a href="$feespage">$lex{Fees}</a> ]\n};


# Find Distinct Invoice Numbers (and not Receipt Numbers); push into invnums array
my @invnums;
my $sth = $dbh->prepare("select distinct invoice_number from fees_jrl 
 where invoice_number is not null and trans_type = 'chg' order by invoice_number");
$sth->execute;
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
while (my $invnum = $sth->fetchrow ) {
    push @invnums, $invnum;
}

print qq{<h1>$title</h1>\n};

if (not @invnums) {
    print qq{<p>$lex{'No Records Found'}</p>\n};
    print qq{</body></html>\n};
    exit;
}


print qq{<table border="1" cellpadding="2" cellspacing="0">\n};

foreach my $invnum (@invnums ) {
    printInvoice( $invnum );
}


print qq{</table>\n};
print qq{<p>[ <a href="$feespage">$lex{Fees}</a> | <a href="#top">$lex{Top}</a> ]</p>\n};
print qq{</body></html>\n};



#---------------
sub printInvoice {
#---------------

    my $invnum = shift;
    
    my $sth = $dbh->prepare("select * from fees_jrl where invoice_number = ? order by trans_date");
    $sth->execute( $invnum );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my $first = 1;

    my $sth1 = $dbh->prepare("select lastname, firstname from studentall
      where studnum = ?");

    my ($grandTotal, $grandTax, $grandSubtotal, $grandPaid, $grandOwing);

    while ( my ($id, $studnum, $trans_date, $trans_type, $name,
     $description, $subtotal, $tax1, $tax1_name, $tax2, $tax2_name, $tax3,
     $tax3_name, $tax4, $tax4_name, $total, $invoice_number, $invoice_date,
     $paid_id, $paid_part_id, $paid_part_amt) = $sth->fetchrow ) {

	if ( $first ) {

	    # Get Student Name...
	    $sth1->execute( $studnum );
	    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	    my ($lastname, $firstname) = $sth1->fetchrow;

	    print qq{<tr><th colspan="3">$firstname $lastname ($studnum)</th><th colspan="5">};
	    print qq{$lex{Invoice} $invoice_number - $invoice_date</th></tr>\n};

	    print qq{<tr><th>$lex{Date}</th><th>$lex{Name}</th>\n};
	    print qq{<th>$lex{Description}</th>};

	    print qq{<th>$lex{Subtotal}</th><th>$lex{Tax}</th><th>$lex{Total}</th>};
	    print qq{<th>$lex{Paid}</th><th>$lex{Owing}</th></tr>\n};

	    $first = 0;
	}

	$subtotal = round( $subtotal, 2);
	my $totaltax = round( $tax1 + $tax2 + $tax3 + $tax4, 2);

	my $paid = 0;
	if ( $paid_id ) { 
	    $paid = $total; 
	} elsif ( $paid_part_id ) {
	    $paid = $paid_part_amt;
	}
	$paid = round( $paid, 2);

	my $owing = round( $total - $paid, 2);

	$grandSubtotal += $subtotal;
	$grandTax += $totaltax;
	$grandTotal += $total;
	$grandPaid += $paid;
	$grandOwing += $owing;

	print qq{<tr><td>$trans_date</td><td>$name</td><td>$description</td><td>$subtotal</td>\n};
	print qq{ <td>$totaltax</td><td>$total</td><td>$paid</td><td>$owing</td></tr>\n};
    }

    print qq{<tr style="background-color:#DDD;"><td></td><td></td>};
    print qq{<td>$lex{Total}</td><td>}. round($grandSubtotal, 2). qq{</td>\n};
    print qq{<td>}. round( $grandTax, 2). qq{</td><td>}. round( $grandTotal, 2);
    print qq{</td><td>}. round( $grandPaid, 2). qq{</td>};
    print qq{<td>}. round( $grandOwing, 2). qq{</td></tr>\n};
    

} # End of printInvoice;
