#! /usr/bin/perl
#  Copyright 2001-2009 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.


use DBI;
use CGI;

my %lex = ('Lunch Report' => 'Lunch Report',
	   'Main' => 'Main',
	   'Fees' => 'Fees',
	   'View Log File' => 'View Log File',
	   'Ch' => 'Ch',
	   'Pd' => 'Pd',
	   'View/Print Student Lunch Attendance Form' => 
	     'View/Print Student Lunch Attendance Form',
	   'Meal Attendance Form' => 'Meal Attendance Form',
	   'Breakfast' => 'Breakfast',
	   'Lunch' => 'Lunch',
	   'After-School' => 'After-School',
	   'Circle Type' => 'Circle Type',
	   'Printed' => 'Printed',
	   'Date' => 'Date',
	   'Grade' => 'Grade',
	   'Error' => 'Error',

	   );

my $namewidth = '72mm';

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

eval require "../../lib/liblatex.pl";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}


my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, 
 $iddst) = localtime(time);
$year = $year + 1900;
$currdate = "$dow[$wday], $month[$mon] $mday, $year";


my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;


print "$doctype\n<html><head><title>". $lex{'Lunch Report'}. "</title>
<link rel=\"stylesheet\" href=\"$css\" type=\"text/css\">
$chartype\n</head><body>\n";

print "[ <a href=\"$homepage\">". $lex{Main}. "</a> |\n";
print "<a href=\"$feespage\">". $lex{Fees}. "</a> ]\n";

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


my $shortname = "lunch$$";
my $filename = "$shortname.tex";

open(TEX,">$filename") || die "Can't open tex file";

my $papersize;
if ( $defaultpapersize ) {
    $papersize = $defaultpapersize;
} else {
    $papersize = 'letterpaper';
}


print TEX "\\documentclass[12pt,$papersize]{article}
\\usepackage{array,colortbl,multicol,inputenc}
$a_latex_header
\\renewcommand{\\familydefault}{\\sfdefault}

%\\pagestyle{empty}
\\setlength{\\textwidth}{7.5in}
\\setlength{\\textheight}{10.5in}
\\setlength{\\hoffset}{-1.2in}
\\setlength{\\voffset}{-1.5in}
\\addtolength{\\evensidemargin}{0in}
\\addtolength{\\oddsidemargin}{0in}
\\setlength{\\tabcolsep}{3.5pt}
\\setlength{\\extrarowheight}{4pt}
\\setlength{\\parindent}{0pt}\n";

print TEX "\\begin{document}{\\sf\\LARGE ". $lex{'Meal Attendance Form'}. "} \\hfill\n";
print TEX "{\\bf ". $lex{'Circle Type'}. ":} ". $lex{Breakfast}. " / ";
print TEX $lex{Lunch}. " / ". $lex{'After-School'}. "\n\n";
print TEX "\\rule{0mm}{6mm}{\\tiny ". $lex{'Printed'}. ":$currdate}\\hfill {\\bf ";
print TEX $lex{Date}. ":} \\underline{\\hspace{3in}}\n\n";

$orderby = 'order by grade, lastname, firstname';

$sth = $dbh->prepare("select lastname, firstname, grade, studnum from student
  $select $orderby ");
$sth->execute;
if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
$rows = $sth->rows;

my $currgroup = -1;
my $oldgroup;
my $firstflag = 1;
my $breaker = 1;

while ( my ( $lastname, $firstname, $group, $studnum) = $sth->fetchrow ) {
    #@arr = latex_filter( @arr );

    $oldgroup = $currgroup;
    $currgroup = $group;

    if ($oldgroup ne $currgroup){
	if (not $firstflag){ 
	    print TEX "\\end{tabular}\\end{multicols}\n\\bigskip\n\n"; 
	} else { 
	    $firstflag = 0;
	}

	print TEX "\\begin{multicols}{2}";
	print TEX "\\begin{tabular}{|p{$namewidth}|p{0.3in}|p{0.3in}|}\\hline\n";
	#print TEX "\\multicolumn{2}{|c|}{\\rule[-2mm]{0mm}{9mm}";
	print TEX "\\rule[-2mm]{0mm}{9mm}{\\sf\\Large ". $lex{Grade}. " $currgroup} ";
	print TEX "&\\hfil{\\bf\\small ". $lex{Ch}. "}\\hfil&\\hfil{\\bf\\small ";
	print TEX  $lex{Pd}. "}\\hfil\\\\\\hline\\hline\n\n";
    }

    # Print the Line
    print TEX "$lastname, $firstname ($studnum) & & \\\\ \\hline\n";
    if ($breaker % 3 == 1){ 
	print TEX "\\end{tabular}\n";
	print TEX "\\begin{tabular}{|p{$namewidth}|p{0.3in}|p{0.3in}|}\\hline\n";
    }

    $breaker++;
} # End of main loop

print TEX "\\end{tabular}\n\n\\end{multicols}\n\\end{document}\n";
close TEX;

print "<center><h3><a href=\"$webdownloaddir/$shortname.pdf\">";
print $lex{'View/Print Student Lunch Attendance Form'}. "</a></h3>\n";

print "[ <a href=\"$feespage\">". $lex{Fees}. "</a> | 
 <a href=\"$webdownloaddir/pdflog$$.txt\">". $lex{'View Log File'}. "</a> ]\n";

system("$pdflatex $filename >pdflog$$.txt");
system("mv $shortname.pdf $downloaddir");
system("mv pdflog$$.txt $downloaddir");
system("rm -f $shortname.*");

print "</center></body></html>\n";
