#! /usr/bin/perl
#  Copyright 2001-2010 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.


my %lex = ( 'Main' => 'Main',
	    'Lunch Fees Owing' => 'Lunch Fees Owing',
	    'View Log File' => 'View Log File',
	    'Students' => 'Students',
	    'Room' => 'Room',
	    'Address/Ph' => 'Address/Ph',
	    'Name' => 'Name',
	    'Parent 1' => 'Parent 1',
	    'Parent 2' => 'Parent 2',
	    'Emergency' => 'Emergency',
	    'Rm' => 'Rm',
	    'Ph' => 'Ph',
	    'Error' => 'Error',
	    'View/Download' => 'View/Download',

	    );

my $self = 'lunchrptdue.pl';
my $maxlines = 18;

use DBI;
use CGI;

# Read config variables
eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

# Basic Constants
my $logfile = "pdflog$$.txt";
my $shortname = "lunchdue$$";
my $filename = "$shortname.tex";

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


my ($sec, $min, $hour, $mday, $mon, $year, $wday, 
 $yday, $iddst) = localtime(time);
$year = $year + 1900;
my $currdate = "$dow[$wday], $month[$mon] $mday, $year";

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;

if ( $arr{maxstudents} ) {
    $maxlines = $arr{maxstudents};
}


print "$doctype\n<html><head><title>". $lex{'Lunch Fees Owing'}. "</title>
<link rel=\"stylesheet\" href=\"$css\" type=\"text/css\">
$chartype\n</head><body>[ <a href=\"$homepage\">". $lex{Main}. "</a> ]\n";


$sortorder = "";
if ($arr{sortorder} eq "lastname") {
    $sortorder = " order by lastname, firstname";
} else {
    $sortorder = " order by homeroom, lastname, firstname";
}

open(TEX,">$filename") || die "Can't open tex file";

my $papersize;
if ( $defaultpapersize ) {
    $papersize = $defaultpapersize;
} else {
    $papersize = 'letterpaper';
}

print TEX "\\documentclass[10pt,$papersize]{article}
\\usepackage{array,colortbl,inputenc}
$a_latex_header
\\renewcommand{\\familydefault}{\\sfdefault}

\\pagestyle{empty}
\\setlength{\\textwidth}{8in}
\\setlength{\\textheight}{10.6in}
\\setlength{\\hoffset}{-1.6in}
\\setlength{\\voffset}{-1.4in}
\\setlength{\\parindent}{0pt}
\\setlength{\\extrarowheight}{1pt}
\\setlength{\\tabcolsep}{3.5pt}\n";


print TEX "\\begin{document}\n";

my $sth = $dbh->prepare("select * from student $sortorder");
$sth->execute;
if ($DBI::errstr){print $DBI::errstr; die;}

my $rows = $sth->rows;
my $curroom = -1;

for ($i=1; $i<=$rows; $i++) {
    my @arr = $sth->fetchrow;  # Read in a student record.
   
    $oldroom = $curroom;
    $curroom = $arr[6];

    foreach my $element (@arr) {  # Filter out any funny stuff to LaTeX
	$element =~ s/\\/\//g; # replace backslash with forward slash.
	$element =~ s/#/\\#/g;
	$element =~ s/&/\\&/g;
    }
   

    if ($oldroom eq $curroom) { # We have another record for same page
	$linecount++;
	$studcount++;

	if ($linecount > $maxlines) { # We'll print a new page header here
	    # New Page Header
	    $linecount = 0;
	    print TEX "\\end{tabular}\\\\ \n\\newpage\n";
	    prTitle();

	} # End of New Page Header due to too large class


	# Normal record printing.
	print TEX "{\\bf $arr[1]}, $arr[2] $arr[3] & $arr[34] & $arr[29] & $arr[40] & $arr[50] \\\\ \n";
	print TEX "$arr[4] b$arr[8] ". $lex{Rm}. ": $arr[6] & ". $lex{Ph}. ": $arr[30] & $arr[37] ";
	print TEX "$arr[31] & $arr[48] $arr[42] & $arr[51] $arr[52] \\\\ \\hline\n";
	
	
    } else {  # We are starting a new page

	# Get Teacher Name for the room.
	$sth1 = $dbh->prepare("select sal, firstname, lastname from staff as s, staff_multi as sm
          where sm.userid = s.userid and sm.field_name = 'homeroom' and field_value = ?");
	$sth1->execute( $curroom );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	my ($sal, $firstname, $lastname) = $sth1->fetchrow;
  
	if ($i != 1) {
	    print TEX $lex{Students}. ": $studcount & & & &  \\\\ \\hline\n \\end{tabular}\n\\newpage\n";
	}
	
	$linecount = 0;
	$studcount = 1;

	prTitle(); # print title
	print TEX "{\\bf $arr[1]}, $arr[2] $arr[3]& $arr[34]& $arr[29]& $arr[40]& $arr[50] \\\\ \n";
	print TEX "$arr[4] b$arr[8] ". $lex{'Rm'}. ": $arr[6]& ". $lex{Ph};
	print TEX ": $arr[30]& $arr[37] $arr[31]& $arr[48] $arr[42]& $arr[51] $arr[52] \\\\\\hline \n";

    }   

}  # End of For loop

print TEX $lex{'Students'}. ": $studcount & & & &  \\\\ \n \\hline\n";
print TEX "\\end{tabular}\\\\ \\end{document}";
close TEX;

system("$pdflatex $filename >$logfile");
system("mv $shortname.pdf $downloaddir");
system("mv $logfile $downloaddir");
system("rm $shortname.*");

print "<center><h1><a href=\"$webdownloaddir/$shortname.pdf\">";
print $lex{'View/Download'}. q{ }. $lex{'Lunch Fees Owing'}. "</a></h1>
[ <a href=\"$webdownloaddir/$logfile\">". $lex{'View Log File'}. "</a> |
<a href=\"$homepage\">". $lex{Main}. "</a> ]</center></body></html>\n";


#------------
sub prTitle { # Print Title at top of page.
#------------

    print TEX "\\center{\\sf{\\large $schoolname ". $lex{'Lunch Fees Owing'}. "} - $currdate \\\\\n";
    print TEX "$sal $firstname $lastname - ". $lex{Room}. ": $curroom}\\\\ \n";
    print TEX "\\medskip\n\\begin{tabular}{|p{4.5cm}|p{4.0cm}|p{3.5cm}|p{3.5cm}|p{3.5cm}|}\n";
    print TEX "\\hline\n\\rowcolor[gray]{0.85}{\\sf\\bf ". $lex{Name}. "} & {\\sf\\bf ". $lex{'Address/Ph'};
    print TEX "} & {\\sf\\bf ". $lex{'Parent 1'}. "} & {\\sf\\bf ". $lex{'Parent 2'}. "} & {\\sf\\bf ";
    print TEX $lex{Emergency}. "} \\\\\\hline\n";

}
