#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Record Deleted' => 'Record Deleted',
	   'View' => 'View',
	   'Predefined Fees' => 'Predefined Fees',
	   'Name' => 'Name',
	   'Description' => 'Description',
	   'Amount' => 'Amount',
	   'Discount' => 'Discount',
	   'Tax1' => 'Tax1',
	   'Tax2' => 'Tax2',
	   'Tax3' => 'Tax3',
	   'Tax4' => 'Tax4',
	   'Group Name' => 'Group Name',
	   'Group Value' => 'Group Value',
	   'Delete' => 'Delete',
	   'Grade' => 'Grade',
	   'Fees' => 'Fees',
	   'Main' => 'Main',
	   'No Record(s) Found' => 'No Record(s) Found',
	   'Top' => 'Top',
	   'Delete' => 'Delete',
	   'Error' => 'Error',
	   'Homeroom' => 'Homeroom',
	   'Student Number' => 'Student Number',

	   );

my $self = 'predefview.pl';

use DBI;
use CGI;
use Cwd;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}


my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;

if ( $arr{group} eq $lex{Grade} ){ 
    $group = 'grade';
} else {
    $group = 'homeroom';
}


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);

# Print Page Header
my $title = "$lex{View} $lex{'Predefined Fees'}";

print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};
print qq{</head><body><a name="top"></a>\n};

print qq{[ <a href="$homepage">$lex{Main}</a> |\n};
print qq{<a href="$feespage">$lex{Fees}</a> ]\n};

if ( $arr{id} ){ # passed an id to delete...
    deleteRecord();
}

my $sth = $dbh->prepare("select * from fees_predefined order by name");
$sth->execute;
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
my $rows = $sth->rows;

print qq{<h1>$title</h1>\n};

if ( $rows < 1 ) {
    print qq{<h3>$lex{'No Record(s) Found'}</h3>\n};
    print qq{</body></html>\n};
    exit;
}

my %groups = ( 'grade' => $lex{Grade}, 'homeroom' => $lex{Homeroom}, 'studnum' => $lex{'Student Number'} );


print qq{<table border="1" cellpadding="3" cellspacing="0">\n};
print qq{<tr><th>$lex{Name}</th><th>$lex{Description}</th><th>\n};
print qq{$lex{Amount}</th><th>$lex{Discount}</th><th>$lex{Tax1}};
print qq{</th><th>$lex{Tax2}</th><th>$lex{Tax3}</th>\n};

print qq{<th>$lex{Tax4}</th><th>$lex{'Group Name'}</th>};
print qq{<th>$lex{'Group Value'}</th><th>$lex{Delete}</th></tr>\n};

my $colcolor = 'gray'; # tr colors are blue or gray;
#my $currprofile = -1;

while ( my ($id,$name, $description, $amount, $discount, 
  $tax1_flag, $tax2_flag, $tax3_flag, $tax4_flag, 
  $group_name, $group_value) = $sth->fetchrow ) {

    $prevprofile = $currprofile;
    $currprofile = $profile;

    if ($colcolor eq 'blue'){ 
	$colcolor = 'gray';
    } else { 
	$colcolor = 'blue';
    }
    
    print qq{<tr class="$colcolor"><td>$name</td>\n};
    print qq{<td>$description</td><td>$amount</td><td>$discount</td><td>$tax1_flag</td>\n};
    print qq{<td>$tax2_flag</td><td>$tax3_flag</td><td>$tax4_flag</td><td>$groups{$group_name}</td>\n};
    print qq{<td>$group_value</td><td>};

    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="id" value="$id">\n};
    print qq{<input type="submit" value="$lex{Delete}">\n};
    print qq{</form></td></tr>\n};

}

print qq{</table>\n};
print qq{<p>[ <a href="$feespage">$lex{Fees}</a> |\n};
print qq{ <a href="#top">$lex{Top}</a> ]</p>\n};
print qq{</body></html>\n};



#---------------
sub deleteRecord { # delete a single record
#---------------

    my $sth = $dbh->prepare("delete from fees_predefined where id = ?");
    $sth->execute( $arr{id} );
    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }

    print qq{<div style="border:1px solid gray;margin:0.5em;background-color:yellow;text-align:center;">\n};
    print qq{<h1>$lex{'Record Deleted'}</h1></div>\n};

}
