#!/usr/bin/perl
#  Copyright 2001-2022 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Main' => 'Main',
	   'Export' => 'Export',
	   'View Student Pictures' => 'View Student Pictures',
	   'No Pictures Found' => 'No Pictures Found',
	   'Cannot open folder' => 'Cannot open folder',
	   'Page' => 'Page',
	   'View' => 'View',
	   'Large' => 'Large',
	   'Small' => 'Small',
	   'Pics/Page' => 'Pics/Page',
	   'QuickPage' => 'QuickPage',
	   'Error' => 'Error',

	   );

my $self = 'imageview.pl';

use CGI;
use DBI;

my $picsPerPage = 50;  # default value
my $tempimage = "temp$$.jpg";

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
my %arr= $q->Vars;
print $q->header( -charset, $charset );

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Select Viewing Directory.
if ($arr{size} eq $lex{Large} ){
    $viewdirurl = $picdirurl;
    $viewdir = $picdir;
} else {
    $arr{size} = $lex{Small}; # set for passed values
    $viewdirurl = $tndirurl;
    $viewdir = $tndir;
}

my $title = $lex{'View Student Pictures'};
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" type="text/css" href="$css">\n};
print qq{<style type="text/css">
body { background-color: #DC9;}
div.pic { float:left; padding:2px 6px; border:1px solid; border-color:#AAA #AAA #444 #444; 
 margin:2px; background-color: #EEE;
}
</style>\n};

print qq{$chartype\n</head><body>\n};
print qq{<div>[ <a href="$homepage">$lex{Main}</a> | \n};
print qq{<a href="$exppage">$lex{Export}</a> ]</div>\n};
print qq{<h1 style="margin-bottom:0;">$title</h1>\n};


# Read Files in picture folder
opendir (DH,"$viewdir") || die $lex{'Cannot open folder'}. " $viewdir $!\n";
my @files = grep !/^\./, readdir DH;
close DH;


if ( not @files ) { 
    print qq{<p>$lex{'No Pictures Found'}</p></body></html>\n};
    exit;
    
} else {
    @files = sort {$a <=> $b} @files;
    $filecount = scalar @files + 1;
#    $filecount++; # actual # of files
    if ($arr{ppp} > 0 ){ $picsPerPage = $arr{ppp};}
    $pagecount = int($filecount / $picsPerPage);
    if (($filecount / $picsPerPage) > $pagecount){ # if any remainder, increment count.
	$pagecount++;
    }
}

doNavigation();

if ( $arr{del} ){
    doDelete( $arr{del} );
}

if ( not $arr{page} ) { $arr{page} = 1;}
print qq{<h3>$lex{Page} $arr{page}</h3>\n};


# Calculate pictures to show
my $picend = $arr{page} * $picsPerPage - 1;
my $picstart = $picend - ($picsPerPage - 1);
#print qq{PPP: $picsPerPage  PG: $arr{page} ST: $picstart END: $picend<br>\n};

# Find Name
$sth = $dbh->prepare("select lastname, firstname from studentall where studnum = ?");


for( $picstart.. $picend ){
    my $file = $files[$_];
    if (not $file){ next;} # nothing to display;
    my ($studnum,$ext) = split /\./,$file;
    $sth->execute($studnum);
    if ($DBI::errstr){print $DBI::errstr; die $DBI::errstr;}
    my ($lastname,$firstname) = $sth->fetchrow;
    if (not $lastname){ $lastname = "&nbsp;";}
    #print qq{LN: $lastname FN: $firstname SN: $studnum<br>\n};

    print qq{<div class="pic"><img src="$viewdirurl/$file" alt="$file">\n};
    print qq{<br>$file<br>};
    print qq{[<a href="$self?del=$file&page=$arr{page}&ppp=$picsPerPage};
    print qq{&size=$arr{size}">Del</a>]};
    print qq{<br><b>$firstname $lastname</b></div>\n\n};

}

doNavigation();
print qq{</body></html>\n};



#-----------
sub doDelete { # Delete Picture files
#-----------
    my $filename = shift;
    my $result = system("rm -f $picdir/$filename");
    my $result = system("rm -f $tndir/$filename");

    if ($result){ 
	print qq{Could not delete file $filename because $?<br>\n};
    } else {
	print qq{$filename removed successfully.<br>\n};
	
	# If associated, removed picture tag in student record
	my ($studnum,$ext) = split /\./,$filename;
	if ($studnum =~ m/\d/){
	    my $sth = $dbh->prepare("update student set pic = NULL 
             where studnum = '$studnum'");
	    $sth->execute;
	    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
	    print qq{Student Record updated.<br>\n};
	}
    }

    exit;
}


#---------------
sub doNavigation {
#---------------

    print qq{<div style="clear:both;"></div>\n};
    print qq{<div style="float:left; margin-top: 1em;">};
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="submit" value="$lex{View}">\n};
    
    print qq{<select name="size">\n};
    if ( $arr{size} ){ print qq{<option>$arr{size}</option>};}
    foreach my $size ( 'Large','Small' ) {
	if ( $arr{size} ne $lex{$size} ) { print qq{<option>$lex{$size}</option>\n}; }
    }
    print qq{</select>\n};
    
    print qq{ $lex{'Pics/Page'} <input type="text" name="ppp" size="2" };
    print qq{value="$picsPerPage"> $lex{Page} <select name="page">\n};
    for (1..$pagecount){
	print qq{<option>$_</option>};
    }
    print qq{</select></form></div><div style="float:left; padding-left:1em;};
    print qq{margin-top:1em;">$lex{QuickPage} | \n};
    for (1..$pagecount){ 
	print qq{<a href="$self?ppp=$picsPerPage&page=$_&size=$arr{size}" };
	print qq{style="font-size:150%;">$_</a> | \n};
    }
    print qq{</div><div style="clear:both;"></div>\n};
}
