#!/usr/bin/perl
#  Copyright 2001-2022 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ( 'No Pictures Found' => 'No Pictures Found',
	    'Main' => 'Main',
	    'Export' => 'Export',
	    'Error' => 'Error',

	   );

use CGI;
use DBI;


my $tempimage = "temp$$.jpg";
my $self = 'missingpic.pl';

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

eval require "../../etc/image.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
my %arr= $q->Vars;
print $q->header( -charset, $charset );

my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $iddst) =
localtime(time);
$year = $year + 1900;
$mon++;
my $currdate = "$year-$mon-$mday";
$year = $year - 2; # go back 2 years to find withdrawn students for association in withdrawn
my $startdate = "$year-$mon-$mday";



my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


my $title = qq{Show Missing Student Pictures};
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" type="text/css" href="$css">\n};
print qq{<style type="text/css">body { background-color: #DC9;}
div.pic { float:left; height:$divheight px; width:$divwidth px; padding: 10px; 
 border: 1px solid; border-color:#AAA #AAA #444 #444; margin:3px; 
 background-color: #EEE;
}\n};
print qq{</style>\n};
print qq{$chartype\n</head><body>\n};

print qq{[ <a href="$homepage">$lex{Main}</a> | \n};
print qq{<a href="$exppage">$lex{Export}</a> ]\n};

print qq{<h1>$title</h1>\n};


# Read Files in bigpic folder
my $largemode = '1';
opendir (DH,"$picdir") || die "Cannot open $picdir directory!\n";
my @files = grep !/^\./, readdir DH;
close DH;

if ( not @files ) { # Try the Thumbnail folder instead.
    opendir (DH,"$tndir") || die "Cannot open $tndir directory!\n";
    @files = grep !/^\./, readdir DH;
    close DH;
    $largemode = 0;
}

if ( not @files ) { # Still no files... fail.
    print qq{<p>$lex{'No Pictures Found'}</p></body></html>\n};
    exit;
}

# Now find those files with and without numeric value. Numerics values
# are student numbers and those that are still text need to be
# associated. The files become numeric and the pic field gets set to 'Y'.
my (@doneFiles, @undoneFiles, @doneStudents); # undone still are text; done are studentnumber.jpg.
foreach my $file ( @files ) {
    my ($fn,$ext) = split /\./,$file;
    if ( $fn =~ m/\d+/ ) { # match one or more digits
	push @doneFiles, $file;
	push @doneStudents, $fn;
    } else {
    	push @undoneFiles, $file;
    }
}
    
# Verify all DONE files that we have the 'pic' field set.
my $sth = $dbh->prepare("select studid, pic from student where studnum = ?");
my $sth1 = $dbh->prepare("select studid, pic from studentwd where studnum = ?");

my $sth2 = $dbh->prepare("update student set pic = 'Y' where studid = ?");
my $sth3 = $dbh->prepare("update studentwd set pic = 'Y' where studid = ?");

my $verifyflag = 1;
foreach my $studnum ( @doneStudents ) { # matches @doneFiles
    $sth->execute($studnum);
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
    my ($studid, $pic) = $sth->fetchrow;
    
    if ( not $studid ) { # must be in withdrawn student table.
	$sth1->execute($studnum);
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
	my ($studid, $pic) = $sth1->fetchrow;
	if ( not $studid ) {
	    print qq{<div>Student not found for $studnum</div>\n};
	    next;
	} else { # we have a studid value
	    if ( not $pic ) { # we must set pic field in wd student table.
		$sth3->execute($studid);
		if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
		$verifyflag = 0;
		print qq{<div>Picture field set in withdrawn student table: $studnum</div>\n};
	    } # otherwise ok.
	}
    } else { #studid in the main student table.
	if ( not $pic ) { # we must set pic field in wd student table.
	    $sth2->execute($studid);
	    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
	    print qq{<div>Picture field set in student table: $studnum</div>\n};
	    $verifyflag = 0;
	} # otherwise ok.
    }
}
if ( $verifyflag ) { #
    print qq{<h3>All associated student pictures have a matched pic field. All OK</h3>\n};
}

# Get Grades
my @grades;
my $sth = $dbh->prepare("select distinct grade from student where grade is not NULL and grade != ''");
$sth->execute;
if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
while ( my $grade = $sth->fetchrow ) {
    push @grades, $grade;
}
@grades = sort {$a <=> $b} @grades;


my $sth = $dbh->prepare("select lastname, firstname, studnum, homeroom from student 
			where (pic is NULL or pic = '') and grade = ? 
			order by grade, lastname, firstname");

#print "Grades:@grades<br>\n";

my $count;
foreach my $grade ( @grades ) {
    my $first = 1;
   
    # Get Students Missing Pictures
    $sth->execute($grade);
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
    while ( my ( $lastname, $firstname, $studnum, $homeroom ) = $sth->fetchrow ){

	if ( $first ) {
	    # Start Table
	    print qq{<table cellspacing="0" cellpadding="3" border="1" };
	    print qq{style="float:left;margin:0.5em;">\n};
	    print qq{<caption style="font-weight:bold;font-size:120%;">Grade $grade</caption>\n};
	    print qq{<tr><th>Name</th><th>Homeroom</th></tr>\n};
	    $first = 0;
	}
	
	print qq{<tr><td><b>$lastname</b>, $firstname</td><td class="cn">$homeroom</td></tr>\n};
    }

    if ( not $first ) { # we have missing pics in this grade
	print qq{</table>\n};
    }

    $count++;
    if ( $count % 4 == 0 ) {
	print qq{<div style="clear:both;"></div>\n};
    }
    
    
}
    
print qq{</body></html>\n};


    
