#!/usr/bin/perl
#  Copyright 2001-2011 Methodius Dusyk; Updated by Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.


my %lex = ('Main' => 'Main',
	   'Record(s) Stored' => 'Record(s) Stored',
	   'Lock Number' => 'Lock Number',
	   'Combination' => 'Combination',
	   'Comment' => 'Comment',
	   'Save New Lock' => 'Save New Lock',
	   'Add Another' => 'Add Another',
	   'Error' => 'Error',
	   'Fees' => 'Fees',
	   'No Lock Number or Combination' => 'No Lock Number or Combination',
	   'Skipping' => 'Skipping',
	   'Duplicate Lock Number' => 'Duplicate Lock Number',
	   'Pool' => 'Pool',
	   'Saved' => 'Saved',
	   'Add' => 'Add',
	   'Lock' => 'Lock',

	   );

my $self = 'lockadd.pl';
my $maxentry = 8;

use CGI;
use DBI;
use Cwd;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}


my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Get current dir so know what CSS to display;
if (getcwd() =~ /tcgi/){ # we are in tcgi
    $css = $tchcss;
    $homepage = $tchpage;
}

# Show page Header
print "$doctype\n<html><head><title>$lex{Add} $lex{Locks}</title>\n";
print "<link rel=\"stylesheet\" href=\"$css\" type=\"text/css\">\n";
print "$chartype\n</head><body>[ <a href=\"$homepage\">". $lex{Main}. "</a> |\n";
print "<a href=\"$feespage\">". $lex{Fees}. "</a> ]\n";

print "<form action=\"$self\" method=\"post\" style=\"display:inline;\">\n";
print "<input type=\"submit\" value=\"". $lex{'Add Locks'}. "\">\n";
print "<input type=\"text\" name=\"count\" size=\"4\">\n";
print "</form>\n";

print "<h1>$lex{Add} $lex{Locks}</h1>\n";

if ( $arr{writeflag} ) { # Write values and exit;
    delete $arr{writeflag};
    updateRecord();
}

if ( $arr{count} ) {
    $maxentry = $arr{count}; # passed a larger number of records to add
    delete $arr{count};
}

# Setup the form and start of table.
print "<form action=\"$self\" method=\"post\">\n";
print "<input type=\"hidden\" name=\"writeflag\" value=\"1\">\n";
print "<input type=\"hidden\" name=\"maxentry\" value=\"$maxentry\">\n";
print "<table cellpadding=\"3\" border=\"0\" cellspacing=\"0\">\n";

print "<tr><th>". $lex{'Lock Number'}. "</th><th>". $lex{Combination};
print "</th><th>". $lex{Pool}. "</th><th>". $lex{Comment}. "</th></tr>\n";

for my $i ( 1 .. $maxentry ) {

    print "<tr><td>";
    print "<input type=\"text\" name=\"lock_num$i\" size=\"12\" maxlength=\"12\">\n";
    print "</td><td>";

    print "<input type=\"text\" name=\"combination$i\" size=\"12\" maxlength=\"12\">\n";
    print "</td><td>";

    print "<input type=\"text\" name=\"pool$i\" size=\"12\" maxlength=\"12\">\n";
    print "</td><td>";

    print "<input type=\"text\" name=\"comment$i\" size=\"50\">\n";
    print "</td></tr>\n";

}


# Print Submit Row
print "<tr><td colspan=\"4\" align=\"center\">";
print "<input type=\"submit\" value=\"". $lex{'Save New Lock'}. "\"></td></tr>\n";

print "</table>\n</form></body></html>\n";



#---------------
sub updateRecord {
#---------------

    #foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }

    my $maxentry = $arr{maxentry};
    delete $arr{maxentry};

    my $sth1 = $dbh->prepare("select count(*) from lok_lock where lock_num = ?");

    foreach my $i ( 1 .. $maxentry ) {
	my $lock_num = $arr{"lock_num$i"};
	my $combination = $arr{"combination$i"};
	my $pool = $arr{"pool$i"};
	my $comment = $arr{"comment$i"};
	if ( not $comment ) { $comment = $sql{default}; }

	if ( not $lock_num or not $combination ) { 
	    print "<p><b>$i.</b> ". $lex{'No Lock Number or Combination'};
	    print q{ - }. $lex{Skipping}. "</p>\n";
	    next; 
	}

	$sth1->execute( $lock_num );
	if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
	if ( my $count = $sth1->fetchrow ) {
	    print "<p><b>$i.</b> ". $lex{'Duplicate Lock Number'};
	    print q{ - }. $lex{Skipping}. "</p>\n";
	    next;
	}

	my $sth = $dbh->prepare("insert into lok_lock (lock_num, combination, pool, comment )
         values ( ?, ?, ?, ?)");
	$sth->execute( $lock_num, $combination, $pool, $comment );
	if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }

	print "<p><b>$i.</b> $lock_num ". $lex{'Saved'};

    }

    print "<h3>$lex{'Record(s) Stored'}</h3>\n";
    print "<p>[ <a href=\"$self\">$lex{'Add Another'} $lex{Lock}</a> | ";
    print "<a href=\"$feespage\">$lex{Fees}</a> ]</p></body></html>\n";

    exit;

} # End of updateRecord
