#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

#  Description: copy values from the student medical field into new student_medical table

my %lex = ('Main' => 'Main',
	   'Medical' => 'Medical',
	   'Copy' => 'Copy',
	   'Records' => 'Records',
	   'Copy Record(s)' => 'Copy Record(s)',
	   'Category' => 'Category',
	   'New' => 'New',
	   'Undefined' => 'Undefined',
	   'Record(s) Stored' => 'Record(s) Stored',
	   'Contact' => 'Contact',
	   'Error' => 'Error',
	   'Results' => 'Results',
	   'Record Exists' => 'Record Exists',
	   'Skipping' => 'Skipping',
	   'Missing' => 'Missing',
	   'or' => 'or',
	   'Not Found' => 'Not Found',

	   );

my $self = 'medcopy.pl';

use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Print Page Header
print qq{$doctype\n<html><head><title>$lex{Copy} $lex{Medical} $lex{Records}</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};
print qq{$chartype\n</head><body>\n};

print qq{[ <a href="$homepage">$lex{Main}</a> ]\n};

print qq{<h1>$lex{Copy} $lex{Medical} $lex{Records}</h1>\n};


if ( not $arr{page} ) {
    showStartPage();
} else {
    delete $arr{page};
    writeRecords();
}


#----------------
sub showStartPage {
#----------------

    # Get Existing Categories
    my @category = ();
    my $sth = $dbh->prepare("select distinct category from student_medical order by category");
    $sth->execute;
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
    my $ref = $sth->fetchall_arrayref;
    foreach my $val ( @$ref ) {
	if ( $val->[0] ) { push @category, $val->[0]; }
    }

    # Start the Form
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="3">\n};
    print qq{<p><input type="submit" value="$lex{'Copy Record(s)'} "></p>\n};


    my $sth = $dbh->prepare("select lastname, firstname, studnum, medical from student
     where medical != '' order by lastname, firstname");
    $sth->execute;
    
    while ( my ( $lastname, $firstname, $studnum, $medical ) = $sth->fetchrow ) {

	print qq{<table cellpadding="3" cellspacing="0" border="1" style="float:left;margin:0.5em;">\n};
	print qq{<caption style="font-size:150%;font-weight:bold;">$firstname $lastname</caption>\n};

	# Show Category
	print qq{<tr><td><select name="C:$studnum"><option>$lex{Undefined}</option>\n};
	foreach my $cat ( @category ) {
	    print qq{<option>$cat</option>};
	}
	print qq{</select>\n};

	# New Category
	print qq{ $lex{or} $lex{New} $lex{Category} };
	print qq{<input type="text" name="N:$studnum" size="20"><br>\n};

	# Get Description
	print qq{<textarea rows="4" cols="80" name="D:$studnum">$medical</textarea></td></tr>\n};

	print qq{</table><p></p>\n};

    } # end of student Loop

    print qq{<br clear="left"><input type="submit" value="$lex{'Copy Record(s)'} ">\n};
    print qq{</form></body></html>\n};

    exit;

}




#---------------
sub writeRecords {
#---------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    print qq{<table cellpadding="3" cellspacing="0" border="1">\n};
    print qq{<tr><th>$lex{Results}</th></tr>\n};

    # SQL Setup
    my $sth = $dbh->prepare("select count(*) from student_medical where studnum = ? and category = ?");
    my $sth1 = $dbh->prepare("select lastname, firstname from studentall where studnum = ?");
    my $sth2 = $dbh->prepare("insert into student_medical ( studnum, category, description ) values ( ?, ?, ? )");

    foreach my $key ( sort keys %arr ) {

	my ( $val, $studnum ) = split(/:/,$key);

	if ( $val eq 'D' or $val eq 'N' ) { next; }

	my $dkey = "D:$studnum";
	my $nkey = "N:$studnum";
	my $ckey = "C:$studnum";


	# Get Student Name
	$sth1->execute( $studnum );
	if ( $DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	my ( $lastname, $firstname ) = $sth1->fetchrow;
	if ( not $lastname ) { 
	    $lastname = qq{<span style="color:red;">$lex{'Not Found'}</span>}; 
	}       

	# Set Category, Description
	my ($category, $description);
	if ( $arr{$nkey} ) { $arr{$ckey} = $arr{$nkey}; } # new cat replaces cat.
	if ( not $arr{$dkey} ) { next; } # no description, skip to next.

	$category = $arr{$ckey};
	$description = $arr{$dkey};
		
	if ( not $category ) { # an error
	    print qq{<tr><td>$lex{Missing} $lex{Category}: $firstname $lastname : $lex{Skipping}</td></tr>\n};
	    next;
	}

	# Check for duplicates, this student, this category
	$sth->execute( $studnum, $category );
	if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
	my $catcount = $sth->fetchrow;
	if ( $catcount ) {
	    print qq{<tr><td>$lex{'Record Exists'}: $firstname $lastname : $category  $lex{Skipping}</td></tr>\n};
	    next;
	}

	# print line for this record.
	print qq{<tr><td><b>$lastname</b>, $firstname ($studnum) - $category</td></tr>\n};

	# Insert the record
	$sth2->execute( $studnum, $category, $description );
	if ( $DBI::errstr ){ print $DBI::errstr; last; }
	
   } # Next Student

    if ( not $DBI::errstr ) {
	print qq{</table>\n};
	print qq{<h3>$lex{'Record(s) Stored'}</h3></p>\n};
    } else {
	print qq{</table>\n<p>$lex{Error}. $lex{Contact}:\n};
	print qq{ $adminname <a href="mailto:$adminemail">$adminemail</a>\n};
	print qq{$lex{Error}: $DBI::errstr</p>\n};
    }

    print qq{<p>[ <a href="$homepage">$lex{Main}</a> ]\n};
    print qq{</p></body></html>\n};

    exit;

} # End of writeRecords
