#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson
#  This file is part of Open Administration for Schools

# Check for missing MSS Id and PSN


use DBI;
use CGI;


my $self = 'mssCheckDemog.pl';

my %lex = ( 'Main' => 'Main',
	    'Error' => 'Error',
	    'Grade' => 'Grade',
	    'Homeroom' => 'Homeroom',
	    'Values' => 'Values',

	    );


eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

my $q = CGI->new;
my %arr = $q->Vars;
print $q->header( -charset, $charset ); 

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


my @tim = localtime(time);
my $year = $tim[5] + 1900;
$tim[4]++;
for (0..4){if (length($tim[$_]) == 1){ $tim[$_] = '0'.$tim[$_];}}
my $currdate = "$year-$tim[4]-$tim[3]";
my $currtime = "$tim[2]:$tim[1]:$tim[0]";


my $title = "Show Missing MSS Id or Provincial Student Number";
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">$chartype\n};
print qq{</head><body>[ <a href="$homepage">Main</a> |\n};
print qq{<a href="$exppage">Export</a> ]\n};
print qq{<h1>$title</h1>\n};


showMissing();



#---------------
sub showMissing {
#---------------

    #foreach my $key ( keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    # check for any students without mssid and/or prov num
    my $sth = $dbh->prepare("select * from student
       where (mssid is NULL or mssid = 0) or (provnum is null or provnum = '') ");
    $sth->execute;
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr;}
    my $first = 1;
    
    while ( $ref = $sth->fetchrow_hashref ) {
	my %r = %$ref;
	if ( $first ) { # start table
	    print qq{<table cellpadding="3" cellspacing="0" border="1" style="float:left;">\n};
	    print qq{<caption style="font-weight:bold;font-size:120%;">};
	    print qq{Missing MSSID or Provincial Number</caption>\n};
	    print qq{<tr><th>Name</th><th>Grade</th><th>Prov Num</th><th>MSSID</th><th>Edit in<br>New Tab};
	    print qq{</th></tr>\n};
	    $first = 0;
	}

	print qq{<tr><td><b>$r{lastname}</b>, $r{firstname} ($r{studnum})</td><td>$r{grade}</td>\n};
	print qq{<td>$r{provnum}</td><td>$r{mssid}</td>\n};

	print qq{<td class="cn">};
	print qq{<form action="/cgi-bin/studed.pl" method="post" target="_blank" style="display:inline;">};
	print qq{<input type="hidden" name="id" value="$r{studid}">};
	print qq{<input type="submit" name="submit" value="Edit"></form></td></tr>\n};
	
    }
    
    if ( not $first ) {
	print qq{</table>\n};
    } else {
	print qq{<h2>No Students Missing MSS Id or PSN</h2>\n};
    }

    print qq{</body><html>\n};
    exit;
} # end of showMissing;



    
