#!/usr/bin/perl
#  Copyright 2001-2020 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('View' => 'View',
	   'Staff' => 'Staff',
	   'Absences' => 'Absences',
	   'Main' => 'Main',
	   'Eoy' => 'Eoy',
	   'No Records Found' => 'No Records Found',
	   'Error' => 'Error',
	   'Edit' => 'Edit',
	   'Delete' => 'Delete',

	   );


use DBI;
use CGI;
use Cwd;

my $self = 'mssStudentView.pl';


eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);



# Print Page Header
my $title = qq{$View MSS Student Table};
print qq{$doctype\n<html><head><title>$title</title>
 <link rel="stylesheet" href="$css" type="text/css">
 </head>\n};

print qq{<body>[ <a href="$homepage">$lex{Main}</a> |\n};
print qq{<a href="$exppage">Export</a> ]\n};


my $sth = $dbh->prepare("show columns from mss_student");
$sth->execute;
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
while (my @cols = $sth->fetchrow ) {
    if ( $cols[0] eq 'id' or $cols[0] eq 'comment' ) { next; }
    push @fields, $cols[0];
}


$sth = $dbh->prepare("select * from mss_student order by id");
$sth->execute;
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

print qq{<h1>$title</h1>\n};


my $first = 1;
print qq{<table border="1" cellpadding="3" cellspacing="0">\n};

print qq{<tr>};
foreach my $fld (@fields ) {
    print qq{<th>$fld</th>\n};
}
print qq{</tr>\n};

while ( my $ref = $sth->fetchrow_hashref ) {
    my %r = %$ref;

    $first = 0;
    print qq{<tr>\n};
    foreach my $field ( @fields ) {
	print qq{<td>$r{$field}</td>};
    }

    print qq{</tr>\n};
}


if ($first ) {
    print qq{<p>$lex{'No Records Found'}</p>\n};
    print qq{</body></html>\n};
    exit;
    
} else { # close table
    print qq{</table>\n};
}


print qq{<p>[ <a href="$homepage">$lex{Main}</a> |\n};
print qq{<a href="$exportpage">Export</a> ]</p>\n};

print qq{</body></html>\n};
