#! /usr/bin/perl
#  Copyright 2001-2016 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my $templatepath = '../template/';

my %lex = ('Main' => 'Main',
	   'Information' => 'Information',
	   'Set' => 'Set',
	   'Error' => 'Error',
	   'Save' => 'Save',
	   'Record(s)' => 'Record(s)',
	   'Updated' => 'Updated',
	   'Edit' => 'Edit',
	   'Nominal Roll' => 'Nominal Roll',
	   'Repeat' => 'Repeat',

	   );

my $self = 'confnomroll.pl';

my $filename = 'first_nation';

use DBI;
use CGI;

# Read config variables
eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

eval require "../../lib/liblatex.pl";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

my $q = new CGI;
my %arr = $q->Vars;
print $q->header( -charset, $charset );


# Page Header
my $title = "$lex{Set} $lex{'Nominal Roll'} $lex{Information}";
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};
print qq{$chartype\n</head><body>\n};


print qq{<p>[ <a href="$homepage">$lex{Main}</a> ]</p>\n};
print qq{<h1>$title</h1>\n};


# Setup Database access
my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);



if ( not $arr{page} ) {
    showStartPage();

} else {
    delete $arr{page};
    writeValues();
}



#----------------
sub showStartPage {
#----------------

    # Start Form
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};


    # Load Existing Configuration Data.
    my $sth = $dbh->prepare("select * from conf_system 
      where filename = ? order by sectionname, sequenceval"); 
    $sth->execute( $filename );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

    # Print Table Heading.
    print qq{<table cellpadding="3" cellspacing="0" border="0">\n};

    print qq{<tr><td class="la" colspan="3">\n};
    print qq{<input type="submit" value="$lex{Save}"></td></tr>\n};

    my ($currsection, $prevsection);

    while ( my $ref = $sth->fetchrow_hashref ) {

	$prevsection = $currsection;
	$currsection = $ref->{sectionname};
	if ( $currsection ne $prevsection ) {
	    print qq{<tr><td colspan="3"><hr></td></tr>\n};
	}


	# put value into namespace
	my $datavalue = $ref->{datavalue};
	eval $datavalue;
	if ( $@ ) {
	    print $lex{Error}. " $@<br>\n";
	    die $lex{Error}. " $@\n";
	}
	my $dataname = $ref->{dataname};

	print qq{<tr><td class="bra">$dataname</td>};
	print qq{<td class="la">};
	if ( $dataname eq 'tuitionagreement' ) {
	    my $val = $$dataname;
	    my %tui = ('1' => 'Yes, signed Tuition Agreement in place',
		       '2' => 'No agreement in place',
		       '3' => 'Yes, other agreement in place'
		);
	    print qq{<select name="$ref->{id}"><option value="$$dataname">$tui{$val}</option>\n};
	    foreach my $key ( sort keys %tui ) {
		print qq{<option value="$key">$tui{$key}</option>};
	    }
	    print qq{<option></option></select></td><td class="la">$ref->{description}</td></tr>\n};

	} else {
	    print qq{<input type="text" size="40" name="$ref->{id}" value="$$dataname">\n};
	    print qq{</td><td class="la">$ref->{description}</td></tr>\n};
	}

    }

    print qq{<tr><td colspan="3"><hr></td></tr>\n};
    print qq{<tr><td class="la" colspan="3">\n};
    print qq{<input type="submit" value="$lex{Save}"></td></tr>\n};

    print qq{</table></form>\n};
    print qq{</body></html>\n};

    exit;

}



#--------------
sub writeValues {
#--------------

    #foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }

    use Data::Dumper;
    $Data::Dumper::Purity = 1;
    $Data::Dumper::Indent = 0;

    my $updatefile = $filename; # defined at top of script.
    # needed to write the file level update.

    foreach my $id ( keys %arr ) {

	# Get the original record
	my $sth = $dbh->prepare("select * from conf_system where id = ?");
	$sth->execute( $id );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	my $ref = $sth->fetchrow_hashref;

	my $type = $ref->{datatype};
	my $dataname = $ref->{dataname};
	my $value_ref = [ ];
	my $name_ref = [ ];

	my $sth = $dbh->prepare("update conf_system set datavalue = ? where id = ?");

	# only Scalar Value
	push @$name_ref, $dataname;
	push @$value_ref, $arr{$id};
    
	my $d = Data::Dumper->new( $value_ref, $name_ref );
	my $datavalue = $d->Dump;

	# print "Datavalue: $datavalue<br>\n";
	$sth->execute( $datavalue, $id );
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

    }

    if ( not $DBI::errstr  ) {
	print "<h3>$lex{'Record(s)'} $lex{Updated}</h3>\n";

    } else {
	print "<h3>$lex{Error}:$DBI::errstr;</h3>\n";
    }


    print qq{<form action="$self" method="post">\n};
    print qq{<input type="submit" value="$lex{Repeat} $lex{Edit} "></form>\n};

    print qq{<p style="font-size:130%;">[ <a href="$homepage">$lex{Main}</a> ]</p>\n};
    print qq{</body></html>\n};

    exit;

} # End of Update
