#!/usr/bin/perl
#  Copyright 2001-2012 Leslie Richardson
#  This file is part of Open Admin for Schools.
#  Display nominal roll choices for insert, passed fieldid

use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header; #( -charset, $charset );
my %arr = $q->Vars;

my $fieldid = $arr{fieldid};

#foreach my $key ( sort keys %arr ) {
#    print "<option>$key - $arr{$key}</option>\n";
#}

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Select Data
my $sth = $dbh->prepare("select formtype, defaultvalue from meta where tableid = 'student_inac' and fieldid = ?");
$sth->execute( $fieldid );
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

my ($formtype, $default) = $sth->fetchrow;

if ( $formtype eq 'text' ) {
    print qq{\n<input type="text" name="defaultfill" value="$default">};

} elsif ( $formtype eq 'select' ) {
    my @vals = split(/\s+/, $default);
    print qq{<select name="defaultfill"><option></option>\n};
    foreach my $val ( @vals ) {
	$val =~ s/\_/ /g; # strip underscores
	print qq{<option>$val</option>};
    }
    print "</select>\n";

} else {
    my %vals = split(/\s+/, $default);

    print qq{<select name="defaultfill"><option></option>\n};
    foreach my $key ( keys %vals ) {
	$vals{$key} =~ s/\_/ /g; # strip underscores
	print qq{<option value="$key">$vals{$key}</option>};
    }
}
