#!/usr/bin/perl
#  Copyright 2001-2010 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Copy Staff Back' => 'Copy Staff Back',
	   'Main' => 'Main',
	   'Eoy' => 'Eoy',
	   'Prereg' => 'Prereg',
	   'Staff' => 'Staff',
	   'Not Found' => 'Not Found',
	   'Your prereg staff table has been copied back to the staff table' =>
	     'Your prereg staff table has been copied back to the staff table',
	   'There was an error copying your staff table' => 
	     'There was an error copying your staff table',
	   'Contact' => 'Contact',
	   'Error' => 'Error',

	   );


use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Print Page Header.
print "$doctype\n<html><head><title>". $lex{'Copy Staff Back'}. "</title>";
print "<link rel=\"stylesheet\" href=\"$css\" type=\"text/css\">
 $chartype\n</head><body>\n";

print "[ <a href=\"$homepage\">". $lex{Main}. "</a> | \n";
print "<a href=\"$eoypage\">". $lex{Eoy}. "</a>]\n";


# Count staff in prereg_staff table;
my $sth = $dbh->prepare("select count(*) from prereg_staff"); 
$sth->execute;
if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
my $count = $sth->fetchrow;

if ( $count > 0 ) { 
    # Delete all records in teacher/staff table.
    $sth2 = $dbh->do("delete from staff");
    $sth2 = $dbh->do("delete from staff_multi");
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }

} else {
    print "<h1>". $lex{Prereg}. q{ }. $lex{Staff}. $lex{'Not Found'}. "</h1>\n";
    print "</body></html>\n";
    exit;
}

# Now copy the tables
my $rows = $dbh->do("insert into staff select * from prereg_staff");
my $rows = $dbh->do("insert into staff_multi select * from prereg_staff_multi");

if ( not $DBI::errstr ) {
    print "<h3>". $lex{'Your prereg staff has been copied back to staff'}. ".</h3>\n";
} else {
    print "<h3>". $lex{Error}. "<br>\n";
    print $lex{Contact}. " $adminname at <a href=\"mailto:$adminemail\">$adminemail</a>\n";
    print $DBI::errstr "</h3>\n";
}

print "<p>[ <a href=\"$eoypage\">". $lex{Eoy}. "</a> ]\n";
print "</p></body></html>\n";
