#! /usr/bin/perl
#  Copyright 2001-2011 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

# NOTE: This file is just an older version of customclasslist. Change
# existing customclasslist to print this table and remove this
# file. Perhaps allow passed table value?  TODO.

my %lex = ('Empty Class List' => 'Empty Class List',
	   'Main' => 'Main',
	   'Eoy' => 'Eoy',
	   'Rm' => 'Rm',
	   'Classlist' => 'Classlist',
	   'Students' => 'Students',
	   'View/Download' => 'View/Download',
	   'Error' => 'Error',
	   'View Log File' => 'View Log File',
	   'No Record(s) Found' => 'No Record(s) Found',

	   );

use DBI;
use CGI;

my $maxlines = 26;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my ( $sec, $min, $hour, $mday, $mon, $year, $wday, $yday, 
 $iddst) = localtime(time);
$year = $year + 1900;
$mon++; $wday++;
my $currdate = "$dow[$wday], $month[$mon] $mday, $year";

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;


print "$doctype\n<html><head><title>$lex{'Empty Class List'}</title>
<link rel=\"stylesheet\" href=\"$css\" type=\"text/css\">
$chartype\n</head><body>\n";

print "[ <a href=\"$homepage\">". $lex{Main}. "</a> | \n";
print "<a href=\"$eoypage\">". $lex{Eoy}. "</a>]\n";

print "<center><h1>". $lex{'Empty Class List'}. "</h1>\n";


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


my $shortname = "eclasslist$$";
my $filename = "$shortname.tex";
my $logfile = "pdflog$$.txt";

open(TEX,">$filename") || die "Can't open tex file";

print TEX "\\documentclass[12pt,letterpaper]{article}
\\pagestyle{empty}
\\setlength{\\textwidth}{7.8in}
\\setlength{\\textheight}{10.6in}
\\setlength{\\hoffset}{-0.8in}
\\setlength{\\voffset}{-1.4in}
\\addtolength{\\evensidemargin}{-1in}
\\addtolength{\\oddsidemargin}{-1in}
\\setlength{\\tabcolsep}{3.5pt}\n";

print TEX "\\begin{document}\n";

my $sth = $dbh->prepare("select * from preset order by homeroom,lastname,firstname");
$sth->execute;
my $rows = $sth->rows;

if ( not $rows ) {
    print "<h3>". $lex{'No Record(s) Found'}. "</h3>\n";
    print "</body></html>\n";
    exit;
}


$curroom = -1;

for ( my $i=1; $i<=$rows; $i++ ) {
   
    $oldroom = $curroom;
    my @arr = $sth->fetchrow;

    $curroom = $arr[6];

    if ( $oldroom eq $curroom ) { # We have another record for same page
	$linecount++;
	$studcount++;
	if ( $linecount > $maxlines ) { # We'll print a new page header here
	    # New Page Header
	    $linecount = 0;
	    print TEX "\\end{tabular}\\\\ \n \\newpage\n";
	    print TEX "\\begin{tabular}{|p{48mm}|p{16mm}|p{6mm}|p{6mm}|p{6mm}|p{6mm}|";
	    print TEX "p{6mm}|p{6mm}|p{6mm}|p{6mm}|p{6mm}|p{6mm}|p{6mm}|p{6mm}|p{6mm}|";
	    print TEX "p{6mm}|p{6mm}|p{6mm}| }\n";
	    print TEX "{\\small $schoolname $lex{Classlist} } & & & & & & & & & & & & & ";
	    print TEX "& & & & \\\\";
	    print TEX "{\\small $currdate} \\bigskip & & & & & & & & & & & & & & & & & \\\\ \n";
	    print TEX "{\\Large $teacher[1] $teacher[3] $teacher[2]} & $lex{Rm}: $curroom ";
	    print TEX "& & & & & & & & & & & & & & & & \\\\\n\\hline\n";

	} # End of New Page Header due to too large class

	print TEX "\\vspace{0.4pt}$arr[1], $arr[2] $arr[3]\\vspace{0.8pt} &";
	print TEX " \\vspace{0.4pt}$arr[4]-$arr[7]\\vspace{0.8pt} ";
	print TEX "& &  & & & & & & & & & & & & & & \\\\ \n\\hline\n";

    } else {  # We are starting a new page

	# Get Teacher Name for the room.
	my $sth1 = $dbh->prepare("select * from staff as s, staff_multi as sm
              where s.userid = sm.userid and field_name = 'homeroom' and field_value = ?");
	$sth1->execute( $curroom );
	if ($DBI::errstr) { print "Teacher Error: $DBI::errstr"; die $DBI::errstr; }
	my @teacher = $sth1->fetchrow;
  
	if ($i != 1) {
	    $studcount++;
	    print TEX "\\vspace{0.5pt} $lex{Students}: $studcount\\vspace{1pt}";
	    print TEX " & & & & & & & & & & & & & & & & &  \\\\ \\hline \\end{tabular}\n";
	    print TEX "\\newpage \n";
	}

	$linecount = 0;
	$studcount = 0;
	print TEX "\\begin{tabular}{|p{50mm}|p{16mm}|p{6mm}|p{6mm}|p{6mm}|p{6mm}|";
	print TEX "p{6mm}|p{6mm}|p{6mm}|p{6mm}|p{6mm}|p{6mm}|p{6mm}| p{6mm}|p{6mm}|";
	print TEX "p{6mm}|p{6mm}|p{6mm}|}\n";
  
	print TEX "{\\small $schoolname $lex{Classlist} } & & & & & & & & & & & & & & & & &\\\\\n";
	print TEX "{\\small $currdate} \\bigskip & & & & & & & & & & & & & & & & & \\\\ \n";
	print TEX "{\\Large $teacher[1] $teacher[3] $teacher[2]} & $lex{Rm}: $curroom ";
	print TEX "& & & & & & & & & & & & & & & & \\\\ \n\n\\hline\n\n";
	print TEX "\\vspace{0.4pt}$arr[1], $arr[2] $arr[3]\\vspace{0.8pt} & ";
	print TEX "\\vspace{0.4pt}$arr[4]-$arr[7]\\vspace{0.8pt} ";
	print TEX "&  &  & & & & & & & & & & & & & & \\\\ \n \\hline\n";

    }

}  # End of For loop

$studcount++;
if ( $rows ) { # end the current table
    print TEX "\\vspace{0.5pt} $lex{Students}: $studcount\\vspace{1pt} ";
    print TEX "& & & & & & & & & & & & & & & & & \\\\ \n \\hline\n\\end{tabular}\\\\ \n";
}
print TEX "\\end{document}\n";
close TEX;

system("$pdflatex $filename >$logfile");
system("mv $shortname.pdf $downloaddir");
system("rm -f $shortname.*");

print "<h1><a href=\"$webdownloaddir/$shortname.pdf\">\n";
print $lex{'View/Download'}. q{ }. $lex{'Empty Class List'}. "</a></h1>\n";
print "<p>[ <a href=\"$eoypage\">". $lex{Eoy}. "</a> | \n";
print "<a href=\"$webdownloaddir/$logfile\">". $lex{'View Log File'}. "</a> ]\n";
print "</center></body></html>\n";
