#! /usr/bin/perl
#  Copyright 2001-2010 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Pre-Registration' => 'Pre-Registration',
	   'Student' => 'Student',
	   'Delete' => 'Delete',
	   'Deleted' => 'Deleted',
	   'Eoy' => 'Eoy',
	   'Main' => 'Main',
	   'Are you sure' => 'Are you sure',
	   'This will remove all student pre-registration entries.' => 
	     'This will remove all student pre-registration entries.',
	   'Make sure that all of your pre-registered students are present in the student table.' =>
	     'Make sure that all of your pre-registered students are present in the student table.',
	   'Contact' => 'Contact',
	   'Error' => 'Error',
	   'You must see them in Edit Student' => 'You must see them in Edit Student',
	   );

my $self = 'preregempty.pl';

use CGI;
use DBI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);



print "$doctype\n<html><head><title>$lex{Delete} $lex{Pre-Registration}";
print "</title>\n<link rel=\"stylesheet\" href=\"$css\" type=\"text/css\">\n";
print "<style type=\"text/css\">body { margin: 2em;}</style>
$chartype\n</head><body>\n";

print "[ <a href=\"$homepage\">". $lex{Main}. "</a> | \n";
print "<a href=\"$eoypage\">". $lex{Eoy}. "</a> ]\n";

print "<h1>$lex{Delete} $lex{Student} $lex{Pre-Registration}</h1>\n";

if ( $arr{emptyflag} ) {
    delete $arr{emptyflag};
    deleteRecords();
}

print "<center><h1>$lex{'Are you sure'}?</h1>\n";

print "<p>". $lex{'This will remove all student pre-registration entries.'}. "<br>\n";
print $lex{'Make sure that all of your pre-registered students are present in the student table.'}. ".\n";
print "$lex{'You must see them in Edit Student'}</p>\n";

print "<form action=\"$self\" method=\"post\">\n";
print "<input type=\"hidden\" name=\"emptyflag\" value=\"1\">\n";
print "<input type=\"submit\" value=\"$lex{Delete} $lex{Student} $lex{'Pre-Registration'}";
print "\"></form></p>\n";

print "</body></html>\n";



#---------------
sub deleteRecords {
#---------------

    # Empty out date table.
    $sth = $dbh->prepare("delete from prereg");
    $sth->execute;


    if (not $DBI::errstr){
	print "<center><h1>";
	print "$lex{Student} $lex{'Pre-Registration'} $lex{Deleted}</h1>\n";
    } else {
	print "<h3>$lex{Delete} $lex{Error}<br>\n";
	print $lex{Contact}. " $adminname at <a href=\"mailto:$adminemail\">$adminemail</a>\n";
	print $lex{Error}. ": $DBI::errstr</h3>\n"; 

    }

    print "[ <a href=\"$eoypage\">". $lex{Eoy}. "</a> ]</body></html>\n";

    exit;

}
