#!/usr/bin/perl
#  Copyright 2001-2009 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Promotion List' => 'Promotion List',
	   'Eoy' => 'Eoy',
	   'Main' => 'Main',
	   'Homeroom' => 'Homeroom',
	   'Grade' => 'Grade',
	   'Student' => 'Student',
	   'Promote' => 'Promote',
	   'Promotion update is now stored in the temporary student table' =>
	     'Promotion update is now stored in the temporary student table',
	   'There was an error storing your data' => 'There was an error storing your data',
	   'Contact' => 'Contact',
	   'Error' => 'Error',
	   
	   );


my $self = 'promote.pl';

use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


print "$doctype\n<html><head><title>". $lex{'Promotion List'}. "</title>
<link rel=\"stylesheet\" href=\"$css\" type=\"text/css\">\n";
print "$chartype\n</head><body>\n";

print "[ <a href=\"$homepage\">". $lex{Main}. "</a> |\n";
print "<a href=\"$eoypage\">". $lex{Eoy}. "</a> ]\n";

if ( $arr{writeflag} ) {
    delete $arr{writeflag};
    writeRecords();
}


# Empty the preset table.
$sth1 = $dbh->prepare("delete from preset");
$sth1->execute;
if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

# Get student information.
my $sth = $dbh->prepare("select studid, lastname, firstname, homeroom, grade 
 from student order by homeroom,lastname");
$sth->execute;
if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
$rows = $sth->rows;

# Page Header
print "<h1>". $lex{'Promotion List'}. "</h1>\n";
print "<form action=\"$self\" method=\"post\">\n";
print "<input type=\"hidden\" name=\"writeflag\" value=\"1\">\n";


my $first = 1;
my $curroom = -1;


while (my ($studid, $lastname, $firstname, $homeroom, $grade ) = $sth->fetchrow) {

    $oldroom = $curroom;
    $curroom = $homeroom;

    if ( $curroom ne $oldroom ) { # we have a new room, start new table
	if (not $first) { print "</table><p>&nbsp;</p>\n"; } else { $first = 0; }

	print "<table border=\"1\" cellpadding=\"3\" cellspacing=\"0\">\n";
	print "<caption><b>". $lex{Homeroom}. "</b> $curroom&nbsp;&nbsp;<b>". $lex{Grade}. "</b> $grade</b></caption>\n";
	print "<tr><th>". $lex{Student}. "</th><th>". $lex{Promote}. "</th></tr>\n";

    }

    # print the record
    print "<tr><td><b>$lastname</b>, $firstname</td>\n";
    print "<td><input type=\"checkbox\" name=\"$studid\" value=\"1\" checked></td></tr>\n";  

} 


print "<tr><td colspan=\"2\" align=\"center\">\n";
print "<input type=\"submit\" value=\"". $lex{Promote}. "\">\n";
print "</table></form></body></html>\n";


# --------------
sub writeRecords {
# --------------

    #foreach my $key (keys %arr ) { print "Name: $key  Key: $arr{$key}<br>\n"; }

    foreach my $key (keys %arr ) { 

	$sth = $dbh->prepare("select lastname, firstname, initial, studnum, grade, homeroom
          from student where studid = ?");
	$sth->execute( $key );
	if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
	my ($lastname, $firstname, $initial, $studnum, $grade, $homeroom) = $sth->fetchrow;

	# In Case of Miss Steaks....uncomment this and comment up below
	#  Then re-run the scripts and copy the grades back to normal
	#   and do it right....
	#if ($grade == 1){ 
	#  $grade = "K";
	#} else {
	#  $grade--;
	#}

	if ($grade eq "K" or $grade eq "k") {
	    $grade = 1;
	} elsif ($grade eq "PK" or $grade eq "pk") {
	    $grade = "K";
	} else {
	    $grade++;
	}

	$lastname = $dbh->quote($lastname);
	$firstname = $dbh->quote($firstname);
	$initial = $dbh->quote( $initial );
	$homeroom = $dbh->quote( $homeroom );

	$sth2 = $dbh->prepare("insert into preset values( 
          $sql{default}, $lastname, $firstname, $initial,
          '$studnum','$grade', $homeroom )");
	$sth2->execute;
	if ($DBI::errstr){ print "Preset: $DBI::errstr"; die $DBI::errstr; }

    } # End of preset loop (write the preset table).


    # Now add all records from the preregistration table to preset as well.
    #  Assume that they are already set to the correct grade...

    $sth = $dbh->prepare("select lastname, firstname, initial, studnum, grade, homeroom
      from prereg order by lastname, firstname");
    $sth->execute;
    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }

    while ( my ( $lastname, $firstname, $initial, $studnum, $grade, $homeroom )
	    = $sth->fetchrow ) {

	$lastname = $dbh->quote( $lastname );
	$firstname = $dbh->quote( $firstname );
	$initial = $dbh->quote( $initial );
	$homeroom = $dbh->quote( $homeroom );

	my $sth2 = $dbh->prepare("insert into  preset values( 
           $sql{default}, $lastname, $firstname, $initial,
           '$studnum','$grade', $homeroom )");
	$sth2->execute;
	if ($DBI::errstr){ print "Preset: $DBI::errstr"; die $DBI::errstr; }
    }
    
    
    if ( not $DBI::errstr ) {
	print "<h3>". $lex{'Promotion update is now stored in the temporary student table'};
	print ".</h3></p>";

    } else {
	print "<h3>". $lex{'There was an error storing your data'}. ".<br>\n";
	print $lex{Contact};
	print " $adminname <a href=\"mailto:$adminemail\">$adminemail</a></h3>\n";
	print "<h3>". $lex{Error}. ": $DBI::errstr </h3>";
    }

    #print "<p>[ <a href=\"$eoypage\">". $lex{Eoy}. "</a> ]</p>\n";
    print "</body></html>\n";

    exit;

}
