#! /usr/bin/perl
#  Copyright 2001-2020 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.


my %lex = ('Main' => 'Main',
	   'Walkthrough' => 'Walkthrough',
	   'Description' => 'Description',
	   'Error' => 'Error',
	   'Delete' => 'Delete',
	   'Deleted' => 'Deleted',
	   'View' => 'View',
	   'Evaluation' => 'Evaluation',
	   'Evaluations' => 'Evaluations',
	   'Subject' => 'Subject',
	   'Name' => 'Name',
	   'Date' => 'Date',
	   'Title' => 'Title',
	   'Edit' => 'Edit',
	   'Yes' => 'Yes',
	   'Record' => 'Record',
	   'Are you sure' => 'Are you sure',
	   'Update' => 'Update',
	   'Updated' => 'Updated',
	   'No Records Found' => 'No Records Found',
	   'Areas of Strength' => 'Areas of Strength',
	   'Areas for Improvement' => 'Areas for Improvement',

	   );

my $self = 'pwalkevalview.pl';


use DBI;
use CGI;
use Data::UUID;


# Current Date
my @tim = localtime(time);
my $year = @tim[5] + 1900;
my $month = @tim[4] + 1;
my $day = @tim[3];
if (length($month) == 1) { $month = '0'.$month; }
if (length($day) == 1) { $day = '0'.$day; }
my $currdate = "$year-$month-$day";


# Read database access

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

# Setup Database access
my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


my $q = new CGI;
my %arr = $q->Vars;
print $q->header( -charset, $charset );


# Page Header
my $title = qq{$lex{Walkthrough} $lex{Evaluations}};

print qq{$doctype\n<html><head><title>$title</title>
<link rel="stylesheet" href="$css" type="text/css">\n};


if ( $arr{page} == 1 ) { # load jQuery libs
    print qq{<script type="text/javascript" src="$g_jquery_url">};
    print qq{</script>\n};

    print qq{<script type="text/javascript" src="$g_jquery_ui_url">};
    print qq{</script>\n};
}


print qq{$chartype\n</head><body style="padding:1em 3em;">\n};
print qq{<div>[ <a href="$homepage">$lex{Main}</a> ]</div>\n};

print qq{<h1>$title</h1>\n};


if ( not $arr{page} ) {
    showStartPage();

} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    showEvaluation();

} elsif ( $arr{page} == 2 ) {
    delete $arr{page};
    editEvaluation();

} elsif ( $arr{page} == 3 ) {
    delete $arr{page};
    updateEvaluation();

} elsif ( $arr{page} == 4 ) {
    delete $arr{page};
    confirmDelete( $arr{id} );

}  elsif ( $arr{page} == 5 ) {
    delete $arr{page};
    deleteEval( $arr{id} );
}


#-----------------
sub editEvaluation {
#-----------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="3">\n};


    # Get Master Record
    my $sth = $dbh->prepare("select * from pwalk_eval where id = ?");
    $sth->execute( $arr{id} );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    my $mref = $sth->fetchrow_hashref;
    my %mst = %$mref;
    my $mstid = $mst{id};


    # Loop through all score records
    my $sth = $dbh->prepare("select * from pwalk_score where mstid = ? order by sequence");
    $sth->execute( $mstid );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

    print qq{<h3>$mst{tfirstname} $mst{tlastname}\n};
    print qq{ <span style="font-size:80%;">($mst{title} &ndash; $mst{description}) $mst{adatetime}</span></h3>\n};
    print qq{<div style="font-weight:bold;margin:0.3em;">$lex{Subject} $mst{subject}</div>\n};

    print qq{<table cellpadding="3" cellspacing="0" border="1">\n};
    print qq{<tr><th colspan="2">$lex{Evaluation}</th></tr>\n};

    print qq{<tr><td colspan="2"><input type="submit" value="$lex{Update} $lex{Record}"></td></tr>\n};

    while ( my $ref = $sth->fetchrow_hashref ) {
	%r = %$ref;

	print qq{<tr><td class="bla" colspan="2">$r{description} ($r{category})</td></tr>\n};
	print qq{<tr><td class="bra">Score</td><td class="la">};
	print qq{<select name="score:$r{id}"><option>$r{score}</option>\n};
	foreach my $i (1..4){ 
	    if ( $i == $r{score} ) { next; }
	    print qq{<option>$i</option>};
	}
	print qq{</select></td></tr>\n};

	print qq{<tr><td class="bra">$lex{'Areas of Strength'}</td><td class="la">};
	print qq{<textarea name="strengths:$r{id}" rows="5" cols="50">$r{strengths}</textarea></td></tr>\n};

	print qq{<tr><td class="bra">$lex{'Areas for Improvement'}</td><td class="la">};
	print qq{<textarea name="weaknesses:$r{id}" rows="5" cols="50">$r{weaknesses}</textarea></td></tr>\n};

    }

    print qq{<tr><td class="bra">General Comments</td><td class="la">};
    print qq{<textarea name="MSTCOM:$mstid" rows="5" cols="100">$mst{comment}</textarea></td></tr>\n};

    print qq{<tr><td class="bra">Continue Editing</td><td class="la">};
    my $checked;
    if ( $mst{continueedit} ) { $checked = qq{checked="checked"}; }
    print qq{<input type="checkbox" name="continueedit" value="1" $checked></td></tr>\n};

    print qq{<tr><td colspan="2"><input type="submit" value="$lex{Update} $lex{Record}"></td></tr>\n};

    print qq{</table></form>\n};
    print qq{</body></html>\n};

    exit;

} # end of editEvaluation



#-----------------
sub showEvaluation {
#-----------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    # Get Master Record
    my $sth = $dbh->prepare("select * from pwalk_eval where id = ?");
    $sth->execute( $arr{id} );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    my $mref = $sth->fetchrow_hashref;
    my %mst = %$mref;
    my $mstid = $mst{id};


    # Loop through all template records
    my $sth = $dbh->prepare("select * from pwalk_score where mstid = ? order by sequence");
    $sth->execute( $mstid );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

    print qq{<h3>$mst{tfirstname} $mst{tlastname}\n};
    print qq{ <span style="font-size:80%;">($mst{title} &ndash; $mst{description}) $mst{adatetime}</span></h3>\n};
    print qq{<div style="font-weight:bold;margin:0.3em;">$lex{Subject} $mst{subject}</div>\n};

    print qq{<table cellpadding="3" cellspacing="0" border="1">\n};
    print qq{<tr><th colspan="2">$lex{Evaluation}</th></tr>\n};

    while ( my $ref = $sth->fetchrow_hashref ) {
	%r = %$ref;

	print qq{<tr><td class="bla" colspan="2">$r{description} ($r{category})</td></tr>\n};
	print qq{<tr><td class="bra">Score</td><td class="la">$r{score}</td></tr>\n};
	print qq{<tr><td class="bra">$lex{'Areas of Strength'}</td><td class="la">$r{strengths}</td></tr>\n};
	print qq{<tr><td class="bra">$lex{'Areas for Improvement'}</td><td class="la">$r{weaknesses}</td></tr>\n};
    }

    print qq{<tr><td class="bra">General Comments</td><td class="la">$mst{comment}</td></tr>\n};
    print qq{</table>\n};
    print qq{</body></html>\n};

    exit;

} # end of showEvaluation


#-------------------
sub updateEvaluation {
#-------------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    # Don't mess up existing; pull out value.
    my $continueedit = $arr{continueedit};
    delete $arr{continueedit};

    my $sth1 = $dbh->prepare("update pwalk_eval set comment = ? where id = ?");

    foreach my $key ( keys %arr ) { 

	my ($val, $recid ) = split(':', $key);

	if ( $val eq 'MSTCOM' ) { # update master record
	    $sth1->execute( $arr{$key}, $recid );
	    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

	    if ( $continueedit ) { # set value
		my $sth2 = $dbh->prepare("update pwalk_eval set continueedit = 1 where id = ?");
		$sth2->execute( $recid );
		if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

	    } else { # clear value
		my $sth2 = $dbh->prepare("update pwalk_eval set continueedit = NULL where id = ?");
		$sth2->execute( $recid );
		if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	    }


	} else { # do the rest
	    my $sth = $dbh->prepare("update pwalk_score set $val = ? where id = ?");
	    $sth->execute( $arr{$key}, $recid );
	    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	}

    }

    print qq{<h3>$lex{Record} $lex{Updated}</h3>\n};

    print qq{<p>[ <a href="$self">$title</a> ]</p>\n};
    print qq{</body></html>\n};

    exit;
	

}


#----------------
sub showStartPage {
#----------------

    # Get the Evaluations
    my $sth = $dbh->prepare("select * from pwalk_eval order by adatetime desc, tlastname, tfirstname");
    $sth->execute;
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    $first = 1;


    while ( my $ref = $sth->fetchrow_hashref ) {
	my %r = %$ref;

	if ( $first ) { 
	    print qq{<table cellpadding="3" cellspacing="0" border="1">\n};
	    print qq{<tr><th>$lex{Name}</th><th>$lex{Date}</th><th>$lex{Title}</th>\n};
	    print qq{<th>$lex{Description}</th><th></th><th></th><th></th></tr>\n};
	    $first = 0;
	}

	print qq{<tr><td class="la"><b>$r{tlastname}</b>, $r{tfirstname}</td>};
	print qq{<td>$r{adatetime}</td><td>$r{title}</td><td>$r{description}</td>\n};

	print qq{<td><form action="$self" method="post">\n};
	print qq{<input type="hidden" name="page" value="1">\n};
	print qq{<input type="hidden" name="id" value="$r{id}">\n};
	print qq{<input type="submit" value="$lex{View}"></form></td>\n};

	print qq{<td><form action="$self" method="post">\n};
	print qq{<input type="hidden" name="page" value="2">\n};
	print qq{<input type="hidden" name="id" value="$r{id}">\n};
	print qq{<input type="submit" value="$lex{Edit}"></form></td>\n};

	print qq{<td><form action="$self" method="post">\n};
	print qq{<input type="hidden" name="page" value="4">\n};
	print qq{<input type="hidden" name="id" value="$r{id}">\n};
	print qq{<input type="submit" value="$lex{Delete}"></form></td></tr>\n};

    }

    if ( $first ) {
	print qq{<h3>$lex{'No Records Found'}</h3>\n};
    } else {
	print qq{</table>\n};
    }

    print qq{</body></html>\n};
    exit;

}



#----------------
sub confirmDelete {
#----------------

    my $id = shift;

    # Load Record
    my $sth = $dbh->prepare("select * from pwalk_eval where id = ?");
    $sth->execute( $id );
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
    my $ref = $sth->fetchrow_hashref;
    my %r = %$ref;

    print qq{<table cellpadding="3" cellspacing="0" border="0">\n};

    print qq{<tr><td class="bra">$lex{Name}</td>};
    print qq{<td class="la">$r{tfirstname} $r{tlastname}</td></tr>\n};

    print qq{<tr><td class="bra">$lex{Date}</td>};
    print qq{<td class="la">$r{adatetime}</td></tr>\n};

    print qq{<tr><td class="bra">$lex{Title}</td>};
    print qq{<td class="la">$r{title}</td></tr>\n};

    print qq{<tr><td class="bra">$lex{Description}</td>};
    print qq{<td class="la">$r{description}</td></tr>\n};

    print qq{</table>\n};

    print qq{<h3>$lex{Delete} $lex{Record}: $lex{'Are you sure'}?</h3>\n};

    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="5">\n};
    print qq{<input type="hidden" name="id" value="$arr{id}">\n};
    print qq{<input type="submit" value="$lex{Yes}, $lex{Delete} $lex{Record}">\n};
    print qq{</form></body></html>\n};

    exit;

}


#---------------
sub deleteEval {
#---------------

    # foreach my $key ( sort keys %arr) { print qq{K:$key V:$arr{$key}<br>\n}; }

    my $id = shift;

    # load the record
    my $sth = $dbh->prepare("select * from pwalk_eval where id = ?");
    $sth->execute( $id );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    my $ref = $sth->fetchrow_hashref;
    my %r = %$ref;


    my $sth = $dbh->prepare("delete from pwalk_score where mstid = ?");
    $sth->execute( $id );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

    $sth = $dbh->prepare("delete from pwalk_eval where id = ?");
    $sth->execute( $id );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }


    print qq{<h3>$lex{Record} $lex{Deleted}: $r{tfirstname} $r{tlastname} - $r{title}</h3>\n};

    print qq{<p>[ <a href="$self">$title</a> ]</p>\n};
    print qq{</body></html>\n};

    exit;

}


