#! /usr/bin/perl
#  Copyright 2001-2016 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.


my %lex = ('Main' => 'Main',
	   'Walkthrough' => 'Walkthrough',
	   'Description' => 'Description',
	   'Error' => 'Error',
	   'Report' => 'Report',
	   'Evaluation' => 'Evaluation',
	   'Subject' => 'Subject',
	   'Title' => 'Title',
	   'No Records Found' => 'No Records Found',
	   'Areas of Strength' => 'Areas of Strength',
	   'Areas for Improvement' => 'Areas for Improvement',

	   );

my $self = 'pwalkrpt1.pl';


use DBI;
use CGI;
use Data::UUID;


# Current Date
my @tim = localtime(time);
my $year = @tim[5] + 1900;
my $month = @tim[4] + 1;
my $day = @tim[3];
if (length($month) == 1) { $month = '0'.$month; }
if (length($day) == 1) { $day = '0'.$day; }
my $currdate = "$year-$month-$day";


# Read database access

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}



# Setup Database access
my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


my $q = new CGI;
my %arr = $q->Vars;
print $q->header( -charset, $charset );


# Page Header
my $title = "$lex{Walkthrough} $lex{Report} 1";

print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};


print "$chartype\n</head><body style=\"padding:1em 3em;\">\n";
print "<div>[ <a href=\"$homepage\">$lex{Main}</a> ]</div>\n";

print "<h1>$title</h1>\n";


if ( not $arr{page} ) {
    showStartPage();
} 



#-----------------
sub showEvaluation {
#-----------------

    # foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }

    # Get Master Record
    my $sth = $dbh->prepare("select * from pwalk_eval where id = ?");
    $sth->execute( $arr{id} );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    my $mref = $sth->fetchrow_hashref;
    my %mst = %$mref;
    my $mstid = $mst{id};


    # Loop through all template records
    my $sth = $dbh->prepare("select * from pwalk_score where mstid = ? order by sequence");
    $sth->execute( $mstid );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

    print qq{<h3>$mst{tfirstname} $mst{tlastname}\n};
    print qq{ <span style="font-size:80%;">($mst{title} &ndash; $mst{description}) $mst{adatetime}</span></h3>\n};
    print qq{<div style="font-weight:bold;margin:0.3em;">$lex{Subject} $mst{subject}</div>\n};

    print qq{<table cellpadding="3" cellspacing="0" border="1">\n};
    print qq{<tr><th colspan="2">$lex{Evaluation}</th></tr>\n};

    while ( my $ref = $sth->fetchrow_hashref ) {
	%r = %$ref;

	print qq{<tr><td class="bla" colspan="2">$r{description} ($r{category})</td></tr>\n};
	print qq{<tr><td class="bra">Score</td><td class="la">$r{score}</td></tr>\n};
	print qq{<tr><td class="bra">$lex{'Areas of Strength'}</td><td class="la">$r{strengths}</td></tr>\n};
	print qq{<tr><td class="bra">$lex{'Areas for Improvement'}</td><td class="la">$r{weaknesses}</td></tr>\n};
    }

    print qq{<tr><td class="bra">General Comments</td><td class="la">$mst{comment}</td></tr>\n};
    print "</table>\n";
    print "</body></html>\n";

    exit;

} # end of showEvaluation


#----------------
sub showStartPage {
#----------------

    # Setup Year-Months.
    my @months;
    my %months;
    my %walks; # $walks{description}{$month} = count;


    my ($sy, $sm, $sd) = split('-', $schoolstart); # schoolstart is global var from config.
    $sm =~ s/^0//; # strip leading zero
    my $yrmo = "$sy-$sm";
    push @months, $yrmo;
    $months{$yrmo} = "$s_month[$sm]-$sy";

    for my $i (1..10) {
	my $mo = $sm + $i;
	my $yr = $sy;
	if ( $mo > 12 ) {
	    $mo = $mo - 12;
	    $yr++;
	}
	my $yrmo = "$yr-$mo";
	push @months, $yrmo;
	$months{$yrmo} = "$s_month[$mo]-$yr";
    }



    # Get the Evaluations
    my $sth = $dbh->prepare("select description, title, adatetime from pwalk_eval");
    $sth->execute;
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

    while ( my ($desc, $title, $datetime) = $sth->fetchrow ) {
	# Get the month
	my ($date, $time) = split(/\s+/, $datetime);
	my ($y,$m,$d) = split('-', $date);

	$titles{$desc} = $title;

	$walks{$desc}{$m}++;
    }

    if ( %walks ) { 
	    print qq{<table cellpadding="3" cellspacing="0" border="1">\n};
	    print qq{<tr><th>$lex{Description}</th><th>$lex{Title}</th>};
	    foreach my $yrmo ( @months ) { print qq{<th>$months{$yrmo}</th>};}
	    print qq{</tr>\n};
    }


    foreach my $desc ( sort keys %walks ) {
	my $title = $titles{$desc};
	print qq{<tr><td>$desc</td><td>$title</td>\n};
	foreach my $yrmo ( @months ) { 
	    my ($yr,$mo) = split('-', $yrmo);
	    print qq{<td class="cn">$walks{$desc}{$mo}</td>};
	}
    }

    if ( $first ) {
	print qq{<h3>$lex{'No Records Found'}</h3>\n};
    } else {
	print qq{</table>\n};
    }

    print qq{</body></html>\n};
    exit;

}
