#!/usr/bin/perl
#  Copyright 2001-2023 Leslie Richardson

#  This file is part of Open Admin for Schools.


my %lex = ('Error' => 'Error',
	   'Show Help' => 'Show Help',
	   'Not Found' => 'Not Found',
	   'Close' => 'Close',
	   'Reading Level' => 'Reading Level',

	   );

my $self = 'showhelp.pl';

use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = CGI->new;
my %arr = $q->Vars;
print $q->header( -charset, $charset );

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Print Page Heading
my $title = $lex{'Show Help'};
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$tchcss" type="text/css">\n};
print qq{$chartype\n</head><body style="padding:0.4em 2em;">\n};

my $readtable = 'read_level_dra2';
if ( $arr{dt} == 3 ) {
    $readtable = 'read_level_dra3';
}

$sth = $dbh->prepare("select readlevel, category, name, help1, help2, help3
		     from $readtable where id = ?");
$sth->execute( $arr{id} );
if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
my ( $readlevel, $category, $name, $help1, $help2, $help3 ) = $sth->fetchrow;

print qq{<div style="font-weight:bold;">$lex{'Reading Level'} };
print qq{ $readlevel - $category - $name</div>\n};
print qq{<ul>$help1</ul>\n};

print qq{<p style="text-align:center;">\n};
print qq{<form><input type="button" value="$lex{Close}" };
print qq{onClick="parent.close()"></form>\n};

print qq{</body></html>\n};
