#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Report Card' => 'Report Card',
	   'Main' => 'Main',
	   'Code-Section' => 'Code-Section',
	   'Grade' => 'Grade',
	   'PowerDelete' => 'PowerDelete',
	   'Error' => 'Error',
	   'Group' => 'Group',
	   'Student' => 'Student',
	   'Term' => 'Term',
	   'Edit' => 'Edit',
	   'Delete' => 'Delete',
	   'Course' => 'Course',
	   'Enrollments' => 'Enrollments',
	   'Withdrawn' => 'Withdrawn',
	   'Room' => 'Room',
	   'Evaluations' => 'Evaluations',
	   'Records' => 'Records',
	   'Update' => 'Update',
	   'Updated' => 'Updated',
	   'Comment' => 'Comment',
	   
	   );

my $self = 'evaldeled.pl';

use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

my $q = CGI->new;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Page Header
my $title = "$lex{Edit}/$lex{Delete} $lex{Course} $lex{Evaluations}/$lex{Enrollments}";
print qq{$doctype\n<html><head><title>$title</title>
<link rel="stylesheet" href="$css" type="text/css">
$chartype\n</head><body>\n};

print qq{[ <a href="$homepage">$lex{Main}</a> |\n};
print qq{<a href="$reppage">$lex{'Report Card'}</a> ]\n};

print qq{<h1>$title</h1>\n};

#foreach my $key ( keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

if ( not $arr{page} ) {
    showStartPage();
    
} elsif ( $arr{page} == 1 ) {
    delete $arr{page};
    showStudents();
    
} elsif ( $arr{page} == 2 ) {
    delete $arr{page};
    deleteEdit();  # confirm deletion of records, and display edit forms
    
}  elsif ( $arr{page} == 3 ) {
    delete $arr{page};
    updateEdit();  # update edit of records.
    
} elsif ( $arr{page} == 4 ) { # out of order, but will do delete, if confirmed.
    delete $arr{page};
    updateDelete();  # delete eval records.
}


#---------------
sub updateDelete {  
#---------------

    # delete records, after confirm in deleteEdit function (page 2). Pass through any edit recs.
   
    # print qq{<div>updateDelete - Page 4</div>\n};
    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    # print qq{<br>\n\n};

    my $subjsec = $arr{subjsec};
    delete $arr{subjsec};
    
    # Get Course Info
    my $sth = $dbh->prepare("select * from subject where subjsec = ?");
    $sth->execute( $subjsec);
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my $cref = $sth->fetchrow_hashref;
    my %c = %$cref; # course info now in %c hash.
    if ( not $c{a1} ) { $c{a1} = 'Mark'; }
        
    my $sth = $dbh->prepare("delete from eval where subjcode = ? and studnum = ? and term = ?");
    my $sth1 = $dbh->prepare("select lastname, firstname from studentall where studnum = ?");
    my $sth2 = $dbh->prepare("select * from eval where subjcode = ? and studnum = ? order by term");
    
    my %name; # student names, colon separated.
    
    # split values into delete or edit groups.
    my (%deletesort, @edit);
    
    foreach my $key ( keys %arr ) {
	my ($mode, $studnum, $term) = split(':', $key );
	if ( $mode eq 'edit' ) {
	    push @edit, $key;
	    next;
	}
	
	# Get Name, if not in name hash.
	if ( not $name{$studnum} ) {
	    $sth1->execute( $studnum);
	    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	    my ($lastname, $firstname) = $sth1->fetchrow;
	    $name{$studnum} = qq{$lastname:$firstname};
	}

	$deletesort{"$name{$studnum}$studnum$term"} = $key;
    }

    
    if (%deletesort) { # we have records to delete
	print qq{<div style="font-weight:bold;">};
	print qq{Delete Records for $c{description}</div>\n};

	foreach my $key ( sort keys %deletesort ) {
	    my ($mode, $studnum, $term) = split(':', $deletesort{$key} );
	    my ($ln,$fn) = split(':', $name{$studnum});

	    $sth->execute( $subjsec, $studnum, $term);
	    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	    
	    print qq{<div>Deleted $fn $ln - Term $term</div>\n};
	}
    }

    # Now do the form to go back to page 2, now without any deletes.
    if ( @edit ) { # we have edits to do yet; link back to page 2
	print qq{<form action="$self"  method="post" style="display:inline;">\n};
	print qq{<input type="hidden" name="page" value="2">\n};
	print qq{<input type="hidden" name="subjsec" value="$subjsec">\n};

	foreach my $key ( @edit ) {
	    print qq{<input type="hidden" name="$key" value="1">\n};
	}
	
	print qq{<p><input type="submit" value="Continue to Edit Evaluation Records"></p>\n};
	print qq{</form>\n};
	    
    } else { # we're done. Provide links to do more.
	    
	print qq{<form action="$self"  method="post" style="display:inline;">\n};
	print qq{<input type="submit" value="Start Page">\n};
	print qq{</form>\n};

	print qq{<form action="$self#$c{grade}"  method="post" style="display:inline;">\n};
	print qq{<input type="submit" value="Same Grade">\n};
	print qq{</form>\n};
    }

    print qq{</body></html>\n};
    exit;

} # end of updateDelete; go back to page 2 if still edits to do.

    

#-------------
sub updateEdit {  # update passed records.
#-------------

    # print qq{<div>updateEdit - Page 3</div>\n};
    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    # print qq{<br><br>\n};

    my $subjsec = $arr{subjsec};
    delete $arr{subjsec}; # leave for now.

    # Get Course Info
    my $sth = $dbh->prepare("select * from subject where subjsec = ?");
    $sth->execute( $subjsec);
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my $cref = $sth->fetchrow_hashref;
    my %c = %$cref; # course info now in %c hash.

    
    foreach my $key ( sort keys %arr ) {
	my ($id, $field) = split(':', $key);
	if ( not defined $arr{$key} ) { $arr{$key} = undef; } # make a NULL record.
	
#	print qq{Field:$field ID:$id Value:$arr{$key}<br>\n};

	my $sth = $dbh->prepare("update eval set $field = ? where id = ?");
	$sth->execute( $arr{$key}, $id);
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    }

    print qq{<h3>$lex{Records} $lex{Updated}</h3>\n};

    print qq{<form action="$self"  method="post" style="display:inline;">\n};
    print qq{<input type="submit" value="Start Page">\n};
    print qq{</form>\n};

    print qq{<form action="$self#$c{grade}"  method="post" style="display:inline;">\n};
    print qq{<input type="submit" value="Same Grade">\n};
    print qq{</form>\n};

    print qq{<form action="$self"  method="post" style="display:inline;">\n};
    print qq{<input type="hidden" name="page" value="1">\n};
    print qq{<input type="hidden" name="subjsec" value="$subjsec">\n};
    print qq{<input type="submit" value="Same Course">\n};
    print qq{</form>\n};

    print qq{</body></html>\n};
    
    exit;
}

    

#-------------
sub deleteEdit {  # check for records to delete, then display form for editss
#-------------

    # print qq{<div>Page 2 deleteEdit</div>\n};
    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
    # print qq{<br>\n\n};

    my $subjsec = $arr{subjsec};
    delete $arr{subjsec};

    # Get Course Info
    my $sth = $dbh->prepare("select * from subject where subjsec = ?");
    $sth->execute( $subjsec);
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my $cref = $sth->fetchrow_hashref;
    my %c = %$cref; # course info now in %c hash.
    if ( not $c{q1} ) { $c{q1} = 'Mark'; }
    
    # Count the number of objectives.
    my $objcount = 1;
    foreach my $val (2..20) {
	my $field = 'q'.$val;
#	print "FLD:$field VAL:$c{$field}<br>\n";
	if ( $c{$field} ) {
	    $objcount = $val;
	} else { last; }
    }
#    print "OBJ:$objcount<br>\n";

    
    my $sth = $dbh->prepare("delete from eval where subjcode = ? and studnum = ? and term = ?");
    my $sth1 = $dbh->prepare("select lastname, firstname from studentall where studnum = ?");
    my $sth2 = $dbh->prepare("select * from eval where subjcode = ? and studnum = ? order by term");
        
    my %name; # student names, colon separated.
           
    # split values into delete or edit groups.
    my (%deletesort, @edit);
    
    foreach my $key ( keys %arr ) {
	my ($mode, $studnum, $term) = split(':', $key );
	if ( $mode eq 'edit' ) {
	    push @edit, $key;
	    next;
	}
	
	# Get Name, if not in name hash.
	if ( not $name{$studnum} ) {
	    $sth1->execute( $studnum);
	    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	    my ($lastname, $firstname) = $sth1->fetchrow;
	    $name{$studnum} = qq{$lastname:$firstname};
	}

	$deletesort{"$name{$studnum}$studnum$term"} = $key;

    }

    # print qq{<div>Test - DeleteSort</div>\n};
    # foreach my $key ( sort keys %deletesort ) { print qq{K:$key V:$deletesort{$key}<br>\n}; }
    
    
    # Display students, confirm, and send to pass through delete form.

    if (%deletesort) { # we have records to delete
	print qq{<div style="font-weight:bold;">};
	print qq{Delete Records for $c{description}</div>\n};

	foreach my $key ( sort keys %deletesort ) {
	    my ($mode, $studnum, $term) = split(':', $deletesort{$key} );
	    my ($ln,$fn) = split(':', $name{$studnum});
	    print qq{<div>Delete $fn $ln - Term $term</div>\n};
	}

	# Now do the form to skip to page 4 (updateDelete) with all passed values.
	print qq{<form action="$self"  method="post" style="display:inline;">\n};
	print qq{<input type="hidden" name="page" value="4">\n};
	print qq{<input type="hidden" name="subjsec" value="$subjsec">\n};

	foreach my $key ( keys %arr ) {
	    print qq{<input type="hidden" name="$key" value="$arr{$key}">\n};
	}
	
	print qq{<p><input type="submit" value="Yes, delete these records!"></p>\n};
	print qq{</form>\n};

	print qq{</body></html>\n};
	exit;

    }

    # If we're here, no deletions to do.
    
    my %sort;
    foreach my $key ( keys %arr ) {
	my ($mode, $studnum, $term) = split(':', $key );
	if ( $mode eq 'delete' ) { next; } # skip deletes.
	
	# Get Name, if not in name hash.
	if ( not $name{$studnum} ) {
	    $sth1->execute( $studnum);
	    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	    my ($lastname, $firstname) = $sth1->fetchrow;
	    $name{$studnum} = qq{$lastname:$firstname};
	}

	$sort{"$name{$studnum}$c{description}"} = $studnum;
    }

    # Course Description
    print qq{<h3>Course $c{description} / Grade $c{grade} / Terms };
    print qq{$c{startrptperiod}-$c{endrptperiod}</h3>\n};


    # If no edits, end the page.
    if ( not %sort ) {
	print qq{<form action="$self"  method="post" style="display:inline;">\n};
	print qq{<input type="submit" value="Start Page">\n};
	print qq{</form>\n};

	print qq{<form action="$self#$c{grade}"  method="post" style="display:inline;">\n};
	print qq{<input type="submit" value="Same Grade">\n};
	print qq{</form>\n};

    
	print qq{<form action="$self"  method="post" style="display:inline;">\n};
	print qq{<input type="hidden" name="page" value="1">\n};
	print qq{<input type="hidden" name="subjsec" value="$subjsec">\n};
	print qq{<input type="submit" value="Same Course">\n};
	print qq{</form>\n};
	
	print qq{</body></html>\n};
	exit;
    }


    
    # Start Form for Edit
    print qq{<form action="$self"  method="post">\n};
    print qq{<input type="hidden" name="page" value="3">\n};
    print qq{<input type="hidden" name="subjsec" value="$subjsec">\n};
    
    print qq{<input type="submit" value="$lex{Update} $lex{Records}">\n};


    
    # Student Edit Loop
    foreach my $tkey ( sort keys %sort ) {
	# print qq{TKEY:$tkey VAL:$sort{$tkey}<br>\n};
	
	my $studnum = $sort{$tkey};
#	print qq{Studnum:$studnum<br>\n};
	my ($ln, $fn) = split(':', $name{$studnum});

	print qq{<h3>$fn $ln</h3>\n};
	
	# now display for edit records.
	print qq{<table cellpadding="3" cellspacing="0" border="1" style="margin-bottom:0.5em;">\n};

	# Get eval info for this student, this course.
	$sth2->execute( $subjsec, $studnum);
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	while ( my $ref = $sth2->fetchrow_hashref ) {
	    my %r = %$ref; # an eval record.
	    my $id = $r{id};

	    print qq{<tr><th colspan="2">Term $r{term}</th></tr>\n};
	    print qq{<tr><td class="bra" style="vertical-align:top;">$lex{Comment}</td>\n};
	    print qq{<td class="la"><textarea name="$id:comment" rows="3" cols="60">};
	    print qq{$r{comment}</textarea></td></tr>\n};

	    for my $val (1..$objcount) {
		my $displayfld = 'q'.$val; # from subject table;
		my $field = 'a'.$val; # correct field name for eval table
		print qq{<tr><td class="bra">$c{$displayfld}</td>};
		print qq{<td><input type="text" name="$id:$field" value="$r{$field}"></td></tr>\n};
	    }
	}
	
	print qq{</table>\n\n};

    }

    print qq{<input type="submit" value="$lex{Update} $lex{Records}">\n};
    print qq{</form>\n};
    print qq{</body></html>\n};
    
    exit;

} # end of deleteEdit; page 2.


#----------------
sub showStartPage {
#----------------

    # Show Main Eval Subjects
    my @grades;
    my $sth = $dbh->prepare("select distinct grade from subject");
    $sth->execute;
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    while ( my $gr = $sth->fetchrow ) {
	push @grades, $gr;
    }
    @grades = sort {$a <=> $b} @grades; # put in correct order


    # print Link Line table.
    print qq{<table cellpadding="3" cellspacing="0" border="0" style="border:2px };
    print qq{solid gray;margin:1em;padding:0.4em;">\n};
    print qq{<tr><td class="bra">Jump To Grade</td>\n};
    foreach my $grade ( reverse @grades ) {
	print qq{<td class="bcn" style="font-size:120%;"><a href="#$grade">$grade</a></td>\n};
    }
    print qq{</tr></table>\n};


    # Get Teachers Names, grades, homerooms.
    my (%names, %homerooms);
    my $sth1 = $dbh->prepare("select field_value from staff_multi where 
      field_name = 'homeroom' and userid = ?");
    my $sth = $dbh->prepare("select sal, lastname, firstname, userid from staff");
    $sth->execute;
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    while ( my $ref = $sth->fetchrow_hashref ) {
	my %tch = %$ref;
	my $userid = $tch{userid};
	
	# Get homerooms.
	$sth1->execute($userid);;
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	while ( my $room = $sth1->fetchrow ) {
	    $homerooms{$room} = $userid;  # assume one teacher for each homeroom;
	}
	
	$names{$userid} = qq{$tch{sal} $tch{firstname} $tch{lastname}};
    }

    my %revrooms = reverse %homerooms; # teacher userid to homeroom


    # Find distinct terms in eval;
    my $sth1 = $dbh->prepare("select distinct term from eval where subjcode = ?");
    # Count Distinct terms.
    my $sth2 = $dbh->prepare("select count(*) from eval where subjcode = ? and term = ?");

    # Student homerooms for that grade
    my $sth3 = $dbh->prepare("select count(distinct homeroom) from student where grade = ? 
      and homeroom is not null");



    my $first = 1;
    foreach my $grade ( @grades ) {
    
	# Get distinct homerooms from student records.
	$sth3->execute( $grade );
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	my $hrcount = $sth3->fetchrow;
	# print "HRCount:$hrcount<br>\n";
    
	# sortorder;
	my $sth;
	if ( $hrcount > 1 ) { # 2 or more classrooms; sort by section.
	    $sth = $dbh->prepare("select subjsec, description, teacher, 
              startrptperiod, endrptperiod, section from subject 
              where grade = ? order by section, description");
	} else {
	    $sth = $dbh->prepare("select subjsec, description, teacher, 
             startrptperiod, endrptperiod, section 
             from subject where grade = ? order by description");
	}


	if ( $first ) {
	    print qq{<h3>Please note: These records contain marks/evaluations.<br>\n};
	    print qq{If you delete them, you delete student evaluations also.</h3>\n};
	    $first = 0;

	} else { # close table from previous loop
	    print qq{</table>\n};
	}

	# Display grade
	print qq{<h3 id="$grade" style="margin-bottom:0em;">$lex{Grade} $grade</h3>\n};

	# Print Table Heading.
	print qq{<table cellpadding="3" cellspacing="0" border="1">\n};
	print qq{<tr><th>$lex{Course}</th><th>$lex{'Code-Section'}<br>Terms</th>};
	print qq{<th>Teacher (Room)</th>};
	print qq{<th>Enrolled</th><th>Status</th><th></th><th></th></tr>\n};

	my ($prevsection,$currsection); # flags to notify if section change, for divider.
    
	# Get the subjects in this grade;
	$sth->execute( $grade );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	
	while ( my ( $subjsec, $description, $teacher, $startterm, $endterm, $section )
		= $sth->fetchrow ) {

	    $prevsection = $currsection;
	    $currsection = $section;
	    if ( $currsection ne $prevsection and $hrcount > 1 ) { # put in divider;
		print qq{<tr><td colspan="8" style="background-color:#888;color:white;">};
		print qq{Section $currsection</td></tr>\n};
	    }

	    
	    # Count term number values in eval table;
	    my %ecount; # ecount{term} = val;
	    $sth1->execute( $subjsec );
	    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	    while ( my $term = $sth1->fetchrow ) {
		# Count number of records for this term.
		$sth2->execute( $subjsec, $term );
		if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
		my $count = $sth2->fetchrow;
		$ecount{$term} = $count;
	    }
	    if ( not %ecount ) {
		print qq{<div>$description ($subjsec) - no enrollments</div>\n};
		next;
	    }

	    # check for homogenous numbers of records for each term.
	    my ($test, $recerror );
	    foreach my $t ( keys %ecount ) {
		if ( not $test ) { 
		    $test = $ecount{$t};
		    next;
		} else {
		    if ( $ecount{$t} != $test ) { # we have an error
			$recerror = 1;
			last;
		    }
		}
	    }

	    my $errortext;
	    @terms = sort keys %ecount;
	    my $sterm = $terms[0];
	    my $eterm = $terms[-1]; # end of array.
	    if ( $eterm != $endterm ) {
		$errortext = qq{Course master end term ($endterm) doesn't agree }.
		    qq{with enrollments end term ($eterm)};
	    }
	

	    # Print Course Desc / Subjsec
	    print qq{<tr><td class="bla">$description</td><td>$subjsec / $startterm-$endterm</td>};
	    print qq{<td>$names{$teacher} };
	    if ( $revrooms{$teacher} ) {  print qq{($revrooms{$teacher})}; }
	    print qq{</td>\n};
	
	    if ( not $recerror ) { # enrollments.
		print qq{<td class="cn">$test</td>\n};
	    } else { # print nothing; put error in status.
		print qq{<td>Error</td>\n}; 
	    }

	    # Status Line
	    print qq{<td>};
	    if ( $recerror ) {
		print qq{Error in numbers of term records for students<br>\n};
	    }
	    if ( $errortext ) {
		print $errortext;
	    }
	    print qq{</td>\n};

	
	    print qq{<td><form action="$self"  method="post">\n};
	    print qq{<input type="hidden" name="subjsec" value="$subjsec">\n};
	    print qq{<input type="hidden" name="page" value="1">\n};
	    print qq{<input type="submit" value="$lex{Edit}/$lex{Delete}"></form></td>\n};

	    print qq{<td><form action="evalpwrdel.pl" method="post">};
	    print qq{<input type="hidden" name="subjsec" value="$subjsec">\n};
	    print qq{ Chk <input type="checkbox" name="checked" value="checked">\n};
	    print qq{<input type="submit" value="$lex{'PowerDelete'}"></form></td></tr>\n};
	
	}
    }

    print qq{</table>\n};
    print qq{</body></html>\n};
    exit;
    
} # end of showStartPage



#---------------
sub showStudents {
#---------------

    # print qq{<div>Show Students</div>\n};

    
    my $subjsec = $arr{subjsec};

    # Find subject name, terms
    $sth = $dbh->prepare("select description, startrptperiod, endrptperiod from subject 
      where subjsec = ?");
    $sth->execute( $subjsec );
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
    my ($description, $startterm, $endterm) = $sth->fetchrow;

    # Get students in this course.
    my (%name, %sort);
    my $sth1 = $dbh->prepare("select lastname, firstname,grade,homeroom from studentall
    where studnum = ?");

    $sth = $dbh->prepare("select distinct studnum from eval where subjcode = ?");
    $sth->execute( $subjsec );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    while ( my $studnum = $sth->fetchrow ) {
	# Get name;
	$sth1->execute( $studnum );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr;}
	my ($lastname, $firstname,$grade,$homeroom) = $sth1->fetchrow;
	$name{$studnum} = qq{<b>$lastname</b>, $firstname $grade/$homeroom};

	$sort{"$lastname$firstname$studnum"} = $studnum;

    }

    # Heading
    print qq{<h3>$description ($subjsec) Terms: $startterm - $endterm</h3>\n};
    

    $sth1 = $dbh->prepare("select count(*) from studentwd where studnum = ?");
    $sth2 = $dbh->prepare("select term from eval where subjcode = ? and studnum = ? order by term");
    $sth3 = $dbh->prepare("select a1, comment from eval where subjcode = ? and 
       studnum = ? and term = ?");

    

    my $bg1 = '#AAF';
    my $bg2 = '#CCC';

    
    # Start the Form.
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="2">\n};
    print qq{<input type="hidden" name="subjsec" value="$subjsec">\n};

    print qq{<input type="submit" value="$lex{Delete} / $lex{Edit} $lex{Records}">\n};
    
    # Student Loop
    my $first = 1;
    foreach my $key ( sort keys %sort ) {
	my $studnum = $sort{$key};

	# Check for Withdrawn;
	my $wd;
	$sth1->execute( $studnum );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	my $wdcount = $sth1->fetchrow;
	if ($wdcount) {
	    $wd = qq{<span style="color:red;font-weight:bold;">WD</span>};
	}

	if ( $first ) {
	    print qq{<table cellpadding="3" cellspacing="0" border="1">\n};
	    print qq{<caption style="font-weight:bold;font-size:120%;">};
	    print qq{Deletion of Eval Records must be confirmed.</caption>\n};
	    print qq{<tr><th>$lex{Student} - Grade/Homeroom</th><th>$lex{Edit}</th><th></th>};
	    print qq{<th colspan="6">DELETE! terms (Eval)</th></tr>\n};
	    $first = 0;
	}

	# Loop through this student's records for this course
	if ( $bg eq $bg1 ) { $bg = $bg2 } else { $bg = $bg1 }
	$sth2->execute( $subjsec, $studnum );
	if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

	my @terms;
	while ( $term = $sth2->fetchrow ) {
	    push @terms, $term;
	}

	print qq{<tr style="background-color:$bg">};
	print qq{<td>$wd $name{$studnum} ($studnum)</td>\n};

	# Edit
	print qq{<td class="bcn">};
	print qq{<input type="checkbox" style="border:1px solid red;" name="edit:$studnum" };
	print qq{value="1"><b>Edit</b></td>};


	# Spacer!
	print qq{<td style="width:4ch;"></td>};

	# Delete
	foreach my $term ( @terms ) {
	    $sth3->execute( $subjsec, $studnum, $term );
	    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
	    my ($a1, $comment) = $sth3->fetchrow;
	    my $eval;
	    if ( $comment ) {
		$comment = q{,}. substr $comment, 0, 20;
	    }
	    if ( defined $a1 ) { $eval = qq{($a1$comment)}; }
	    print qq{<td class="bla"><input type="checkbox" name="delete:$studnum:$term" value="1">};
	    print qq{$term $eval</td>\n};

	}
	print qq{</tr>\n};

    } # end of student loop

    print qq{</table>\n};
    print qq{<input type="submit" value="$lex{Delete} / $lex{Edit} $lex{Records}">\n};
    print qq{</form>\n};
    print qq{</body></html>\n};

    exit;

} # end of showStudents
