#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.


my %lex = ('No Subject Found' => 'No Subject Found',
	   'Erase Checked Records' => 'Erase Checked Records',
	   'Main' => 'Main',
	   'Report Card' => 'Report Card',
	   'Name' => 'Name',
	   'Delete' => 'Delete',
	   'Withdrawn' => 'Withdrawn',
	   'NOTE' => 'NOTE',
	   'There is NO confirmation checking' => 'There is NO confirmation checking',
	   'These records are deleted immediately upon clicking this button!' =>
	     'These records are deleted immediately upon clicking this button!',
	   'Error' => 'Error',
	   'Records' => 'Records',
	   'Deleted' => 'Deleted',

	   );

my $self = 'evalpwrdel.pl';

use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;
my $subjsec = $arr{subjsec};
my $checked = $arr{checked};


# HTML Header
my $title = "$lex{Delete} Course Enrollment/Evaluation Records";
print qq{$doctype\n<html><head>\n};
print qq{<title>$title</title><link rel="stylesheet" href="$css" type="text/css">
$chartype\n</head><body>\n};

print qq{[ <a href="$homepage">$lex{Main}</a> |\n};
print qq{<a href="$reppage">$lex{'Report Card'}</a> ]\n};

print qq{<h1>$title</h1>\n};

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


if ( $arr{flag} ) {
    delete $arr{flag};
    deleteRecords();
}


# Find and print course name...
my $sth = $dbh->prepare("select description from subject where subjsec = ?");
$sth->execute( $subjsec );
if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
my $description = $sth->fetchrow;


print qq{<div style="font-size:150%;font-weight:bold;">$description ($subjsec)</div>\n};

my $sth = $dbh->prepare("select distinct e.studnum, s.lastname, s.firstname,s.grade,s.homeroom 
 from eval as e 
 left outer join studentall as s on e.studnum = s.studnum
 where e.subjcode = ?  group by e.studnum
 order by s.lastname, s.firstname");

$sth->execute( $subjsec );
if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }

print qq{<p><b>$lex{'NOTE'}:</b> $lex{'There is NO confirmation checking'}<br>\n}; 
print qq{$lex{'These records are deleted immediately upon clicking this button!'}</p>\n};

# Table/Form start
print qq{<form action="$self" method="post">};
print qq{<input type="hidden" name="flag" value="1">\n};
print qq{<input type="hidden" name="subjsec" value="$subjsec">\n};

print qq{<input type="submit" value="$lex{'Delete'} $lex{Records}">\n};

print qq{<table cellpadding="3" cellspacing="0" border="1">\n};
print qq{<caption style="color:red;">WD = $lex{Withdrawn}</caption>\n};
print qq{<tr><th>$lex{Name}</th><th>Grade/HRm</th><th>Stud#</th><th>$lex{Delete}</th></tr>\n};

my $sth1 = $dbh->prepare("select count(*) from studentwd where studnum = ?");

while ( my ( $studnum, $lastname,$firstname,$gr,$hr ) = $sth->fetchrow ){

    # Get the Name to check which table student is in...
    $sth1->execute( $studnum );
    if ($DBI::errstr){ print $DBI::errstr; die;}
    my $count = $sth1->fetchrow;

    my $wd;
    if ( $count ) {
	$wd = qq{<span style="color:red;">WD</span>};
    }
    print qq{<tr><td>$wd <b>$lastname</b>, $firstname</td><td>$gr/$hr</td><td>$studnum</td>\n<td>};
    print qq{<input type="checkbox" name="$studnum" value="1" $checked></td></tr>\n};
}

print qq{</table>\n};
print qq{<input type="submit" value="$lex{'Delete'} $lex{Records}">\n};
print qq{</form>\n};

print qq{</body></html>\n};


#----------------
sub deleteRecords {
#----------------

    my $subjsec = $arr{subjsec};
    delete $arr{subjsec};

    #foreach my $key (keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    # Get Course Info
    my $sth = $dbh->prepare("select * from subject where subjsec = ?");
    $sth->execute( $subjsec);
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my $cref = $sth->fetchrow_hashref;
    my %c = %$cref; # course info now in %c hash.

    
    my $sth = $dbh->prepare("delete from eval where studnum = ? and subjcode = ?");

    foreach my $studnum ( keys %arr ) { 
	$sth->execute( $studnum, $subjsec );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
    }

    print qq{<h3>$lex{Records} $lex{Deleted}</h3>\n};

    my $self = 'evaldeled.pl';
    
    print qq{<form action="$self"  method="post" style="display:inline;">\n};
    print qq{<input type="submit" value="Start Page">\n};
    print qq{</form>\n};

    print qq{<form action="$self#$c{grade}"  method="post" style="display:inline;">\n};
    print qq{<input type="submit" value="Same Grade">\n};
    print qq{</form>\n};

    print qq{<form action="$self"  method="post" style="display:inline;">\n};
    print qq{<input type="hidden" name="page" value="1">\n};
    print qq{<input type="hidden" name="subjsec" value="$subjsec">\n};
    print qq{<input type="submit" value="Same Course">\n};
    print qq{</form>\n};


    print qq{</body></html>\n};

    exit;

}
