#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('View' => 'View',
	   'Enrollment' => 'Enrollment',
	   'Report Card' => 'Report Card',
	   'Grades' => 'Grades',
	   'Withdrawn' => 'Withdrawn',
	   'Error' => 'Error',
	   'Continue' => 'Continue',
	   'Terms' => 'Terms',
	   'Separate with Spaces' => 'Separate with Spaces',
	   'Blank=All' => 'Blank=All',
	   'Teacher' => 'Teacher',
	   'Sort by' => 'Sort by',
	   'Term' => 'Term',
	   'Grade' => 'Grade',
	   'Description' => 'Description',
	   'Enrol' => 'Enrol',
	   'Main' => 'Main',
	   'Code' => 'Code',
	   'Student' => 'Student',
	   'Count' => 'Count',
	   'Std Dev' => 'Std Dev',
	   'Mean' => 'Average',
	   'Success' => 'Success',
	   'Rate' => 'Rate',
	   'Group by' => 'Group by',
	   'Course' => 'Course',
	   'Not Found' => 'Not Found',
	   'Report' => 'Report',
	   'Credits Earned' => 'Credits<br>Earned',
	   'Attempts' => 'Attempts',
	   'Absent' => 'Absent',

	   );

my $self = 'rptcourse2.pl';
my $markfield = 'a1'; # marks normally stored in first field.


use DBI;
use CGI;
use Statistics::Basic qw(:all);
use Number::Format qw(:all);

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $self: $@<br>\n";
    die $lex{Error}. " $self: $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);



# Print HTML Page Header
my $title = "$lex{Course} $lex{Report} 2";

print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};
print qq{$chartype\n</head><body style="padding:1em 2em;">\n};
print qq{[ <a href="$homepage">$lex{Main}</a> | };
print qq{<a href="$reppage">$lex{'Report Card'}</a> ]\n};

print qq{<h1>$title</h1>\n};


if (not $arr{page} ) {
    showStartPage();

} else {
    delete $arr{page};
    showCourses();
}



#----------------
sub showStartPage {
#----------------

    # Find all of the term patterns.
    my $sth = $dbh->prepare("select distinct startrptperiod, endrptperiod from subject
     order by startrptperiod, endrptperiod");
    $sth->execute;
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }

    # Find Teachers
    my $sth1 = $dbh->prepare("select distinct s.teacher, st.lastname, st.firstname from subject s, staff st
     where s.teacher = st.userid order by st.lastname, st.firstname");
    $sth1->execute;
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }


    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};

    print qq{<table border="0" cellpadding="3" cellspacing="0">\n};

    # Grade Select
    print qq{<tr><td class="bla">$lex{Grades}</td>\n};
    print qq{<td class="la">};
    print qq{<input type="text" name="grade" size="10"> };
    print qq{$lex{'Separate with Spaces'}, $lex{'Blank=All'}</td></tr>\n};


    # Term Select
    print qq{<tr><td class="bla">$lex{Terms}</td><td>};
    while ( my ( $startterm, $endterm ) = $sth->fetchrow ) {
	    print qq{<input type="radio" value="$startterm-$endterm" name="terms">\n};
	    print qq{$startterm-$endterm &nbsp;\n};
    }
    print qq{ $lex{'Blank=All'}</td></tr>\n};

    # Teacher Select
    print qq{<tr><td class="bla">$lex{Teacher}</td><td>};
    print qq{<select name="teacher"><option></option>\n};
    while ( my ( $userid, $lastname, $firstname ) = $sth1->fetchrow ) {
	print qq{<option value="$userid">$lastname, $firstname</option>\n};
    }
    print qq{</select></td></tr>\n};


    # Group by Course or Student
#    print qq{<tr><td class="bla">$lex{'Group by'}</td>};
#    print qq{<td><select name="groupby"><option value="course">$lex{Course}</option>\n};
#    print qq{<option value="student">$lex{Student}</option></select></td></tr>\n};


    # Sorting Order
    my %sorttext = ('term' => "$lex{Term}", grade => "$lex{Grade}", teacher => "$lex{Teacher}",
		    description => "$lex{Description}");
    my @sort = qw (term grade teacher description);
    my $default1 = 'term';
    my $default2 = 'grade';
    my $default3 = 'description';

    print qq{<tr><td class="bla">$lex{'Sort by'}</td><td>};

    # Sort 1
    print qq{<select name="sort1"><option value="$default1">$sorttext{$default1}</option>\n};
    foreach my $val ( @sort ) {
	if ( $val eq $default1 ) { next; }
	print qq{<option value="$val">$sorttext{$val}</option>};
    }
    print qq{</select>&nbsp;&nbsp;\n};

    # Sort 2
    print qq{<select name="sort2"><option value="$default2">$sorttext{$default2}</option>\n};
    foreach my $val ( @sort ) {
	if ( $val eq $default2 ) { next; }
	print qq{<option value="$val">$sorttext{$val}</option>};
    }
    print qq{</select>&nbsp;&nbsp;\n};

    # Sort 3
    print qq{<select name="sort3"><option value="$default3">$sorttext{$default3}</option>\n};
    foreach my $val ( @sort ) {
	if ( $val eq $default3 ) { next; }
	print qq{<option value="$val">$sorttext{$val}</option>};
    }
    print qq{</select>&nbsp;\n};

    print qq{</td></tr>\n};

    print qq{<tr><td colspan="2" class="cn"><input type="submit" value="$lex{Continue}">\n};
    print qq{</td></tr>\n};

    print qq{</table></form></body></html>\n};

    exit;

}




#--------------
sub showCourses {
#--------------

    # foreach my $key ( sort keys %arr ) { print "K:$key V:$arr{$key}<br>\n"; }

=head
#    my %studenrol; # studenrol{studnum} = days  (all year)

    # attendance library
#    eval require '../../lib/libattend.pl';

    # Set CurrDate
    my @tim = localtime(time);
    my $cyear = @tim[5] + 1900;
    my $cmonth = @tim[4] + 1;
    my $cday = @tim[3];
    my $currdate = "$cyear-$cmonth-$cday";
=cut


    # Grade Select
    my $gradeSelect;
    if ( $arr{grade} ) {
	my @grades = split(/\s+/, $arr{grade});
	my $first = 1;
	my $gs;
	foreach my $gr ( @grades ) {
	    $gr = $dbh->quote( $gr );
	    if ( not $first ) { $gs .= ' or '; } else { $first = 0; }
	    $gs .= "grade = $gr ";
	}
	$gradeSelect = $gs;
    }
    # delete $arr{grade};


    # Teacher Select
    my ($lastname, $firstname);
    my $teacherSelect;
    if ( $arr{teacher} ) {
	my $sth = $dbh->prepare("select lastname, firstname from staff where userid = ?");
	$sth->execute( $arr{teacher} );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
	($lastname, $firstname) = $sth->fetchrow;

	my $tch = $dbh->quote( $arr{teacher} );
	$teacherSelect = "teacher = $tch";
    }
    # delete $arr{teacher};


    # Term Select
    my ($startterm, $endterm);
    my $termSelect;
    if ( not $arr{terms} ) {
	$startterm = 1;

	my $sth = $dbh->prepare("select max(endrptperiod) from subject");
	$sth->execute;
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
	$endterm = $sth->fetchrow;

    } else {

	( $startterm, $endterm ) = split(/-/, $arr{terms});
	$start = $dbh->quote( $startterm );
	$end = $dbh->quote( $endterm );
	$termSelect = "startrptperiod = $start and endrptperiod = $end";
    }

    my $globalSelect;
    if ( $teacherSelect ) {
	$globalSelect = $teacherSelect; 
    }
    if ( $gradeSelect ) {
	if ( $globalSelect ) { $globalSelect .= ' and '; }
	$globalSelect .= "( $gradeSelect )";
    }

    if ( $termSelect ) {
	if ( $globalSelect ) { $globalSelect .= ' and '; }
	$globalSelect .= "( $termSelect )";
    }

    print qq{<h3>$lex{Terms} $startterm - $endterm };
    if ( $arr{grade} ) { print qq{$lex{Grades} $arr{grade}\n}; }
    if ( $arr{teacher} ) { print qq{$lex{Teacher} $firstname $lastname ($arr{teacher})\n}; }
    print qq{</h3>\n};

    # print "Global Sel:$globalSelect<br>\n";
    # print "Grade Sel: $gradeSelect<br>\n";
    # print "Term Sel: $termSelect<br>\n";

    # replace term text with rptperiod.
    for my $i (1..3) {
	my $key = 'sort'. $i;
	if ( $arr{$key} eq 'term' ) {
	    $arr{$key} = 'startrptperiod, endrptperiod';
	}
    }


    if ( $globalSelect ) { $globalSelect = "where $globalSelect"; } # prepend where
    my $sth = $dbh->prepare("select * from subject $globalSelect
      order by $arr{sort1}, $arr{sort2}, $arr{sort3}");
    $sth->execute;
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}

    my $sth1 = $dbh->prepare("select distinct studnum from eval where subjcode = ?");
    my $sth2 = $dbh->prepare("select lastname, firstname from staff where userid = ?");
    my $sth3 = $dbh->prepare("select $markfield from eval where subjcode = ? and term = ? and studnum = ?");
    my $sth4 = $dbh->prepare("select lastname, firstname, provnum from studentall where studnum = ?");

    my $sth5 = $dbh->prepare("select count(*) from eval where subjcode = ?");
    my $sth6 = $dbh->prepare("select sum(creditsearned) from sasked_completedcourses where provnum = ?");
    my $sth7 = $dbh->prepare("select * from attend where studentid = ? and subjsec = ?");


    my %creditsearned;


    # Load previous year's data.
    my $ref = loadRemoteDB();
    my %data = %$ref;

    my %studdata;
    foreach my $year (sort keys %data ) {
	foreach my $subjsec ( keys %{ $data{$year} } ) {
	    foreach my $provnum ( keys %{ $data{$year}{$subjsec} } ) {
		$studdata{$provnum}{$subjsec}{$year} = $data{$year}{$subjsec}{$provnum};  # ie mark
	    }
	}
    }


#    use Data::Dumper;
#    print Dumper %studdata;


    # Course Loop
    my $first = 1;
    my ($prevcourse, $currcourse);
    while ( my $ref = $sth->fetchrow_hashref ) {
	my %r = %$ref;
	my $subjsec = $r{subjsec};

	# Check for enrollments, skip any with none.
	$sth5->execute( $subjsec );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
	my $ecount = $sth5->fetchrow;
	if ( not $ecount ) { next; }

	# Get Teacher Name
	$sth2->execute( $r{teacher} );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
	my ($lastname, $firstname) = $sth2->fetchrow;


	$prevcourse = $currcourse;
	$currcourse = $subjsec;

	if ( $first ) {
	    print qq{<table cellpadding="3" border="1" cellspacing="0">\n};
	    print qq{<caption style="font-size:120%;font-weight:bold;">$r{description} ($r{subjsec})<br>};
	    print qq{$firstname $lastname ($r{teacher})</caption>\n};
	    print qq{<tr><th>$lex{Student}<br>$lex{Name}</th><th>$lex{'Credits Earned'}</th><th>$lex{Absent}</th>};
	    print qq{<th title = "$lex{Attempts}">Prev<br>Att</th>};
	    for my $t ( $startterm..$endterm ) {
		print qq{<th>$lex{Term} $t<br>$lex{Mark} (%)</th>};
	    }
	    print qq{</tr>\n};
	    $first = 0;

	} else { # print a totals line for previous course.

	    my (%avg, %sdev);
	    foreach my $term ($startterm..$endterm ) {
		my @marks = values %{ $marks{$prevcourse}{$term} };
		if ( @marks ) {
		    $avg{$term} = round( mean( @marks ), 1);
		    $sdev{$term} = round ( stddev( @marks ), 1);
		}
	    }

	    print qq{<tr style="background-color:#DDD;"><td class="bra" colspan="4">$lex{Mean}</td>\n};
	    for my $term ( $startterm..$endterm ) {
		print qq{<td>$avg{$term}</td>};
	    }
	    print qq{</tr>\n</table><p></p>\n};


	    # Previous Years Marks
#	    foreach my $provnum ( sort keys %studdata ) {
#		foreach my $year ( sort keys %{ $studdata{$provnum}{$subjsec} } ) {
#		    print "<div>Provnum:$provnum Mark: $studdata{$provnum}{$subjsec}{$year}</div>\n";
#		}
#	    }


	    print qq{<table cellpadding="3" border="1" cellspacing="0">\n};
	    print qq{<caption style="font-size:120%;font-weight:bold;">$r{description} ($r{subjsec})<br>};
	    print qq{$firstname $lastname ($r{teacher})</caption>\n};

	    print qq{<tr><th>$lex{Student}<br>$lex{Name}</th><th>$lex{'Credits Earned'}</th><th>$lex{Absent}</th>};
	    print qq{<th title = "$lex{Attempts}">Prev<br>Att</th>};
	    for my $t ( $startterm..$endterm ) {
		print qq{<th>$lex{Term} $t<br>$lex{Mark} (%)</th>};
	    }
	    print qq{</tr>\n};

	}


	# Student Loop
	$sth1->execute( $r{subjsec} );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}

	my $enrolfirst = 1;
	while ( my $studnum = $sth1->fetchrow ) {

	    $enrolfirst = 0;

=head
	    # Check Enrollment days for this student
	    if ( not $studenrol{$studnum} ) { # populate for this student
		my $ref = calcMonthlyEnrollment( $studnum, $schoolstart, $currdate, $dbh );
		my $total;
		foreach my $ym ( sort keys %{ $ref } ) {
		    $total += $ref->{$ym}{days};
		}
		$studenrol{$studnum} = $total;
	    }
=cut

	    # Find absences for this course
	    $sth7->execute( $studnum, $subjsec );
	    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
	    my $absperiods = '0';
	    while ( my $ref = $sth7->fetchrow_hashref ) {
		if ( $ref->{reason} =~ m/Absent/ ) {  $absperiods++; }
	    }

#	    my $absdays;
#	    if ( $g_ppd{ $r{grade} } ) {
#		$absdays = $absperiods / $g_ppd{$r{grade}};
#	    }
#	    my $perattend;
#	    if ( $studenrol{$studnum} ) {
#		my $dayspresent = $studenrol{$studnum} - $absdays;
#		$perattend = round( $dayspresent / $studenrol{$studnum} * 100 , 1);
#	    }

#	    print qq{<div>SN:$studnum - PER:$absperiods ABS:$absdays ENROL:$studenrol{$studnum}</div>\n};


	    # Student Name
	    $sth4->execute( $studnum );
	    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
	    my ($lastname, $firstname, $provnum) = $sth4->fetchrow;

	    # Credits Earned.
	    if ( not $creditsearned{$subjsec}{$provnum} ) {
		$creditsearned{$subjsec}{$provnum}= '-';
		if ( $provnum ) {
		    $sth6->execute( $provnum );
		    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
		    $creditsearned{$subjsec}{$provnum} = $sth6->fetchrow;
		}
	    }

	    # check for previous attempts
	    my $attempts;
	    if ( $studdata{$provnum}{$subjsec} ) {
		foreach my $year ( %{ $studdata{$provnum}{$subjsec} } ) {
		    if ( $studdata{$provnum}{$subjsec}{$year} ) { $attempts++; }
		}
	    }
	 
	    print qq{<tr><td>$firstname $lastname ($studnum)</td><td>$creditsearned{$subjsec}{$provnum}</td>};
	    print qq{<td>$absperiods}. 'P</td>';
	    print qq{<td>$attempts</td>\n};



	    foreach my $term ( $startterm..$endterm ) {
       
		# Get the mark
		$sth3->execute( $subjsec, $term, $studnum );  # end term has final marks
		if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
		my $mark = $sth3->fetchrow;
		$mark =~ s/%//; # strip percent 
		print qq{<td>$mark</td>};

		# get mark ready for use in averages at bottom
		$mark =~ s/\D+|%//g;  # strip out percents or text.
		if ( not $mark ) { next; }
		if ( $mark =~ m/\d/) {
		    $marks{$subjsec}{$term}{$studnum} = $mark;
		}
	    } # end of terms loop

	    print qq{</tr>\n};

	} # end of Student Loop
    
    } # end of course loop


    if ( $first ) {
	print qq{<h3>$lex{Course} $lex{'Not Found'}</h3>\n};
    } else {
	print qq{</table>\n};
    }

    print qq{</body></html>\n};

} # end of showEnrollment.



#---------------
sub loadRemoteDB {  # load data from remote databases (previous years)
#---------------

    # Get remote databases
    my $remotedbase = 'information_schema';
    my $dsnr = "DBI:$dbtype:database=$remotedbase;host=$remotehost";
    my $dbhr = DBI->connect($dsnr,$remoteuser,$remotepassword);


    my $sth = $dbhr->prepare("select distinct table_schema from TABLES order by table_schema");
    $sth->execute;
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

    # Select Previous Databases for this school
    my %remotedb;
    while ( my $db = $sth->fetchrow ) {
	if ( $db eq 'mysql' or $db eq 'information_schema' ) { next; }

	if ( $db =~ m/$dbase/ ) {
	    $remotedb{$db} = 1;
	}
    }


    my %data; # complex data struct
    # loop through all databases compiling data.

    foreach my $remotedb ( keys %remotedb ) {

	my $year = substr($remotedb, -4); # final 4 characters for the year.

#	print "Remote DB:$remotedb  Year:$year<br>\n";

	# Load Remote database
	my $dsn = "DBI:$dbtype:database=$remotedb;host=$remotehost";
	my $dbhr = DBI->connect($dsn,$remoteuser,$remotepassword);

	my $sth1 = $dbhr->prepare("select endrptperiod, grade from subject where subjsec = ?");
	my $sth2 = $dbhr->prepare("select $markfield, studnum from eval where subjcode = ? and term = ?");
	my $sth3 = $dbhr->prepare("select provnum from studentall where studnum = ?");

	my $sth = $dbhr->prepare("select distinct subjcode from eval where subjcode is not NULL and subjcode != ''");
        $sth->execute;
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	while ( my $subjsec = $sth->fetchrow ) {

	    # Get end term, grade; skip if grade too low
	    $sth1->execute($subjsec);
	    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	    my ($endterm, $grade) = $sth1->fetchrow;
	    if ( $grade < 9 ) { next; }


	    # Get students and marks.
	    $sth2->execute($subjsec, $endterm);
	    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	    while ( my ( $mark, $studnum )  = $sth2->fetchrow ) {
		if ( not $mark ) { $mark = '-'; }


		# Get Provincial Number?
		$sth3->execute($studnum);
		if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
		my  $provnum = $sth3->fetchrow;
		if ( not $provnum ) { $provnum = 'S'. $studnum; }

		$data{$year}{$subjsec}{$provnum} = $mark;

	    }
	} # end of subject loop
    } # end of database loop

    return \%data

} # end of loadRemoteDB
	    


