#!/usr/bin/perl
#  Copyright 2001-2016 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Report' => 'Report',
	   'Teacher' => 'Teacher',
	   'Main' => 'Main',
	   'Report Card' => 'Report Card',
	   'Name' => 'Name',
	   'Subj-Sec' => 'Subj-Sec',
	   'Terms' => 'Terms',
	   'Not Found' => 'Not Found',
	   'Error' => 'Error',
	   'Subjects' => 'Subjects',
	   'Enrol' => 'Enrol',
	   'Course' => 'Course',
	   'Master' => 'Master',
	   'Grade' => 'Grade',
	   'Term' => 'Term',
	   'Periods' => 'Periods',
	   'Total' => 'Total',
	   
	   );

use DBI;
use CGI;
use Number::Format qw(:all);

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, 
    $iddst) = localtime(time);
$year = $year + 1900;
$mon++; $wday++;
my $currdate = "$dow[$wday], $month[$mon] $mday, $year";


my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


my $title = qq{$lex{Course} $lex{Master} $lex{Report} 1 - Courses by Teacher, Term};

print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};
print qq{$chartype\n</head><body style="padding:2em 4em;">\n};

print qq{[ <a href="$homepage">$lex{Main}</a> |\n};
print qq{<a href="$reppage">$lex{'Report Card'}</a> ]\n};

print qq{<h1>$title</h1>\n};


# Find the Distinct terms from the course enrollments (not masters)
my %terms;
my $sth = $dbh->prepare("select distinct term from eval");
$sth->execute;
if ($DBI::errstr){print $DBI::errstr; die $DBI::errstr; }
while ( my $trm = $sth->fetchrow ) {
    $terms{$trm} = 1;
}


# Get Distinct Teachers
my (%teacher, %tsort );
# Load 'Classroom Teacher' positions
my $sth = $dbh->prepare("select userid from staff_multi where 
    field_name = 'position' and field_value = 'Classroom Teacher'");
$sth->execute;
if ($DBI::errstr){print $DBI::errstr; die $DBI::errstr; }
while ( my $userid = $sth->fetchrow ) {
    $teacher{$userid} = 1;
}

# Load Teachers in Course Master
my $sth = $dbh->prepare("select distinct teacher from subject");
$sth->execute;
if ($DBI::errstr){print $DBI::errstr; die $DBI::errstr; }
while ( my $userid = $sth->fetchrow ) {
    $teacher{$userid} = 1;
}

# Get Names
my $sth = $dbh->prepare("select lastname, firstname from staff where userid = ?");
foreach my $userid ( keys %teacher ) {
    $sth->execute($userid);
    if ($DBI::errstr){print $DBI::errstr; die $DBI::errstr; }
    my ($lastname, $firstname) = $sth->fetchrow;
    $teacher{$userid} = qq{<b>$lastname</b>, $firstname};
    $tsort{"$lastname$firstname$userid"} = $userid;
}



# Find all the teachers teaching those classes. List each one for each term
my $sth1 = $dbh->prepare("select teacher, startrptperiod, endrptperiod, description, grade
   from subject where subjsec = ?");


my ( %courses, %termteacher );

my $sth = $dbh->prepare("select distinct subjcode from eval");
$sth->execute;
if ($DBI::errstr){print $DBI::errstr; die $DBI::errstr; }
while ( my $subjsec = $sth->fetchrow ) {
    
    # Find the teacher userid, and other course info
    $sth1->execute($subjsec);
    if ($DBI::errstr){print $DBI::errstr; die $DBI::errstr; }
    my $ref = $sth1->fetchrow_hashref;
    my %r = %$ref;
#    print qq{SUB:$subjsec User:$r{teacher} Desc:$r{description} Terms:$r{startrptperiod}- $r{endrptperiod}<br>\n};

    $courses{$subjsec} = $ref;
#    $termduration{ $r{startrptperiod} }{ $r{endrptperiod} }{$subjsec} = $r{teacher};
    foreach my $trm ( $r{startrptperiod}..$r{endrptperiod} ) {
	$termteacher{ $trm }{ $r{teacher} }{ $subjsec } = 1;
    }
    
}


# start table, print terms rows
print qq{<table border="1" cellspacing="0" cellpadding="3">\n};
print qq{<tr><th>$lex{Teacher}</th>\n};

foreach my $term ( sort {$a <=> $b} keys %terms ) { # numeric sort
    print qq{<th>$lex{Term} $term</th>};
}
print qq{</tr>\n};


my $rowcount = 1;
my %enrollment;



# loop through teachers, print courses per teacher, per term.
foreach my $key ( sort keys %tsort )  {  # row
    my $userid = $tsort{$key};
    
    print qq{<tr><td style="vertical-align:top;text-align:center;font-size:120%;">$teacher{$userid}</td>\n};

    foreach my $term ( sort {$a <=> $b} keys %terms ) { # numeric sort
	

	print qq{<td style="margin:0;padding:0;vertical-align:top;">};

	if ( %{ $termteacher{$term}{$userid} } ) {

	    print qq{<table border="0" cellspacing="0" cellpadding="3" style="margin:0;">\n};
	    print qq{<tr><th>$lex{Course}</th><th>$lex{Enrol}</th><th>$lex{Periods}</th></tr>\n};

    
	    # Set Sorting by description and grade.
	    my %sort;
	    foreach my $subjsec ( keys %{ $termteacher{$term}{$userid} } ) {
		$sort{"$courses{$subjsec}{description} $courses{$subjsec}{grade}"} = $subjsec;
	    }

	    my $coursecount;
	    foreach my $key ( sort keys %sort ) {
		my $subjsec = $sort{$key};

		# Get Enrollments, if not already stored.
		if ( not  $enrollment{$subjsec} ) {
		    $enrollment{$subjsec} = getEnrollment($subjsec, 
							  $courses{$subjsec}{startrptperiod},
							  $courses{$subjsec}{endrptperiod} );
		};

		print qq{<tr><td>$courses{$subjsec}{description}</td>};
		# print qq{<td>$teachername{ $courses{$subjsec}{teacher} }</td>\n};
		# print qq{<td>$courses{$subjsec}{startrptperiod}</td>};
		# print qq{<td>$courses{$subjsec}{endrptperiod}</td></tr>\n};
		print qq{<td>$enrollment{$subjsec}</td></tr>\n};
		$coursecount++;
	    }
	    print qq{<tr><td class="bla" colspan="3">$lex{Total} $coursecount</td></tr>\n};
	    print qq{</table>\n};
	    # End of this cell.
	    
	}
	
	print qq{</td>\n};
	
    }
    print qq{</tr>\n\n}; # end of this row.

    if ( $rowcount % 3 == 0 ) { # print a ident line.
	print qq{<tr><th>$lex{Teacher}</th>\n};
	foreach my $term ( sort {$a <=> $b} keys %terms ) { # numeric sort
	    print qq{<th>$lex{Term} $term</th>};
	}
	print qq{</tr>\n};
    }
    $rowcount++;

    
    
}

print qq{</table>\n};
print qq{</body></html>\n};

exit;



#----------------
sub getEnrollment {
#----------------
    
    my ($subjsec, $startterm, $endterm) = @_;
    
    # Get count of students enrolled in this subject.
    my $sth1 = $dbh->prepare("select count(*) from eval where subjcode = ? and term >= ? and term <= ?");
    $sth1->execute( $subjsec, $startterm, $endterm );
    if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }
    my $count = $sth1->fetchrow;

    my $terms = ($endterm - $startterm) + 1;
    if ($terms < 1) { $terms = 1; }
    my $enrollments = round( $count / $terms, 2);

    return $enrollments;

}

