#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('View' => 'View',
	   'Subject Enrollment' => 'Subject Enrollment',
	   'Report Card' => 'Report Card',
	   'Grades' => 'Grades',
	   'Withdrawn' => 'Withdrawn',
	   'Error' => 'Error',
	   'Continue' => 'Continue',
	   'Terms' => 'Terms',
	   'Separate with Spaces' => 'Separate with Spaces',
	   'Blank=All' => 'Blank=All',
	   'Teacher' => 'Teacher',
	   'Sort by' => 'Sort by',
	   'Term' => 'Term',
	   'Grade' => 'Grade',
	   'Description' => 'Description',
	   'Enrol' => 'Enrol',
	   'Main' => 'Main',

	   );

my $self = 'rptenrolgrade.pl';

use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $self: $@<br>\n";
    die $lex{Error}. " $self: $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);



# Print HTML Page Header
my $title = "$lex{View} $lex{'Subject Enrollment'}";

print qq{$doctype\n<html><head><title>$title</title>
<link rel="stylesheet" href="$css" type="text/css">
$chartype\n</head><body style="padding:1em 2em;">\n};
print qq{[ <a href="$homepage">$lex{Main}</a> | };
print qq{<a href="$reppage">$lex{'Report Card'}</a> ]\n};

print qq{<h1>$title</h1>\n};


if (not $arr{page} ) {
    showStartPage();
} else {
    delete $arr{page};
    showEnrollment();
}



#----------------
sub showStartPage {
#----------------

    # Find all of the term patterns.
    my $sth = $dbh->prepare("select distinct startrptperiod, endrptperiod from subject
     order by startrptperiod, endrptperiod");
    $sth->execute;
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }

    # Find Teachers
    my $sth1 = $dbh->prepare("select distinct s.teacher, st.lastname, st.firstname from subject s, staff st
     where s.teacher = st.userid order by st.lastname, st.firstname");
    $sth1->execute;
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }


    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};

    print qq{<table border="0" cellpadding="3" cellspacing="0">\n};

    # Grade Select
    print qq{<tr><td class="bla">$lex{Grades}</td>\n};
    print qq{<td class="la">};
    print qq{<input type="text" name="grade" size="10"> };
    print qq{$lex{'Separate with Spaces'}, $lex{'Blank=All'}</td></tr>\n};


    # Term Select
    print qq{<tr><td class="bla">$lex{Terms}</td><td>};
    while ( my ( $startterm, $endterm ) = $sth->fetchrow ) {
	    print qq{<input type="checkbox" name="$startterm-$endterm" value="1">\n};
	    print qq{$startterm-$endterm &nbsp;\n};
    }
    print qq{ $lex{'Blank=All'}</td></tr>\n};

    # Teacher Select
    print qq{<tr><td class="bla">$lex{Teacher}</td><td>};
    print qq{<select name="teacher"><option></option>\n};
    while ( my ( $userid, $lastname, $firstname ) = $sth1->fetchrow ) {
	print qq{<option value="$userid">$lastname, $firstname</option>\n};
    }
    print qq{</select></td></tr>\n};


    # Sorting Order
    my %sorttext = ('term' => "$lex{Term}", grade => "$lex{Grade}", teacher => "$lex{Teacher}",
		    description => "$lex{Description}");
    my @sort = qw (term grade teacher description);
    my $default1 = 'term';
    my $default2 = 'grade';
    my $default3 = 'description';

    print qq{<tr><td class="bla">$lex{'Sort by'}</td><td>};

    # Sort 1
    print qq{<select name="sort1"><option value="$default1">$sorttext{$default1}</option>\n};
    foreach my $val ( @sort ) {
	if ( $val eq $default1 ) { next; }
	print qq{<option value="$val">$sorttext{$val}</option>};
    }
    print qq{</select>&nbsp;&nbsp;\n};

    # Sort 2
    print qq{<select name="sort2"><option value="$default2">$sorttext{$default2}</option>\n};
    foreach my $val ( @sort ) {
	if ( $val eq $default2 ) { next; }
	print qq{<option value="$val">$sorttext{$val}</option>};
    }
    print qq{</select>&nbsp;&nbsp;\n};

    # Sort 3
    print qq{<select name="sort3"><option value="$default3">$sorttext{$default3}</option>\n};
    foreach my $val ( @sort ) {
	if ( $val eq $default3 ) { next; }
	print qq{<option value="$val">$sorttext{$val}</option>};
    }
    print qq{</select>&nbsp;\n};

    print qq{</td></tr>\n};



    print qq{<tr><td colspan="2" class="cn"><input type="submit" value="$lex{Continue}">\n};
    print qq{</td></tr>\n};

    print qq{</table></form></body></html>\n};

    exit;

}




#-----------------
sub showEnrollment {
#-----------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    # Grade Select
    my $gradeSelect;
    if ( $arr{grade} ) {
	my @grades = split(/ /, $arr{grade});
	my $first = 1;
	my $gs;
	foreach my $gr ( @grades ) {
	    $gr = $dbh->quote( $gr );
	    if ( not $first ) { $gs .= ' or '; } else { $first = 0; }
	    $gs .= "grade = $gr ";
	}
	$gradeSelect = $gs;
    }
    delete $arr{grade};


    # Teacher Select
    my $teacherSelect;
    if ( $arr{teacher} ) {
	my $tch = $dbh->quote( $arr{teacher} );
	$teacherSelect = "teacher = $tch";
    }
    delete $arr{teacher};


    # Term Select
    my $ts; # shorter
    my $first = 1;
    foreach my $val ( keys %arr ) { # search for term patterns
	if ( $val =~ m/\d\-\d/ ) { # we have a term pattern.
	    my ($start, $end ) = split(/-/, $val);
	    $start = $dbh->quote( $start );
	    $end = $dbh->quote( $end );
	    if ( not $first ) { $ts .= ' or '; } else { $first = 0; }
	    $ts .= "(startrptperiod = $start and endrptperiod = $end) ";
	}
    }
    my $termSelect;
    if ( $ts ) { $termSelect = $ts; }

    my $globalSelect;
    if ( $teacherSelect ) {
	$globalSelect = $teacherSelect; 
    }
    if ( $gradeSelect ) {
	if ( $globalSelect ) { $globalSelect .= ' and '; }
	$globalSelect .= "( $gradeSelect )";
    }

    if ( $termSelect ) {
	if ( $globalSelect ) { $globalSelect .= ' and '; }
	$globalSelect .= "( $termSelect )";
    }

    # print qq{Global Sel:$globalSelect<br>\n};
    # print qq{Grade Sel: $gradeSelect<br>\n};
    # print qq{Term Sel: $termSelect<br>\n};


    # replace term text with rptperiod.
    for my $i (1..3) {
	my $key = 'sort'. $i;
	if ( $arr{$key} eq 'term' ) {
	    $arr{$key} = 'startrptperiod, endrptperiod';
	}
    }


    if ( $globalSelect ) { $globalSelect = "where $globalSelect"; } # prepend where
    my $sth = $dbh->prepare("select * from subject $globalSelect
      order by $arr{sort1}, $arr{sort2}, $arr{sort3}");
    $sth->execute;
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}

    my $sth1 = $dbh->prepare("select count(distinct studnum) from eval where subjcode = ?");

    print qq{<table cellpadding="3" border="1" cellspacing="0">\n};
    print qq{<tr><th>$lex{Description}</th><th>$lex{Grade}</th><th>$lex{Terms}</th>};
    print qq{<th>$lex{Teacher}</th><th>$lex{Enrol}</th></tr>\n};

    while ( my $ref = $sth->fetchrow_hashref ) {

	$sth1->execute( $ref->{subjsec} );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}
	my $count = $sth1->fetchrow;

	print qq{<tr><td>$ref->{description} ($ref->{subjsec})</td>};
	print qq{<td>$ref->{grade}</td><td>$ref->{startrptperiod}-};
	print qq{$ref->{endrptperiod}</td><td>$ref->{teacher}</td><td>$count</td></tr>\n};
    }


    print qq{</table></body></html>\n};

} # end of showEnrollment.
