#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Subject Enrollment' => 'Subject Enrollment',
	   'Main' => 'Main',
	   'Report Card' => 'Report Card',
	   'Students' => 'Students',
	   'Error' => 'Error',
	   'Subjects' => 'Subjects',
	   'Enrolled' => 'Enrolled',
	   'Not' => 'Not',
	   'Grades' => 'Grades',
	   'Blank=All' => 'Blank=All',
	   'Separate with Spaces' => 'Separate with Spaces',
	   'Terms' => 'Terms',
	   'Sort by' => 'Sort by',
	   'Continue' => 'Continue',
	   'Grade' => 'Grade',
	   'Teacher' => 'Teacher',
	   'Description' => 'Description',
	   'Term' => 'Term',
	   'Show' => 'Show',
	   'Name' => 'Name',
	   'Withdrawn' => 'Withdrawn',

	   );

use DBI;
use CGI;

eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset ); 
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Print HTML Page Header
my $title = "$lex{Students} $lex{'Subject Enrollment'}";

print qq{$doctype\n<html><head><title>$title</title>
<link rel="stylesheet" href="$css" type="text/css">
$chartype\n</head><body>\n};

print qq{[ <a href="$homepage">$lex{Main}</a> |\n};
print qq{<a href="$reppage">$lex{'Report Card'}</a> ]\n};

print qq{<h1>$title</h1>\n};

if ( not $arr{page} ) {
    showStartPage();

} else {
    delete $arr{page};
    showEnrollments();
}



#----------------
sub showStartPage {
#----------------

    # Find all of the term patterns.
    my $sth = $dbh->prepare("select distinct startrptperiod, endrptperiod from subject
     order by startrptperiod, endrptperiod");
    $sth->execute;
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }

    # Find Grades
    my @grades = ();
    $sth2 = $dbh->prepare("select distinct grade from student where grade is not NULL and grade != ''");
    $sth2->execute;
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
    while ( my $gr = $sth2->fetchrow ) {
	push @grades, $gr;
    }
    @grades = sort { $a <=> $b } @grades;



    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};

    print qq{<table border="0" cellpadding="3" cellspacing="0">\n};

    # Grade Select
    print qq{<tr><td class="bra">$lex{Grades}</td>\n};
    print qq{<td class="la">};
    print qq{<select name="grade"><option></option>\n};
    foreach my $gr ( @grades ) {
	print qq{<option>$gr</option>};
    }
    print qq{</select> $lex{'Blank=All'}</td></tr>\n};

    # Term Select
    print qq{<tr><td class="bra">$lex{Terms}</td><td class="la">};
    print qq{<select name="term"><option></option>\n};
    while ( my ( $startterm, $endterm ) = $sth->fetchrow ) {
	    print qq{<option value="$startterm-$endterm">};
	    print qq{$startterm-$endterm</option>\n};
    }
    print qq{</select> $lex{'Blank=All'}</td></tr>\n};

    # Sort Order
    print qq{<tr><td class="bla">$lex{'Sort by'}</td><td>};
    print qq{<select name="sort"><option value="name">$lex{Name}</option>\n};
    print qq{<option value="grade">$lex{Grade}</option>\n};
    print qq{</select></td></tr>\n};

    # Continue
    print qq{<tr><td colspan="2" class="cn"><input type="submit" value="$lex{Continue}">\n};
    print qq{</td></tr>\n};

    print qq{</table></form></body></html>\n};

    exit;

}



#------------------
sub showEnrollments {
#------------------

    # foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }

    # Marker for withdrawn
    my $wdtext = qq{<span style="color:red;">$lex{Withdrawn}</span> };


    # Create Lists of Subjects, for checking against ones to show for a student.
    my @subjects = ();
    my %subjects = ();
    my $sth = $dbh->prepare("select subjsec, grade, description, 
      startrptperiod, endrptperiod from subject 
      order by description");
    $sth->execute;
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
    while ( my ( $subjsec, $grade, $desc, $sterm, $eterm ) = $sth->fetchrow ) {

	my $term = "$sterm-$eterm";
	if ( $arr{grade} and $gr ne $arr{grade} ) { next; }
	if ( $arr{term} and $gr ne $term ) { next; }

	$subjects{ $subjsec } = $desc;
    }


    # Loop through eval getting students enrollments
    my %evalstudnum = ();
    my $sth = $dbh->prepare("select distinct studnum from eval group by studnum");
    $sth->execute;
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
    while ( my $studnum = $sth->fetchrow ) {
	$evalstudnum{$studnum} = 1;
    }


    # Loop through students
    my $select;
    if ( $arr{grade} ) {
	$select = " where grade = ?";
    }

    my $sortorder = 'lastname, firstname';
    if ( not $arr{grade} and $arr{sort} eq 'grade' ) { # change sort order
	$sortorder = 'grade, lastname, firstname';
    }

    $sth = $dbh->prepare("select studnum, lastname, firstname, grade from studentall 
      $select order by $sortorder");
    if ( $select ) {
	$sth->execute( $arr{grade} );
    } else {
	$sth->execute;
    }
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }

    # Withdrawn ?
    my $sth1 = $dbh->prepare("select count(*) from studentwd where studnum = ?");

    # Get Subjects Enrolled, Get Subject Info
    my $sth2 = $dbh->prepare("select distinct subjcode from eval where studnum = ?");
    my $sth3 = $dbh->prepare("select description, startrptperiod, endrptperiod from subject where subjsec = ?");
    my $sth4 = $dbh->prepare("select term from eval where studnum = ? and subjcode = ? order by term ");

    print qq{<table border="1" cellpadding="3" cellspacing="0">\n};


    while ( my ( $studnum, $lastname, $firstname, $grade ) = $sth->fetchrow ) {

	# Check if withdrawn
	$sth1->execute( $studnum );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	my $withdrawn = $sth1->fetchrow;

	# Skip if No enrollments and withdrawn
	if ( not $evalstudnum{$studnum} and $withdrawn ) { 
	    next;
	}

	my $wd;
	if ( $withdrawn ) { $wd = $wdtext; }

	# print name
	print qq{<tr><td class="la"><b>$lastname</b>, $firstname ($studnum) $wd</td><td class="cn">$grade</td>\n};
	print qq{<td class="la">};

	# Get Subjects
	$sth2->execute( $studnum );
	if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }

	while ( my $subjsec = $sth2->fetchrow ) {

	    # Get Name
	    $sth3->execute( $subjsec);
	    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	    my ($desc,$sterm,$eterm) = $sth3->fetchrow;

	    # Skip if term select doesn't match
	    if ( $arr{term} and $arr{term} ne "$sterm-$eterm" ) { next; }

	    print qq{$desc ($subjsec) - $lex{Terms}:};

	    # Get Terms
	    $sth4->execute( $studnum, $subjsec);
	    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
	    while ( my $trm = $sth4->fetchrow ) {
		print qq{$trm };
	    }
	    print qq{<br>\n};

	}

	print qq{</td></tr>\n};



    }

    print qq{</table>\n};

    print qq{</body></html>\n};

    exit;
}

