#! /usr/bin/perl
#  Copyright 2001-2023 Leslie Richardson

#  This file is part of Open Admin for Schools.

# Report student final marks - 1 page per student.

my %lex = ('Cumulative' => 'Cumulative',
	   'Mark Report' => 'Mark Report',
	   'Main' => 'Main',
	   'View Log File' => 'View Log File',
	   'View/Download' => 'View/Download',
	   'School Year' => 'School Year',
	   'Grade' => 'Grade',
	   'Homeroom' => 'Homeroom',
	   'Report Card' => 'Report Card',
	   'Error' => 'Error',
	   'A4' => 'A4',
	   'Letter' => 'Letter',
	   'Legal' => 'Legal',
	   'Continue' => 'Continue',
	   'Paper Size' => 'Paper Size',
	   'Select by' => 'Select by',
	   'Sort by' => 'Sort by',
	   'Blank=All' => 'Blank=All',
	   'Name' => 'Name',
	   'Withdrawn Students' => 'Withdrawn Students',
	   'Show' => 'Show',

	   );

my $self = 'rptfinalstud.pl';


use DBI;
use CGI;

# Read config variables
eval require "../../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

eval require "../../lib/liblatex.pl";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

my $q = new CGI;
my %arr = $q->Vars;
print $q->header( -charset, $charset );


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);



# Load the SupressSubject, AdditionalComments, MarkField data
$sth = $dbh->prepare("select datavalue from conf_system
		     where dataname = ?");
foreach my $val ( qw(r_SupressSubject r_MarkField r_AdditionalComments )) {
    $sth->execute( $val );
    if ( $DBI::errstr ){ print $DBI::errstr; die $DBI::errstr; }
    my $dv = $sth->fetchrow;
    eval $dv;
}



my ($sec, $min, $hour, $mday, $mon, $year, $wday, 
 $yday, $iddst) = localtime(time);
$year = $year + 1900;
$mon++; $wday++;
my $currdate = "$dow[$wday], $month[$mon] $mday, $year";


my $title = "$lex{Cumulative} $lex{'Mark Report'}";

print qq{$doctype\n<html><head><title>$title</title>
<link rel="stylesheet" href="$css" type="text/css">
$chartype\n</head><body>\n};

print qq{[ <a href="$homepage">$lex{Main}</a> |\n};
print qq{<a href="$reppage">$lex{'Report Card'}</a> ]\n};

print qq{<h1>$title</h1>\n};

if ( not $arr{page} ) {
    showStartPage();
} 


my $logfile = "pdflog$$.txt";
my $shortname = "studfnlmark$$";
my $fileName = "$shortname.tex";

open(TEX,">$fileName") || die "Can't open tex file";


#foreach my $key (keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }
my $table = 'student';
if ( $arr{showwithdrawn} ) {
    $table = 'studentall';
}


# Group and Group_value
my $selection;
my $group_value;
if ( $arr{group_value} ) {
    $group_value = $arr{group_value};
    my $group;
    if ( $arr{group} eq 'grade' ) {
	$group = 'grade';
    } else {
	$group = 'homeroom';
    }
    $selection = "where $group = ?";
}


# Sorting Order
my $sortorder;
if ( $arr{sortorder} eq 'grade' ) {
    $sortorder = 'order by grade, lastname, firstname';

} elsif ( $arr{sortorder} eq 'homeroom' ) {
    $sortorder = 'order by homeroom, lastname, firstname';

} else {
    $sortorder = 'order by lastname, firstname';
}

# Set paper size.
my ( $papersize, $textheight, $textwidth );

if ( $arr{papersize} eq 'letter' ) {
    $papersize = 'letterpaper';
    $textwidth = $g_letterpaper_textwidth;
    $textheight = $g_letterpaper_textheight;

} elsif ( $arr{papersize} eq 'legal' ) {
    $papersize = 'legalpaper';
    $textwidth = $g_legalpaper_textwidth;
    $textheight = $g_legalpaper_textheight;

} elsif ( $arr{papersize} eq 'a4' ) {
    $papersize = 'a4paper';
    $textwidth = $g_a4paper_textwidth;
    $textheight = $g_a4paper_textheight;
}



print TEX "\\documentclass[12pt,$papersize]{article}
\\usepackage{array, inputenc}
%\\usepackage[bookmarks=false,pdfstartview=FitH]{hyperref}
$a_latex_header
\\renewcommand{\\familydefault}{\\sfdefault}
\\setlength{\\textwidth}{$textwidth}
\\setlength{\\textheight}{$textheight}
\\setlength{\\hoffset}{-25mm}
\\setlength{\\voffset}{-12.7mm}
\\setlength{\\topmargin}{0in}
\\setlength{\\extrarowheight}{4pt}
\\addtolength{\\evensidemargin}{0in}
\\addtolength{\\oddsidemargin}{0in}";

print TEX "\\begin{document}\n\\pagestyle{empty}\n";
print TEX "\\begin{center}\n";


my $sth = $dbh->prepare("select studnum,lastname, firstname, grade 
  from $table $selection $sortorder");

#print qq{Table: $table  Select: $selection  Order: $sortorder Group: $group - $group_value<br>\n};

if ( $selection ) { # if we have any kind of selection statement.
    $sth->execute( $group_value );
} else {
    $sth->execute;
}
if ($DBI::errstr) { print $DBI::errstr; die $DBI::errstr; }

# Loop through each student
while ( my ( $studnum, $lastname, $firstname, $grade ) = $sth->fetchrow ) {

    print TEX "{\\LARGE $lex{Cumulative} $lex{'Mark Report'} }\n\n\\medskip\n\n";
    print TEX "{\\Large $schoolname}\n\n";
    print TEX "{$schoolyear} $lex{'School Year'}\n\n";
    print TEX "$currdate\n\n\\bigskip\n\n";

    print TEX "{\\Large\\it $firstname $lastname ($studnum)}\n\n";
    print TEX $lex{Grade}. ": $grade\n\n\\bigskip";
    print TEX "\n\\begin{tabular}{|l|l|}\\hline\n\n";

    # Loop through their subjects.
    $sth1 = $dbh->prepare("select distinct eval.subjcode, subject.description, 
       subject.endrptperiod from eval 
       left outer join subject on eval.subjcode = subject.subjsec
       where studnum = ? 
       order by subject.description");
    $sth1->execute($studnum);
    if ($DBI::errstr) {print $DBI::errstr; die $DBI::errstr; }


    while ( my ( $subjcode, $description, $term) = $sth1->fetchrow ){

	# Skip if supress or AdditionalComment subjects
	my ($tsubjcode, $dud) = split(/-/, $subjcode);
	if ( $r_SupressSubject{ $tsubjcode } or $r_SupressSubject{ $subjcode } or
	     $r_AdditionalComments{ $tsubjcode } or $r_AdditionalComments{ $subjcode } ) { 
	    next; 
	}

	($description) = latex_filter($description);

	$sth2 = $dbh->prepare("select $r_MarkField from eval where 
          eval.term = ? and studnum = ? and subjcode = ?");
	$sth2->execute( $term, $studnum, $subjcode );
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	my $mark = $sth2->fetchrow;
	$mark =~ s/%//;

	# Now print the record     
	print TEX  "$description ($subjcode) & $mark \\\\ \\hline\n";
    }

    print TEX "\\end{tabular}\n\\newpage\n";

}  # End of Student loop

print TEX "\\end{center}\\end{document}";
close TEX;

system("$pdflatex $fileName > $logfile");
system("mv $shortname.pdf $downloaddir");
system("mv $logfile $downloaddir");
system("rm -f $shortname.*");

print qq{<h1><a href="$webdownloaddir/$shortname.pdf">};
print qq{$lex{'View/Download'} $lex{Cumulative} $lex{'Mark Report'}</a></h1>\n};

print qq{[ <a href="$homepage">$lex{Main}</a> |\n};
print qq{<a href="$webdownloaddir/$logfile">$lex{'View Log File'}</a> ]\n};
print qq{</body></html>\n};



#----------------
sub showStartPage {
#----------------

    print qq{<div><form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};

    print qq{<table cellpadding="3" cellspacing="0" border="0">\n};

    # Select Option
    print qq{<tr><td class="bra">$lex{'Select by'}</td>\n};
    print qq{<td><select name="group"><option value="grade">$lex{Grade}</option>\n};
    print qq{<option value="homeroom">$lex{Homeroom}</option>\n};
    print qq{</select>\n};
    print qq{<input type="text" name="group_value" size="10"> };
    print qq{$lex{'Blank=All'}</td></tr>\n};


    # Sort Option
    print qq{<tr><td class="bra">$lex{'Sort by'}</td>\n};
    print qq{<td><select name="sortorder"><option value="grade">$lex{Grade}</option>\n};
    print qq{<option value="homeroom">$lex{Homeroom}</option>};
    print qq{<option value="name">$lex{Name}</option>\n};
    print qq{</select></td></tr>\n};


    # Paper Size
    print qq{<tr><td class="bra">$lex{'Paper Size'}</td>\n};
    print qq{<td><select name="papersize"><option value="letter">$lex{Letter}</option>\n};
    print qq{<option value="legal">$lex{Legal}</option><option value="a4">$lex{A4}</option>};
    print qq{</select></td></tr>\n};


    # Include Withdrawn
    print qq{<tr><td class="bra">$lex{Show} $lex{'Withdrawn Students'}</td>\n};
    print qq{<td><input type="checkbox" name="showwithdrawn" value="1">\n};
    print qq{</td></tr>\n};

    
    print qq{<tr><td></td><td align="left">\n};
    print qq{<input type="submit" value="$lex{Continue}"></td></tr>\n};

    print qq{</table></form></div>\n};
    print qq{</body></html>\n};

    exit;

}
