#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Billet Report' => 'Billet Report',
	   'Main' => 'Main',
	   'Student' => 'Student',
	   'Billet' => 'Billet',
	   'Name' => 'Name',
	   'Room' => 'Room',
	   'Error' => 'Error',
	   'Group by' => 'Group by',
	   'Homeroom' => 'Homeroom',
	   'School' => 'School',
	   'Grade' => 'Grade',
	   'Continue' => 'Continue',
	   'Select' => 'Select',
	   'Blank=All' => 'Blank=All',
	   'No Records Found' => 'No Records Found',

	   );

my $self = 'rptbillet.pl';

use DBI;
use CGI;
use Cwd;


# Read config variables
eval require "../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}

my $q = new CGI;
my %arr = $q->Vars;
print $q->header( -charset, $charset );


my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, 
 $iddst) = localtime(time);
$year += 1900;
$mon++;
$wday++;
my $currdate = "$dow[$wday], $month[$mon] $mday, $year";


# Get current dir so know what CSS to display;
if ( getcwd() =~ /tcgi/ ){ # we are in tcgi
    $css = $tchcss;
    $homepage = $tchpage;
}

# print table head
my $title = $lex{'Billet Report'};
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};
print qq{$chartype\n</head>\n};
print qq{<body><a name="top"></a>\n};
print qq{[ <a href="$homepage">$lex{Main}</a> ]\n};
print qq{<h1>$title</h1><h3>$currdate</h3>\n};

if ( not $arr{page} ) {
    showStartPage();
} 


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


my $select;
if ( $arr{select} ) { # we have a selection
    if ( $arr{mode} eq 'homeroom' ) {
	my $grp = $dbh->quote( $arr{select} );
	$select = "where homeroom = $grp";
    } elsif ( $arr{mode} eq 'grade' ) {
	my $grp = $dbh->quote( $arr{select} );
	$select = "where grade = $grp";
    }
}

my $sortorder;
my $grp;
my $title;
if ( $arr{mode} eq 'homeroom' ) {
    $sortorder = "homeroom, lastname, firstname";
    $grp = 'homeroom';
    $title = $lex{Homeroom};
} elsif ( $arr{mode} eq 'grade' ) {
    $sortorder = "grade, lastname, firstname";
    $grp = 'grade';
    $title = $lex{Grade};
} else {
    $sortorder = "lastname, firstname";
    $grp = 'grade';
    $title = $lex{Grade};
}


$sth = $dbh->prepare("select lastname, firstname, initial, $grp, billet 
 from student $select order by $sortorder");
$sth->execute;
if ( $DBI::errstr ) {print $DBI::errstr; die $DBI::errstr; }
my $rows = $sth->rows;

if ( $rows < 1 ) {
    print qq{<h3>$lex{'No Records Found'}</h3>\n};
    print qq{</body><html>\n};
    exit;
}
#print qq{Rows: $rows<br>\n};

my $oldgroup;
my $currgroup = -1;
my $first = 1;

while ( my ( $lastname, $firstname, $initial, $group, $billet ) = $sth->fetchrow ) {

    $oldgroup = $currgroup;
    $currgroup = $group;
    if ( $currgroup ne $oldgroup ) {
	if ( not $first ) { print qq{</table><p></p>\n}; } else { $first = 0; }
	print qq{<h3>$title $currgroup</h3>\n};
	print qq{<table cellpadding="3" cellspacing="0" border="1">\n};
	print qq{<tr><th>$lex{Student}</th><th>$lex{Billet}</th></tr>\n};
    }

    print qq{<tr><td><b>$lastname</b>, $firstname</td><td>$billet</td></tr>\n};

}

print qq{</table>\n};
print qq{[ <a href="#top">Top</a> ]</body></html>\n};



#----------------
sub showStartPage {
#----------------

    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};

    print qq{<p><b>$lex{'Group by'}</b><br>\n};
    print qq{$lex{Homeroom} <input type="radio" name="mode" value="homeroom">\n};
    print qq{$lex{Grade} <input type="radio" name="mode" value="grade">\n};
    print qq{Entire $lex{School} <input type="radio" name="mode" value="school"></p>\n};

    print qq{<div><b>$lex{Select} Grade/Homeroom</b> \n};
    print qq{<input type="text" name="select" style="width:6ch;"> $lex{'Blank=All'}</div>\n};

    print qq{<p><input type="submit" value="$lex{Continue}"></p></form>\n};

    print qq{</body></html>\n};

    exit;
}
