#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Birthday' => 'Birthday',
	   'Report' => 'Report',
	   'Main' => 'Main',
	   'Month' => 'Month',
	   'Day' => 'Day',
	   'Name' => 'Name',
	   'Birthdate' => 'Birthdate',
	   'Error' => 'Error',
	   'Group by' => 'Group by',
	   'Homeroom' => 'Homeroom',
	   'School' => 'School',
	   'Grade' => 'Grade',
	   'Continue' => 'Continue',
	   'Select' => 'Select',
	   'Blank=All' => 'Blank=All',
	   'No Records Found' => 'No Records Found',
	   'Grade' => 'Grade',

	   );

my $self = 'rptbirthday.pl';

use DBI;
use CGI;
use Cwd;


my $q = new CGI;
my %arr = $q->Vars;
print $q->header( -charset, $charset );

# Read config variables
eval require "../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. " $@<br>\n";
    die $lex{Error}. " $@\n";
}


my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, 
 $iddst) = localtime(time);
$year += 1900;
$mon++;
$wday++;
my $currdate = "$dow[$wday], $month[$mon] $mday, $year";


# Get current dir so know what CSS to display;
if ( getcwd() =~ /tcgi/ ){ # we are in tcgi
    $css = $tchcss;
    $homepage = $tchpage;
}

# print table head
my $title = qq{$lex{Birthday} $lex{Report}};
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};
print qq{$chartype\n</head><body><a name="top"></a>\n};
print qq{[ <a href="$homepage">$lex{Main}</a> ]\n};
print qq{<h1>$title</h1>\n};


if ( not $arr{page} ) {
    showStartPage();
    
} else {
    delete $arr{page};
}
 
   
# foreach my $key ( sort keys %arr ) { print qq{K:$key V:$arr{$key}<br>\n}; }


my ($grp, $select, $sortorder);
if ( $arr{grade} ) {
    $grp = $dbh->quote( $arr{grade} );
    $select = "where grade = $grp";
    $sortorder = "grade, lastname, firstname";
    
} elsif ( $arr{homeroom} ) {
    $grp = $dbh->quote( $arr{homeroom} );
    $select = "where homeroom = $grp";
    $sortorder = "homeroom, lastname, firstname";
    
} else {  # all school, no $select value
    $sortorder = "lastname, firstname";
    $grp = "grade";
}

my $sth = $dbh->prepare("select lastname, firstname, initial, $grp, birthdate, grade, homeroom 
 from student $select order by $sortorder");
$sth->execute;
if ( $DBI::errstr ) {print $DBI::errstr; die $DBI::errstr; }


my (%records, @records);

my $first = 1;
while ( my ( $lastname, $firstname, $initial, $group, $birthdate, $grade, $homeroom
	) = $sth->fetchrow ) {
    $first = 0;

    # if no grade / homeroom value...
    if ( not $group ) { $group = 0; }
    if ( $arr{schoolmode} ) { $group = ''; } # puts them all together!

    my ($yr,$mon,$day) = split '-', $birthdate;

    if ( @{$records{$group}}) {
	push @{$records{$group}}, "$mon$day:$lastname, $firstname $initial:$birthdate:$grade:$homeroom";
    } else {
	$records{$group} = [ "$mon$day:$lastname, $firstname $initial:$birthdate:$grade:$homeroom" ];
    }


} # End of loop

if ( $first ) {
    print qq{<h3>$lex{'No Records Found'}</h3>\n};
    print qq{</body><html>\n};
    exit;
}


# Print Records Now.
foreach my $ref ( sort  {$a <=> $b} keys %records ) { 
    prTable( $ref, @{ $records{$ref} } );
}

print qq{[ <a href="#top">Top</a> ]</body></html>\n};


#----------
sub prTable { # print table and then a space.
#----------

    my ($group, @records) = @_;

    if ( $arr{grade} ) {
	print qq{<p><b>$lex{Grade} $group</b>\n};

    } elsif ( $arr{homeroom} ) {
	print qq{<p><b>$lex{Homeroom} $group</b>\n};

    } elsif ( $arr{schoolmode} ) {
	print qq{<p><b>Entire School</b>\n};
	
    } else { # school Mode
	print qq{<h3>$lex{Grade} $group</h3>\n};
    }

    print qq{<table border="1" cellpadding="3" cellspacing="0" };
    print qq{style="margin-bottom:1em;page-break-after:always;">\n};
    print qq{<tr><th>$lex{Month}</th><th>$lex{Day}</th><th>$lex{Name}</th>\n};
    print qq{<th>$lex{Birthdate}</th><th>$lex{Grade}</th><th>$lex{Homeroom}</th></tr>\n};

    for my $rec (sort @records) {
	my ($blank,$name,$bday, $grade, $homeroom) = split ':', $rec;
	my ($yr,$mon,$day) = split '-', $bday;
	print qq{<tr><td class="ra">$month[$mon]</td>\n};
	print qq{<td>$day</td><td>$name</td><td>$bday</td><td class="cn">$grade</td>};
	print qq{<td class="cn">$homeroom</td></tr>\n};
    }

    print qq{</table>\n};

}


#----------------
sub showStartPage {
#----------------

    my @homerooms;
    my $sth = $dbh->prepare("select distinct homeroom from student 
			    where homeroom is not NULL and homeroom != ''");
    $sth->execute;
    if ( $DBI::errstr ) {print $DBI::errstr; die $DBI::errstr; }
    while ( my $hr = $sth->fetchrow ) {
	push @homerooms, $hr;
    }
    @homerooms = sort {$a <=> $b} @homerooms;
    
    my @grades;
    my $sth = $dbh->prepare("select distinct grade from student 
			    where grade is not NULL and grade != ''");
    $sth->execute;
    if ( $DBI::errstr ) {print $DBI::errstr; die $DBI::errstr; }
    while ( my $gr = $sth->fetchrow ) {
	push @grades, $gr;
    }
    @grades = sort {$a <=> $b} @grades;
    
    
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};

    #  Group by School
    print qq{<p style="font-weight:bold;">};
    print qq{<input type="checkbox" name="schoolmode" value="1"> $lex{'Group by'} $lex{School}</p>\n};

    # Homeroom
    print qq{<div style="float:left;margin:1em;border:1px solid gray;padding:0.4em;">};
    print qq{<span style="font-weight:bold;font-size:120%;background-color:#CCC;padding:0.2em;">};
    print qq{$lex{Select} $lex{Homeroom}</span>\n};
    foreach my $hr (@homerooms) {
	print qq{<div><input type="radio" name="homeroom" value="$hr">$hr</div>};
    }
    print qq{</div>\n};
    print qq{<div style="float:left;">OR</div>\n\n};

    # Grades
    print qq{<div style="float:left;margin:1em;border:1px solid gray;padding:0.4em;">};
    print qq{<span style="font-weight:bold;font-size:120%;background-color:#CCC;padding:0.2em;">};
    print qq{$lex{Select} $lex{Grade}</span>\n};
    foreach my $gr (@grades) {
	print qq{<div><input type="radio" name="grade" value="$gr">$gr</div>};
    }
    print qq{</div>\n\n};

    print qq{<div style="float:left;">OR</div>\n\n};

    print qq{<div style="float:left;margin:1em;border:1px solid gray;padding:0.4em;font-weight:bold;">};
    print qq{$lex{'Blank=All'}</div>\n};
    
    print qq{<br clear="left">\n};
    
    print qq{<p><input type="submit" value="$lex{Continue}"></p></form>\n};

    print qq{</body></html>\n};

    exit;
}

