#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my %lex = ('Enrollment Summary' => 'Enrollment Summary',
	   'Main' => 'Main',
	   'Room' => 'Room',
	   'Teacher' => 'Teacher',
	   'Grade' => 'Grade',
	   'Male' => 'Male',
	   'Female' => 'Female',
	   'HRm' => 'HRm',
	   'Total' => 'Total',
	   'Gr' => 'Gr',
	   'Totals' => 'Totals',
	   'Error' => 'Error',

	   );

my $self = 'rptenrolhroom.pl';

use DBI;
use CGI;

eval require "../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}


my ($sec, $min, $hour, $mday, $mon, $year, $wday, 
 $yday, $iddst) = localtime(time);
$year = $year + 1900;
$mon++;
$wday++;
my $currdate = "$dow[$wday], $month[$mon] $mday, $year";

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Get the Grades
my %grades;
my $sth = $dbh->prepare("select distinct grade from student 
  where grade is not NULL and grade != ''");
$sth->execute;
if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
while ( my $grade = $sth->fetchrow ) {
    $grades{$grade} = 1;
}
my @grades = ( sort { $a <=> $b } keys %grades );
# foreach my $gr ( @grades ) { print "G:$gr<br>\n"; }


$sth = $dbh->prepare("select homeroom, grade, sex from student where grade = ?
		     order by homeroom, lastname,firstname");

my $title = qq{$schoolname $lex{'Enrollment Summary'}};
print qq{$doctype\n<html><head><title>$title</title>
<link rel="stylesheet" href="$css" type="text/css">
$chartype\n</head><body>\n};
print qq{[ <a href="$homepage">$lex{Main}</a> ]\n};
print qq{<h1>$title</h1><h4>$currdate</h4>\n};

print qq{<table border="1" cellpadding="3" cellspacing="0">\n};
print qq{<tr><th>$lex{Room} - $lex{Teacher}</th>\n<th>};

print qq{$lex{Grade}</th><th>$lex{Male}</th><th>$lex{Female}</th>\n};
print qq{</th><th>$lex{HRm} $lex{Total}</th><th>$lex{Gr} $lex{Total}</th></tr>\n};

my $boytotal = 0;
my $girltotal = 0;
my $boycount = 0;
my $girlcount = 0;
my $boygrade = 0;
my $girlgrade = 0;

my $curroom = -1; $currgrade = -1;
my $first = 1;

foreach my $grade ( @grades ) {

    $sth->execute( $grade );
    if ($DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

    while ( my ( $hroom, $gr, $sex ) = $sth->fetchrow ) {
   
	$oldroom = $curroom;
	$oldgrade = $currgrade;
	$curroom = $hroom;
	$currgrade = $gr;

	if (($oldroom ne $curroom and not $first ) or
	    ( $oldroom eq $curroom and $oldgrade ne $currgrade and not $first )) { 
	    # we have a new room (or same room but different grade)
	    $hrtotal = $boycount + $girlcount;

	    my (%teacher, %sort);
	    my ($sal, $firstname, $lastname);
	    if ( $oldroom ){  # If oldroom present, find it's teacher.
		my $sth1 = $dbh->prepare("select sal, firstname, lastname, s.userid
                  from staff as s, staff_multi as sm 
                  where s.userid = sm.userid and sm.field_name = ? and sm.field_value = ?");
		$sth1->execute( 'homeroom', $oldroom );
		if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
		while ( my ($sal, $firstname, $lastname, $userid) = $sth1->fetchrow ) {
		    $teacher{$userid} = qq{$sal $firstname $lastname};
		    $sort{"$lastname$firstname$userid"} = $userid;
		}
	    }

	    # Print out teacher name, totals for this room and then reset the variables.
	    print qq{<tr><td class="la">$oldroom - };
	    foreach my $key ( sort keys %sort ) {
		my $userid = $sort{$key};
		print qq{$teacher{$userid}<br>\n};
	    }
	    qq{</td>\n};
	    print qq{<td>$oldgrade</td><td>$boycount</td>\n};
	    print qq{<td>$girlcount</td><td>$hrtotal</td><td></td></tr>\n};

	    $girlcount = 0;
	    $boycount = 0;
	}
    
	if ( $oldgrade ne $currgrade and not $first ) { # we have a new grade also
	    $grtotal = $boygrade + $girlgrade;
	    print qq{<tr class="gray"><td></td><td>$oldgrade</td>\n};
	    print qq{<td><b>$boygrade</b></td><td><b>$girlgrade</b></td><td></td>\n};
	    print qq{<td><b>$grtotal</b></td></tr>\n};

	    $girlgrade = 0;
	    $boygrade = 0;
	}

	$first = 0;

	if ( "\U$sex" eq "F") {
	    $girlcount++;
	    $girltotal++;
	    $girlgrade++;
	} else {
	    $boycount++;
	    $boytotal++;
	    $boygrade++;
	}

    } # End of Main Loop
}

my $total = $boycount + $girlcount;

if ( $curroom ) { # the last room left.

    my (%teacher, %sort);
    my $sth1 = $dbh->prepare("select sal, firstname, lastname, s.userid from staff as s, staff_multi as sm 
			     where s.userid = sm.userid and sm.field_name = ? and sm.field_value = ?");
    $sth1->execute('homeroom', $curroom );
    if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr; }
    while ( my ($sal, $firstname, $lastname, $userid) = $sth1->fetchrow ) {
	$teacher{$userid} = qq{$sal $firstname $lastname};
	$sort{"$lastname$firstname$userid"} = $userid;
    }

    
    # Print out teacher name, totals for this room and then reset the variables.
    print qq{<tr><td class="la">$curroom - };
    foreach my $key ( sort keys %sort ) {
	my $userid = $sort{$key};
	print qq{$teacher{$userid}<br>\n};
    }
    qq{</td>\n};

    print qq{<td>$currgrade</td><td>$boycount</td>\n};
    print qq{<td>$girlcount</td><td>$total</td><td></td></tr>\n};
}

my $grtotal = $boygrade + $girlgrade;
print qq{<tr class="gray"><td></td><td>$currgrade</td><td><b>$boygrade</b></td>\n};
print qq{<td><b>$girlgrade</b></td><td></td><td><b>$grtotal</b></td></tr>\n};

my $grandtotal = $boytotal + $girltotal;
print qq{<tr class="blue"><td colspan=2 class="bcn">$lex{Totals}</td>};
print qq{<td class="bcn">$boytotal</td><td class="bcn">$girltotal</td>\n};
print qq{<td></td><td class="bcn">$grandtotal</td></tr>\n};
print qq{</table></body></html>\n};


