#!/usr/bin/perl
#  Copyright 2001-2024 Leslie Richardson

#  This file is part of Open Admin for Schools.

#  Open Admin for Schools is free software; you can redistribute it 
#  and/or modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2 of 
#  the License, or (at your option) any later version.

my  %lex = ('Phone' => 'Phone',
	    'Report' => 'Report',
	    'Student' => 'Student',
	    'Main' => 'Main',
	    'Emergency' => 'Emergency',
	    'Parent 1' => 'Parent 1',
	    'Parent 2' => 'Parent 2',
	    'Student' => 'Student',
	    'Emergency' => 'Emergency',
	    'HRm' => 'HRm',
	    'Gr' => 'Gr',
	    'Work' => 'Work',
	    'Home' => 'Home',
	    'Cell' => 'Cell',
	    'Error' => 'Error',
	    'Blank=All' => 'Blank=All',
	    'Select by' => 'Select by',
	    'Continue' => 'Continue',
	    'Grade' => 'Grade',
	    'Homeroom' => 'Homeroom',
	    'Name' => 'Name',
	    'Group' => 'Group',
	    'Sort by' => 'Sort by',
	    );

use DBI;
use CGI;
use Cwd;

eval require "../etc/admin.conf";
if ( $@ ) {
    print $lex{Error}. ": $@<br>\n";
    die $lex{Error}. ": $@\n";
}

my $q = new CGI;
print $q->header( -charset, $charset );
my %arr = $q->Vars;

my $dsn = "DBI:$dbtype:dbname=$dbase";
my $dbh = DBI->connect($dsn,$user,$password);


# Get current dir so know what CSS to display;
if ( getcwd() =~ /tcgi/ ){ # we are in tcgi
    $css = $tchcss;
    $homepage = $tchpage;
}


my $title = qq{$lex{Phone} $lex{Report}};
print qq{$doctype\n<html><head><title>$title</title>\n};
print qq{<link rel="stylesheet" href="$css" type="text/css">\n};
print qq{$chartype\n</head><body style="margin:1em;">\n};

print qq{[ <a href="$homepage">$lex{Main}</a> ]\n};
print qq{<h1>$title</h1>\n};


if ( not $arr{page} ) {
    showStartPage();
} else {
    delete $arr{page};
}

# foreach my $key ( sort keys %arr ) { print "K:$key VAL:$arr{$key}<br>\n"; }

if ( $arr{grade} ) {
    print qq{<h3>$lex{Grade} $arr{grade}</h3>\n};
    
} elsif ( $arr{homeroom} ) {
    print qq{<h3>$lex{Homeroom} $arr{homeroom}</h3>\n};

} else {
    print qq{<h3>Entire School</h3>\n};
}


my ($grp, $select, $sortorder);
if ( $arr{grade} ) {
    $grp = $dbh->quote( $arr{grade} );
    $select = "where grade = $grp";
    $sortorder = "grade, lastname, firstname";
    
} elsif ( $arr{homeroom} ) {
    $grp = $dbh->quote( $arr{homeroom} );
    $select = "where homeroom = $grp";
    $sortorder = "homeroom, lastname, firstname";
    
} else {  # all school, no $select value
    $sortorder = "lastname, firstname";
    $grp = "grade";
}

# print qq{<div>Group:$grp Select:$select Sortorder:$sortorder</div>\n};

my $sth = $dbh->prepare("select * from student $select order by $sortorder");
$sth->execute;
if ($DBI::errstr){ print $DBI::errstr; die $DBI::errstr;}

print qq{<table border="1" cellpadding ="3" cellspacing="0">\n};
print qq{<tr><th>$lex{Student}</th><th>$lex{'Parent 1'}</th>\n};
print qq{<th>$lex{'Parent 2'}</th><th>$lex{Emergency}</th></tr>\n};

while ( my $ref = $sth->fetchrow_hashref ) {
    my %r = %$ref;
    
    print qq{<tr><td style="vertical-align:top;"><b>$r{lastname}</b>, $r{firstname} $r{initial}<br>\n};
    print qq{<b>$lex{HRm}</b> $r{homeroom} <b>$lex{Gr}</b> $r{grade}</td>\n};

    # Parent 1
    print qq{<td style="vertical-align:top;">};
    if ( $r{relation1} or $r{par1_lastname} ) {
	print qq{<b>$r{relation1}</b><br>$r{par1_firstname} $r{par1_lastname}\n};
    }

    if ( $r{hphone1} ) {
	print qq{<br>$lex{Home} $r{hphone1}};
    }
    if ( $r{wphone1} ) {
	print qq{<br>$lex{Work} $r{wphone1}};
    }
    if ( $r{cell1} ) {
        print qq{<br>$lex{Cell} $r{cell1}};
    }
    print qq{</td>\n};


    # Parent 2
    print qq{<td style="vertical-align:top;">};
    if ( $r{relation2} or $r{par2_lastname} ) {
	print qq{<b>$r{relation2}</b><br>$r{par2_firstname} $r{par2_lastname}\n};
    }

    if ( $r{hphone2} ) {
	print qq{<br>$lex{Home} $r{hphone2}};
    }
    if ( $r{wphone2} ) {
	print qq{<br>$lex{Work} $r{wphone2}};
    }
    if ( $r{cell2} ) {
        print qq{<br>$lex{Cell} $r{cell2}};
    }
    print qq{</td>\n};



    # Emergency
    print qq{<td style="vertical-align:top;">};
    if ( $r{emrelation} or $r{emname} ) {
	print qq{<b>$r{emrelation}</b><br>$r{emname}\n};
    }
    if ( $r{emhphone} ) {
	print qq{<br>$lex{Home} $r{emhphone}};
    }
    if ( $r{emwphone} ) {
	print qq{<br>$lex{Work} $emwphone};
    }
    if ( $r{emcell} ) {
	print qq{<br>$lex{Cell} $emcell};
    }
    print qq{</td></tr>\n};
  
}


print qq{</table></body></html>\n};


#----------------
sub showStartPage {
#----------------

    my @homerooms;
    my $sth = $dbh->prepare("select distinct homeroom from student 
			    where homeroom is not NULL and homeroom != ''");
    $sth->execute;
    if ( $DBI::errstr ) {print $DBI::errstr; die $DBI::errstr; }
    while ( my $hr = $sth->fetchrow ) {
	push @homerooms, $hr;
    }
    @homerooms = sort {$a <=> $b} @homerooms;
    
    my @grades;
    my $sth = $dbh->prepare("select distinct grade from student 
			    where grade is not NULL and grade != ''");
    $sth->execute;
    if ( $DBI::errstr ) {print $DBI::errstr; die $DBI::errstr; }
    while ( my $gr = $sth->fetchrow ) {
	push @grades, $gr;
    }
    @grades = sort {$a <=> $b} @grades;
    
    
    print qq{<form action="$self" method="post">\n};
    print qq{<input type="hidden" name="page" value="1">\n};

    print qq{<h3>Select Grade or Homeroom</h3>\n};

    # Homeroom
    print qq{<div style="float:left;margin:1em;border:1px solid gray;padding:0.4em;">};
    print qq{<span style="font-weight:bold;font-size:120%;background-color:#CCC;padding:0.2em;">};
    print qq{$lex{Select} $lex{Homeroom}</span>\n};
    foreach my $hr (@homerooms) {
	print qq{<div style="margin:0.2em;"><input type="radio" name="homeroom" value="$hr"> $hr</div>};
    }

    # OR
    print qq{</div><div style="float:left;margin:1em 0;">OR</div>\n\n};

    # Grades
    print qq{<div style="float:left;margin:1em;border:1px solid gray;padding:0.4em;">};
    print qq{<span style="font-weight:bold;font-size:120%;background-color:#CCC;padding:0.2em;">};
    print qq{$lex{Select} $lex{Grade}</span>\n};
    foreach my $gr (@grades) {
	print qq{<div style="margin:0.2em;"><input type="radio" name="grade" value="$gr">$gr</div>};
    }

    # OR
    print qq{</div><div style="float:left;margin:1em 0;">OR</div>\n\n};

    
    print qq{<div style="float:left;margin:1em;border:1px solid gray;padding:0.4em;font-weight:bold;">};
    print qq{$lex{'Blank=All'}</div>\n};
    
    print qq{<br clear="left">\n};
    
    print qq{<p><input style="margin:0 2em;" type="submit" value="$lex{Continue}"></p></form>\n};

    print qq{</body></html>\n};

    exit;
}
